// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.io.Reader;
import java.util.List;

/**
 * class <code>PrubaeReader</code>
 * 	is the reading interface of proration rules from the rulebase.
 * 
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */

public abstract class PrubaeReader {

  // Associations  
  /**
   * variable <code>editor</code> is the prubae editor top class reference.
   * 
   * @uml.property name="editor"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected Prubae editor = null;

  // Constructor  
  /**
   * Creates a new <code>PrubaeReader</code> instance.
   *
   */
  public PrubaeReader() {  
    super();  
  }  

  // Operations
  /**
   * <code>initialize</code> method	initialize rulebase
   *
   */
  public abstract void initialize();

  /**
   * <code>read</code> method	read Rulebase rule description from the file.
   *
   * @param filename a <code>String</code> value
   *	is the filename of the rule file.
   */
  public abstract void read(String filename);

  /**
   * <code>read</code> method
   *	read Rulebase rule descriptions from the reader.
   *
   * @param reader a <code>Reader</code> value
   *	is the reader from which the rule descriptions are read.
   */
  public abstract void read(Reader reader);

  public abstract List	getAllActionExtfs();
  public abstract List	getAllJudgeExtfs();
  public abstract List	getAllValueExtfs();
  public abstract List	getAllParts();

  // Setters and Getters  
  /**
   * <code>setEditor</code> method
   * sets the value of instance variable editor.
   * @param theEditor a <code>Prubae</code> value to set the variable.
   * 
   * @uml.property name="editor"
   */
  public void setEditor(Prubae theEditor) {
    editor = theEditor;
  }

  /**
   * <code>getEditor</code> method
   * gets the value of instance variable setvarList.
   * @return a <code>Prubae</code> value of the variable.
   * 
   * @uml.property name="editor"
   */
  public Prubae getEditor() {
    return editor;
  }

} /* end class PrubaeReader */
