// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * class <code>PrubaeView</code>
 * is the abstract class of prubae rule element model viewing utility.
 * this class has relationship with its model class and controller class,
 * designed according to the Model View Controller design pattern.
 * this class handles the common behavior of the rule element viewing.
 * this class also has model view controller associations
 * and has an association to the editor top class instance.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */

public abstract class PrubaeView implements Cloneable {

  // Associations  
  /**
   * variable <code>model</code> is the reference to the model instance.
   * 
   * @uml.property name="model"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected PrubaeModel model = null;

  /**
   * variable <code>controller</code>
   * is the reference to the controller instance.
   * 
   * @uml.property name="controller"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected PrubaeController controller = null;

  /**
   * variable <code>editor</code>
   * is the reference to the editor top class instance.
   * 
   * @uml.property name="editor"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected Prubae editor = null;


  // Constructor  
  /**
   * Creates a new <code>PrubaeView</code> instance.
   *
   */
  public PrubaeView() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method refreshes the view of the rule element model.
   * it sets the comment string to the comment field on the part panel.
   * and it sets this instance to the current view of the editor instance.
   * refreshes the main panel, and notifies the tree model
   * that the tree node title is possibly changed.
   */
  public void display() {
    /* ;;; this should be cleared */
    getController().getCommentField().setText(getModel().getComment());
    /* ;;; this should be cleared END */
    getEditor().setView(this);
    getEditor().getMainPanel().updateUI();
    DefaultMutableTreeNode
      node = (DefaultMutableTreeNode)getController().getTreeNode();
    if (node != null) {
      getEditor().getTreeModel().nodeChanged(node);
    }
    /* ;;; deBug
    node = getEditor().getController().getTreeNode();
    */
    if (node != null) {
      getEditor().setTreeSelection(node);
    }
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeView	clone = null;
    try {
      clone = (PrubaeView)super.clone();
    }
    catch (CloneNotSupportedException e) {
      return null;
    }
    return clone;
  }

  /**
   * <code>toString</code> method
   * returns the String returned by toString from the model related.
   * @return a <code>String</code> value
   */
  public String	toString() {
    return model.toString();
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="model"
   */
  public void setModel(PrubaeModel theModel) {
    model = theModel;
  }

  /**
   * 
   * @uml.property name="model"
   */
  public PrubaeModel getModel() {
    return model;
  }

  /**
   * 
   * @uml.property name="controller"
   */
  public void setController(PrubaeController theController) {
    controller = theController;
  }

  /**
   * 
   * @uml.property name="controller"
   */
  public PrubaeController getController() {
    return controller;
  }

  /**
   * 
   * @uml.property name="editor"
   */
  public void setEditor(Prubae theEditor) {
    editor = theEditor;
  }

  /**
   * 
   * @uml.property name="editor"
   */
  public Prubae getEditor() {
    return editor;
  }

} /* end class PrubaeView */
