// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;


import gnu.lists.LList;
import gnu.math.IntNum;
import java.awt.Color;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.glj.lisp.Lisp;


/**
 * Describe class <code>PrubaeViewCase</code> here.
 * is the viewing utility class of the prubae rule case-branch element model.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewCase extends PrubaeViewDo {

  // Constructor  
  public PrubaeViewCase() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method
   * displays CaseBranch Statement model Information on the Panel
   * displays argument values of the model on the Panel
   */
  public void display() {
    PrubaeControllerCase	cntl = (PrubaeControllerCase)getController();

    int	numArgs = ((PrubaeModelCase)getModel()).getValues().size();
    cntl.setArgsCount(numArgs);
    cntl.getArgsCountField().setText((new Integer(numArgs)).toString());

    if (cntl.getArgsPanels() == null) {
      cntl.setArgsPanels(new Vector());
    }
    for (int i = 0; i < cntl.getArgsPanels().size(); i++) {
      JPanel	argsPanel = (JPanel)cntl.getArgsPanels().get(i);
      if (cntl.getPanel().isAncestorOf(argsPanel)) {
	cntl.getPanel().remove(argsPanel);
      }
    }
    cntl.getArgsPanels().clear();

    PrubaeModelSwitch	parent = (PrubaeModelSwitch)getModel().getParent();
    /* ;;; add 2009.07.10 start */
    LList
      list = Lisp.append(Lisp.append(Lisp.append(getEditor().getValueList(),
						 getEditor().getVarList()),
				     getEditor().getConstList()),
			 getEditor().getSettablevarList());
    /* ;;; add 2009.07.10 end */
    for (int i = 0; i < numArgs; i++) {

      JPanel	argsPanel = new JPanel();
      argsPanel.setLayout(new BoxLayout(argsPanel, BoxLayout.Y_AXIS));
      argsPanel.setBorder(BorderFactory.createLineBorder(Color.black, 5));

      PrubaeModelValue	child
	= (PrubaeModelValue)((PrubaeModelCase)getModel()).getValues().get(i);
      if (child.getRegist() == ProrateRulebaseElement.CASE_BRANCH_BEGIN) {

	for (int j = 0; j < parent.getVars().size(); j++) {
	  /* ;;; add 2009.07.10 start */
	  PrubaeModel	var = (PrubaeModel)parent.getVars().get(j);
	  LList	valueList = Lisp.assoc(new IntNum(var.getRegist()), list);
	  //System.err.println("PrubaeViewCase.display() : var(" + j + ") : regist = " + ((PrubaeModel)parent.getVars().get(j)).getRegist() + ", valueList = " + valueList);
	  Object type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
	  //System.err.println("PrubaeViewCase.display() : var(" + j + ") : regist = " + ((PrubaeModel)parent.getVars().get(j)).getRegist() + ", type = " + type);
	  /* ;;; add 2009.07.10 end
	  Object
	    type = ((PrubaeModelValue)parent.getVars().get(j)).getType();
	  */
	  PrubaeModelValue
	    gChild = (PrubaeModelValue)child.getValues().get(j);
	  gChild.setRequiredType(type);
	  //System.err.println("PrubaeViewCase.display() : gChild(" + j + ") : regist = " + gChild.getRegist() + ", type = " + gChild.getType() + ", requiredType = " + gChild.getRequiredType());
	  if (gChild instanceof PrubaeModelValueStatement) {
	    gChild.openUI();
	    PrubaeControllerValueStatement
	      gChildCtl =
	      (PrubaeControllerValueStatement)gChild.getController();
	    if (!argsPanel.isAncestorOf(gChildCtl.getPanel())) {
	      argsPanel.add(gChildCtl.getPanel());
	    }
	    PrubaeViewValueStatement
	      gChildView = (PrubaeViewValueStatement)gChild.getView();
	    gChildView.display();
	  }
	}

	if (!cntl.getPanel().isAncestorOf(argsPanel)) {
	  cntl.getPanel().add(argsPanel);
	}
	cntl.getArgsPanels().add(argsPanel);

      }
    }

    super.display();
  }

} /* end class PrubaeViewCase */
