// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.Vector;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;


/**
 * Describe class <code>PrubaeViewDoStatement</code> here.
 * is the viewing utility class of the prubae rule action statement element.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewDoStatement extends PrubaeViewDo {

  // Constructor  
  /**
   * Creates a new <code>PrubaeViewDoStatement</code> instance.
   *
   */
  public PrubaeViewDoStatement() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method
   * displays Action Statement model Information on the Panel
   * sets the appropriate item in the function box of the controller selected,
   * with refering the associated list element matched to current regist code
   * in the doList of the editor.
   * and then display perent value using displayPercent(),
   * and display arguments values using displayArguments().
   */
  public void display() {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    PrubaeControllerDoStatement
      cntl = (PrubaeControllerDoStatement)getController();
    cntl.getStatementField().setText(model.getStatement());
    LList	list = getEditor().getDoList();
    LList	doList = Lisp.assoc(new IntNum(model.getRegist()), list);
    if (doList != null) {
      String	itemStr = null;
      if (model.getRegist()
	  == (short) ProrateRulebaseElement.EXTERNAL_FUNCTION) {
	String	item = model.getStatement();
	int	index = item.indexOf("(");
	if (index >= 0) {
	  item = item.substring(0, index);
	}
	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
	if (!itemStr.equals(item)) {
	  LList	member = Lisp.member(doList, list);
	  for (member = (LList)Lisp.cdr(member);
	       !Lisp.isNil(member);
	       member = (LList)Lisp.cdr(member)) {
	    doList = (LList)Lisp.car(member);
	    itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
	    if (itemStr.equals(item)) {
	      break;
	    }
	  }
	}
      }
      else if (model.getRegist() ==
	       (short) ProrateRulebaseElement.PARTCALL_CODE) {
	String	item = model.getStatement();
	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
	if (!itemStr.equals(item)) {
	  LList	member = Lisp.member(doList, list);
	  for (member = (LList)Lisp.cdr(member);
	       !Lisp.isNil(member);
	       member = (LList)Lisp.cdr(member)) {
	    doList = (LList)Lisp.car(member);
	    itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
	    if (itemStr.equals(item)) {
	      break;
	    }
	  }
	}
      }
      else {
	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
      }
      if (cntl.getFunctionBox() != null
	  && cntl.getFunctionBox().getSelectedItem() != null
	  && !cntl.getFunctionBox().getSelectedItem().equals(itemStr)) {
	PrubaeComboItem	item = cntl.getComboItem(itemStr);
	cntl.inactivateSelection();
	cntl.getFunctionBox().setSelectedItem(item);
	cntl.activateSelection();
      }
      /* percent */
      displayPercent(doList);
      /* arguments */
      displayArguments(doList);
    }
    super.display();
  }

  /**
   * <code>displayPercent</code> method
   * displays percent values of the model on the Panel if required.
   * sets the percent value string in the percent field of the controller,
   * and make the field visible if the statement is the percent settable.
   * @param doList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the doList of the editor.
   */
  private void	displayPercent(LList doList) {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    PrubaeControllerDoStatement
      cntl = (PrubaeControllerDoStatement)getController();
    Object	isPercent = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList))));
    if (isPercent == null || Lisp.isNil(isPercent)) {
      cntl.getPercentField().setText("");
      cntl.getPercentPanel().setVisible(false);
    }
    else {
      if (model.getPercent() != (double)0) {
	String	percentStr = Double.toString(model.getPercent());
	cntl.getPercentField().setText(percentStr);
      }
      else {
	cntl.getPercentField().setText("");
      }
      cntl.getPercentPanel().setVisible(true);
    }
  }

  /**
   * <code>displayArguments</code> method
   * displays argument values of the model on the Panel
   * if the statement is AMOUNT rule element model,
   * it sets currency and amount string to the fields of the controller.
   * otherwise, for all argument models in values list,
   * creates view/controller and GUI elements by sending openUI() to them,
   * adds their panels on the panel of the controller,
   * and by sending display to their view, display their values.
   * @param doList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the doList of the editor.
   */
  private void	displayArguments(LList doList) {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    PrubaeControllerDoStatement
      cntl = (PrubaeControllerDoStatement)getController();
    cntl.getAmountPanel().setVisible(false);
    Object
      isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
    if (isArgs == null) {
      return;
    }
    else if (!(isArgs instanceof IntNum)) {
      return;
    }
    int	numArgs = ((IntNum)isArgs).intValue();
    if (numArgs <= 0) {
      return;
    }
    Object
      listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
    Object[]	typeArgs = new Object[numArgs];
    for (int i = 0; i < numArgs; i++) {
      typeArgs[i] = Lisp.car(listArgs);
      listArgs = Lisp.cdr(listArgs);
      //System.err.println("PrubaeViewDoStatement.displayArguments(): typeArgs[" + i + "] = " + typeArgs[i]);
    }
    if (numArgs == 1
	&& typeArgs[0] != null && typeArgs[0].equals("setamount")) {
      /* amount */
      if (model.getValues() != null && model.getValues().size() >= 2) {
	String	currencyStr = (String)model.getValues().get(0);
	String
	  amountStr = ((Double)model.getValues().get(1)).toString();
	cntl.getCurrencyField().setText(currencyStr);
	cntl.getAmountField().setText(amountStr);
      }
      else {
	cntl.getCurrencyField().setText("");
	cntl.getAmountField().setText("");
      }
      cntl.getAmountPanel().setVisible(true);
    }
    else {
      if (model.getValues() == null && numArgs != 0) {
	model.setValues(new Vector());
      }
      System.err.println("childView numArgs = " + numArgs + ", values = "
			 + model.getValues().size());
      for (int i = 0; i < numArgs; i++) {
	if (model.getValues().size() < i + 1) {
	  PrubaeModelValue	value = new PrubaeModelValueStatement();
	  value.initialize(model.getEditor(), model, model.getValues());
	  model.getValues().add(value);
	}
	PrubaeModelValue
	  child = (PrubaeModelValue)model.getValues().get(i);
	if (child instanceof PrubaeModelValueStatement) {
	  if (i > 0 && typeArgs[i] != null && typeArgs[i].equals("first")) {
	    child
	      .setRequiredType(((PrubaeModelValue)model.getValues().get(0))
			       .getType());
	  }
	  /* ;;; 2009.07.10 add start */
	  else if (i > 0
		   && (getModel().getRegist()
		       == ProrateRulebaseElement.MULTIVAL_CODE)
		   && (((PrubaeModelValue)getModel()).getRequiredType()
		       != null)) {
	    //System.err.println("PrubaeViewDoStatement.displayArguments(): model =" + getModel() + ", requiredType = " + ((PrubaeModelValue)getModel()).getRequiredType());
	    child.setRequiredType(((PrubaeModelValue)getModel())
				  .getRequiredType());
	  }
	  else if (i > 0
		   && (getModel().getRegist()
		       == ProrateRulebaseElement.MULTIVAL_CODE)
		   && ((PrubaeModelValue)getModel()).getType() != null) {
	    //System.err.println("PrubaeViewDoStatement.displayArguments(): model = " + getModel() + ", type = " + ((PrubaeModelValue)getModel()).getType());
	    child.setRequiredType(((PrubaeModelValue)getModel()).getType());
	  }
	  /*;;; 2009.07.10 add end */
	  /* ;;; 2009.07.15 add start */
	  else if (i > 0
		   && (getModel().getRegist()
		       == ProrateRulebaseElement.INTERVAL_CODE)
		   && (((PrubaeModelValue)getModel()).getRequiredType()
		       != null)) {
	    //System.err.println("PrubaeViewDoStatement.displayArguments(): model =" + getModel() + ", requiredType = " + ((PrubaeModelValue)getModel()).getRequiredType());
	    child.setRequiredType(((PrubaeModelValue)getModel())
				  .getRequiredType());
	  }
	  else if (i > 0
		   && (getModel().getRegist()
		       == ProrateRulebaseElement.INTERVAL_CODE)
		   && ((PrubaeModelValue)getModel()).getType() != null) {
	    //System.err.println("PrubaeViewDoStatement.displayArguments(): model = " + getModel() + ", type = " + ((PrubaeModelValue)getModel()).getType());
	    child.setRequiredType(((PrubaeModelValue)getModel()).getType());
	  }
	  /*;;; 2009.07.15 add end */
	  else if (typeArgs[i] != null) {
	    child.setRequiredType(typeArgs[i]);
	  }
	  child.openUI();
	  PrubaeControllerValueStatement
	    childCtl = (PrubaeControllerValueStatement)child.getController();
	  if (!cntl.getPanel().isAncestorOf(childCtl.getPanel())) {
	    cntl.getPanel().add(childCtl.getPanel());
	  }
	  PrubaeViewValueStatement
	    childView = (PrubaeViewValueStatement)child.getView();
	  childView.display();
	}
	else {
	  /* not implemented yet */
	}
      }
    }
  }

} /* end class PrubaeViewDoStatement */
