// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.util.Vector;

import javax.swing.JTextField;

/**
 * class <code>PrubaeViewFunction</code>
 * is the viewing utility class of the prubae rule function element model.
 * this class displays the attributes of SPA, APDP, EXTF or PART rule
 * top element.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewFunction extends PrubaeView {

  // Constructor  
  /**
   * Creates a new <code>PrubaeViewFunction</code> instance.
   *
   */
  public PrubaeViewFunction() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method refreshes the view of the rule element model.
   * it sets the carrier, tkcarrier strings, and valid from/until date strings
   * to the text field on the part panel, when the rule is SPA or APDP.
   * it sets the function name to the text field on the part panel,
   * when the rule is EXTF.
   * then using super.display*( refreshes the screen and tree nodes.
   */
  public void display() {
    PrubaeModelFunction	model = (PrubaeModelFunction)getModel();
    PrubaeControllerFunction
      cntl = (PrubaeControllerFunction)getController();
    if (model.getFunctionType() == PrubaeModelFunction.SPA
	|| model.getFunctionType() == PrubaeModelFunction.APDP) {
      cntl.getFirstField().setText(model.getCarrier());
      if (model.getFunctionType() == PrubaeModelFunction.SPA) {
	cntl.getSecondField().setText(model.getTkCarrier());
      }
      if (model.getFromDate() > 0) {
	cntl.getFromDate().setText(Integer.toString(model.getFromDate()));
      }
      if (model.getToDate() > 0) {
	cntl.getToDate().setText(Integer.toString(model.getToDate()));
      }
    }
    else if (model.getFunctionType() == PrubaeModelFunction.EXTF) {
      cntl.getNameField().setText(model.getName());
      int	extfReturnType = model.getExtfReturnType();
      if (extfReturnType == PrubaeModelFunction.ExtfReturnJudgement) {
	cntl.getJudgeButton().setSelected(true);
      }
      else if (extfReturnType == PrubaeModelFunction.ExtfReturnAction) {
	cntl.getActionButton().setSelected(true);
      }
      else if (extfReturnType == PrubaeModelFunction.ExtfReturnValue) {
	cntl.getValueButton().setSelected(true);
      }
      int	argsCount = 0;
      if (model.getArgs() != null) {
	argsCount = model.getArgs().size();
      }
      cntl.getArgsCountField().setText(Integer.toString(argsCount));
      if (cntl.getArgFields() == null) {
	cntl.setArgFields(new Vector());
      }
      for (int i = 0; i < argsCount; i++) {
	String	arg = (String)model.getArgs().get(i);
	JTextField	argField = null;
	if (i < cntl.getArgFields().size()) {
	  argField = (JTextField)cntl.getArgFields().get(i);
	}
	else {
	  argField = new JTextField();
	  cntl.getArgFields().add(argField);
	  cntl.getArgumentPanel().add(argField);
	}
	System.err.println("arg " + i + " before : " + argField.getText());
	argField.setText(arg);
	System.err.println("arg " + i + " : " + argField.getText());
      }
    }
    else if (model.getFunctionType() == PrubaeModelFunction.PART) {
      cntl.getNameField().setText(model.getName());
    }

    super.display();
  }

} /* end class PrubaeViewFunction */
