// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.Vector;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;


/**
 * class <code>PrubaeViewJudgeStatement</code>
 * is the viewing utility class of the prubae rule judge statement element.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewJudgeStatement extends PrubaeViewJudge {

  // Constructor  
  /**
   * Creates a new <code>PrubaeViewJudgeStatement</code> instance.
   *
   */
  public PrubaeViewJudgeStatement() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method
   * displays Judge Statement model Information on the Panel
   * sets the appropriate item in the function box of the controller selected,
   * with refering the associated list element matched to current regist code
   * in the judgeList of the editor.
   * and then display arguments values using displayArguments().
   */
  public void display() {
    PrubaeModelJudgeStatement	model = (PrubaeModelJudgeStatement)getModel();
    PrubaeControllerJudgeStatement
      cntl = (PrubaeControllerJudgeStatement)getController();
    cntl.getStatementField().setText(model.getStatement());
    LList	list = getEditor().getJudgeList();
    LList	judgeList = Lisp.assoc(new IntNum(model.getRegist()), list);
    if (judgeList != null) {
      String	itemStr = null;
      if (model.getRegist()
	  == (short) ProrateRulebaseElement.EXTERNAL_FUNCTION) {
	String	item = model.getStatement();
	int	index = item.indexOf("(");
	if (index >= 0) {
	  item = item.substring(0, index);
	}
	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(judgeList)))).toString();
	if (!itemStr.equals(item)) {
	  LList	member = Lisp.member(judgeList, list);
	  for (member = (LList)Lisp.cdr(member);
	       !Lisp.isNil(member);
	       member = (LList)Lisp.cdr(member)) {
	    judgeList = (LList)Lisp.car(member);
	    itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(judgeList)))).toString();
	    if (itemStr.equals(item)) {
	      break;
	    }
	  }
	}
      }
      else {
	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(judgeList)))).toString();
      }
      if (cntl.getFunctionBox() != null
	  && cntl.getFunctionBox().getSelectedItem() != null
	  && !cntl.getFunctionBox().getSelectedItem().equals(itemStr)) {
	PrubaeComboItem	item = cntl.getComboItem(itemStr);
	cntl.inactivateSelection();
	cntl.getFunctionBox().setSelectedItem(item);
	cntl.activateSelection();
      }
      /* arguments */
      displayArguments(judgeList);
    }
    super.display();
  }

  /**
   * <code>displayArguments</code> method
   * displays argument values of the model on the Panel.
   * for all argument models in values list,
   * creates view/controller and GUI elements by sending openUI() to them,
   * adds their panels on the panel of the controller,
   * and by sending display to their view, display their values.
   * @param judgeList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the judgeList of the editor.
   */
  private void	displayArguments(LList judgeList) {
    PrubaeModelJudgeStatement	model = (PrubaeModelJudgeStatement)getModel();
    PrubaeControllerJudgeStatement
      cntl = (PrubaeControllerJudgeStatement)getController();
    Object	isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
    if (isArgs == null) {
      return;
    }
    else if (!(isArgs instanceof IntNum)) {
      return;
    }
    int	numArgs = ((IntNum)isArgs).intValue();
    if (numArgs <= 0) {
      return;
    }
    Object	listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
    Object[]	typeArgs = new Object[numArgs];
    for (int i = 0; i < numArgs; i++) {
      typeArgs[i] = Lisp.car(listArgs);
      listArgs = Lisp.cdr(listArgs);
    }
    if (model.getValues() == null && numArgs != 0) {
      model.setValues(new Vector());
    }
    System.err.println("childView numArgs = " + numArgs + ", values = "
		       + model.getValues().size());
    for (int i = 0; i < numArgs; i++) {
      if (model.getValues().size() < i + 1) {
	PrubaeModelValue	value = new PrubaeModelValueStatement();
	value.initialize(model.getEditor(), model, model.getValues());
	model.getValues().add(value);
      }
      PrubaeModelValue
	child = (PrubaeModelValue)model.getValues().get(i);
      if (child instanceof PrubaeModelValueStatement) {
	if (i > 0 && typeArgs[i] != null && typeArgs[i].equals("first")) {
	  child
	    .setRequiredType(((PrubaeModelValue)model.getValues().get(0))
			     .getType());
	}
	/* ;;; 2009.07.10 add start */
	else if (i > 0
		 && (getModel().getRegist()
		     == ProrateRulebaseElement.MULTIVAL_CODE)
		 && ((PrubaeModelValue)getModel()).getRequiredType() != null) {
	  //System.err.println("PrubaeViewJudgeStatement.displayArguments(): model =" + getModel() + ", requiredType = " + ((PrubaeModelValue)getModel()).getRequiredType());
	  child.setRequiredType(((PrubaeModelValue)getModel())
				.getRequiredType());
	}
	else if (i > 0
		 && (getModel().getRegist()
		     == ProrateRulebaseElement.MULTIVAL_CODE)
		 && ((PrubaeModelValue)getModel()).getType() != null) {
	  //System.err.println("PrubaeViewJudgeStatement.displayArguments(): model = " + getModel() + ", type = " + ((PrubaeModelValue)getModel()).getType());
	  child.setRequiredType(((PrubaeModelValue)getModel()).getType());
	}
	/* ;;; 2009.07.10 add end */
	/* ;;; 2009.07.15 add start */
	else if (i > 0
		 && (getModel().getRegist()
		     == ProrateRulebaseElement.INTERVAL_CODE)
		 && ((PrubaeModelValue)getModel()).getRequiredType() != null) {
	  //System.err.println("PrubaeViewJudgeStatement.displayArguments(): model =" + getModel() + ", requiredType = " + ((PrubaeModelValue)getModel()).getRequiredType());
	  child.setRequiredType(((PrubaeModelValue)getModel())
				.getRequiredType());
	}
	else if (i > 0
		 && (getModel().getRegist()
		     == ProrateRulebaseElement.INTERVAL_CODE)
		 && ((PrubaeModelValue)getModel()).getType() != null) {
	  //System.err.println("PrubaeViewJudgeStatement.displayArguments(): model = " + getModel() + ", type = " + ((PrubaeModelValue)getModel()).getType());
	  child.setRequiredType(((PrubaeModelValue)getModel()).getType());
	}
	/* ;;; 2009.07.15 add end */
	else if (typeArgs[i] != null) {
	  child.setRequiredType(typeArgs[i]);
	}
	child.openUI();
	/* ;;; 2006.09.13 */
	PrubaeViewValueStatement
	  childView = (PrubaeViewValueStatement)child.getView();
	childView.display();
	PrubaeControllerValueStatement
	  childCtl = (PrubaeControllerValueStatement)child.getController();
	if (!cntl.getPanel().isAncestorOf(childCtl.getPanel())) {
	  cntl.getPanel().add(childCtl.getPanel());
	}
      }
      else {
	/* not implemented yet */
      }
    }
  }

} /* end class PrubaeViewJudgeStatement */
