// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

/**
 * Describe class <code>PrubaeViewSwitch</code> here.
 * is the viewing utility class of the prubae rule case-statement element.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewSwitch extends PrubaeViewDo {

  // Constructor  
  /**
   * Creates a new <code>PrubaeViewSwitch</code> instance.
   *
   */
  public PrubaeViewSwitch() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method
   * displays Case Statement model Information on the Panel
   * displays argument values of the model on the Panel
   */
  public void display() {
    PrubaeControllerSwitch	cntl = (PrubaeControllerSwitch)getController();
    int	numArgs = ((PrubaeModelSwitch)getModel()).getVars().size();
    cntl.setArgsCount(numArgs);
    cntl.getArgsCountField().setText((new Integer(numArgs)).toString());
    for (int i = 0; i < numArgs; i++) {
      PrubaeModelValue	child
	= (PrubaeModelValue)((PrubaeModelSwitch)getModel()).getVars().get(i);
      if (child instanceof PrubaeModelValueStatement) {
	child.openUI();
	PrubaeControllerValueStatement
	  childCtl = (PrubaeControllerValueStatement)child.getController();
	if (!cntl.getPanel().isAncestorOf(childCtl.getPanel())) {
	  cntl.getPanel().add(childCtl.getPanel());
	}
	PrubaeViewValueStatement
	  childView = (PrubaeViewValueStatement)child.getView();
	childView.display();
      }
      else {
	/* not implemented yet */
      }
    }
    super.display();
  }

} /* end class PrubaeViewSwitch */
