// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import jp.sourceforge.glj.lisp.Lisp;
import gnu.lists.LList;
import gnu.math.IntNum;

/**
 * Describe class <code>PrubaeViewTable</code> here.
 * is the viewing utility class of the prubae rule table-statement element.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewTable extends PrubaeViewDo {

  // Constructor  
  /**
   * Creates a new <code>PrubaeViewTable</code> instance.
   *
   */
  public PrubaeViewTable() {  
    super();  
  }

  // Operations  
  /**
   * <code>display</code> method not implemented yet. *FIXME*
   *
   */
  public void display() {
    PrubaeControllerTable	cntl = (PrubaeControllerTable)getController();
    if (((PrubaeModelTable)getModel()).getVarRow() != null) {
      cntl.getRowButton().setSelected(true);
      cntl.getColButton().setSelected(false);
      PrubaeModelValue	varRow
	= (PrubaeModelValue)((PrubaeModelTable)getModel()).getVarRow();
      /* ;;; add 2009.07.15 start */
      LList
	list = Lisp.append(Lisp.append(Lisp.append(getEditor().getValueList(),
						   getEditor().getVarList()),
				       getEditor().getConstList()),
			   getEditor().getSettablevarList());
      LList	valueList = Lisp.assoc(new IntNum(varRow.getRegist()), list);
      Object	type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
      /* ;;; add 2009.07.15 end */
      if (varRow instanceof PrubaeModelValueStatement) {
	varRow.openUI();
	PrubaeControllerValueStatement
	  varRowCtl = (PrubaeControllerValueStatement)varRow.getController();
	if (!cntl.getVarRowPanel().isAncestorOf(varRowCtl.getPanel())) {
	  cntl.getVarRowPanel().add(varRowCtl.getPanel());
	}
	PrubaeViewValueStatement
	  varRowView = (PrubaeViewValueStatement)varRow.getView();
	varRowView.display();
      }
      else {
	/* not implemented yet */
      }
      int	numRows = ((PrubaeModelTable)getModel()).getRows().size();
      cntl.setRowsCount(numRows);
      cntl.getRowsCountField().setText((new Integer(numRows)).toString());
      for (int i = 0; i < numRows; i++) {
	PrubaeModelValue	child
	  = (PrubaeModelValue)((PrubaeModelTable)getModel()).getRows().get(i);
	if (child instanceof PrubaeModelValueStatement) {
	  child.setRequiredType(type);	/* ;;; add 2009.07.15 */
	  child.openUI();
	  PrubaeControllerValueStatement
	    childCtl = (PrubaeControllerValueStatement)child.getController();
	  if (!cntl.getRowPanel().isAncestorOf(childCtl.getPanel())) {
	    cntl.getRowPanel().add(childCtl.getPanel());
	  }
	  PrubaeViewValueStatement
	    childView = (PrubaeViewValueStatement)child.getView();
	  childView.display();
	}
	else {
	  /* not implemented yet */
	}
      }
      if (!cntl.getPanel().isAncestorOf(cntl.getRowPanel())) {
	cntl.getPanel().add(cntl.getRowPanel(), 3);
      }
    }
    else {
      cntl.getRowButton().setSelected(false);
      cntl.getColButton().setSelected(true);
      if (cntl.getPanel().isAncestorOf(cntl.getRowPanel())) {
	cntl.getPanel().remove(cntl.getRowPanel());
      }
    }
    PrubaeModelValue	varCol
      = (PrubaeModelValue)((PrubaeModelTable)getModel()).getVarCol();
    /* ;;; add 2009.07.15 start */
    LList
      list = Lisp.append(Lisp.append(Lisp.append(getEditor().getValueList(),
						 getEditor().getVarList()),
				     getEditor().getConstList()),
			 getEditor().getSettablevarList());
    LList	valueList = Lisp.assoc(new IntNum(varCol.getRegist()), list);
    Object	type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
      /* ;;; add 2009.07.15 end */
    if (varCol instanceof PrubaeModelValueStatement) {
      varCol.openUI();
      PrubaeControllerValueStatement
	varColCtl = (PrubaeControllerValueStatement)varCol.getController();
      if (!cntl.getVarColPanel().isAncestorOf(varColCtl.getPanel())) {
	cntl.getVarColPanel().add(varColCtl.getPanel());
      }
      PrubaeViewValueStatement
	varColView = (PrubaeViewValueStatement)varCol.getView();
      varColView.display();
    }
    else {
      /* not implemented yet */
    }
    int	numCols = ((PrubaeModelTable)getModel()).getCols().size();
    cntl.setColsCount(numCols);
    cntl.getColsCountField().setText((new Integer(numCols)).toString());
    for (int i = 0; i < numCols; i++) {
      PrubaeModelValue	child
	= (PrubaeModelValue)((PrubaeModelTable)getModel()).getCols().get(i);
      if (child instanceof PrubaeModelValueStatement) {
	child.setRequiredType(type);	/* ;;; add 2009.07.15 */
	child.openUI();
	PrubaeControllerValueStatement
	  childCtl = (PrubaeControllerValueStatement)child.getController();
	if (!cntl.getColPanel().isAncestorOf(childCtl.getPanel())) {
	  cntl.getColPanel().add(childCtl.getPanel());
	}
	PrubaeViewValueStatement
	  childView = (PrubaeViewValueStatement)child.getView();
	childView.display();
      }
      else {
	/* not implemented yet */
      }
    }
    if (!cntl.getPanel().isAncestorOf(cntl.getColPanel())) {
      int
	index = (((PrubaeModelTable)getModel()).getVarRow() != null) ? 4 : 3;
      cntl.getPanel().add(cntl.getColPanel(), index);
    }
    cntl.updateTable();
    super.display();
  }

} /* end class PrubaeViewTable */
