// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.Vector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.glj.lisp.Lisp;

/**
 * class <code>PrubaeViewValueStatement</code>
 * is the viewing utility class of the prubae rule value statement element.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeViewValueStatement extends PrubaeView {

  /* ;;; add 2009.07.17 start */
  /**
   * constant <code>numArgsInitialValue</code>	initial value of number of args
   *
   */
  static final int	numArgsInitialValue = 2;
  /* ;;; add 2009.07.17 end */

  // Constructor
  /**
   * Creates a new <code>PrubaeViewValueStatement</code> instance.
   *
   */
  public PrubaeViewValueStatement() {
    super();
  }

  // Operations
  /**
   * Describe <code>display</code> method here.
   * displays Value Statement model Information on the Panel
   * sets the appropriate item in the function box of the controller selected,
   * with refering the associated list element matched to current regist code
   * in the valueList, varList or constList of the editor.
   * and then display constant value using displayConst(),
   * and display arguments values using displayArguments().
   */
  public void display() {
    PrubaeModelValueStatement	model = (PrubaeModelValueStatement)getModel();
    PrubaeModel	parent = model.getParent();
    PrubaeControllerValueStatement
      cntl = (PrubaeControllerValueStatement)getController();
    cntl.getStatementField().setText(model.getStatement());
    LList
      list = Lisp.append(Lisp.append(getEditor().getValueList(),
				     getEditor().getVarList()),
			 getEditor().getConstList());
    LList	valueList = null;
    if ((model.getRegist()
	 & ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION)
	== ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION) {
      LList	top = Lisp.assoc(new IntNum(model.getRegist()), list);
      LList	autoList = Lisp.member(top, list);
      for ( ; !Lisp.isNil(autoList); autoList = (LList)Lisp.cdr(autoList)) {
	IntNum	registNum = (IntNum)Lisp.car(Lisp.car(autoList));
	int	regist = registNum.intValue();
	if ((regist & ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION)
	    != ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION) {
	  break;
	}
	if (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.car(autoList))))
	    .equals(model.getStatement())) {
	  valueList = (LList)Lisp.car(autoList);
	  break;
	}
      }
    }
    else if (model.getRegist()
	     == (short) ProrateRulebaseElement.EXTERNAL_FUNCTION) {
      LList	top = Lisp.assoc(new IntNum(model.getRegist()), list);
      LList	extfList = Lisp.member(top, list);
      for (int i = 0; !Lisp.isNil(extfList);
	   extfList = (LList)Lisp.cdr(extfList), i++) {
	IntNum	registNum = (IntNum)Lisp.car(Lisp.car(extfList));
	int	regist = registNum.intValue();
	if (regist != ProrateRulebaseElement.EXTERNAL_FUNCTION) {
	  break;
	}
	String	item = model.getName();
	int	index = item.indexOf("(");
	if (index >= 0) {
	  item = item.substring(0, index);
	}
	String	itemStr =
	  (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.car(extfList))))).toString();
	if (itemStr.equals(item)) {
	  valueList = (LList)Lisp.car(extfList);
	  break;
	}
      }
    }
    else {
      valueList = Lisp.assoc(new IntNum(model.getRegist()), list);
    }
    //System.err.println("PrubaeViewValueStatement.display() : regist = " + model.getRegist() + ", valueList = " + valueList);
    if (valueList != null) {
      String	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(valueList)))).toString();
      //System.err.println("PrubaeViewValueStatement.display() : itemStr = " + itemStr);
      Object	type = (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList)))));
      //System.err.println("PrubaeViewValueStatement.display() : type = " + type);
      if (type.equals("any")) {
	type = null;
      }
      else if (type instanceof String && ((String)type).length() > 3
	       && ((String)type).substring(0, 3).equals("set")) {
	type = ((String)type).substring(3);
      }
      /* ;;; 2006.09.06
      if (type != null) {
	model.setType(type);
      }
      */
      if (type != null
	  && parent instanceof PrubaeModelValue
	  && ((PrubaeModelValue)parent).getType() == null
	  && ((PrubaeModelValue)parent).getValues().get(0) == model) {
	((PrubaeModelValue)parent).setType(type);
      }
      //System.err.println("PrubaeViewValueStatement.display() before setSelectedItem() : itemStr = " + itemStr + ", functionBox.selectedItem = " + (cntl.getFunctionBox() == null ? "null" : cntl.getFunctionBox().getSelectedItem()));
      PrubaeComboItem	item = cntl.getComboItem(itemStr);
      if (cntl.getFunctionBox() != null
	  && cntl.getFunctionBox().getSelectedItem() != null
	  && !cntl.getFunctionBox().getSelectedItem().equals(item)) {
	//System.err.println("PrubaeViewValueStatement.display() requiredType = " + ((PrubaeModelValueStatement)model).getRequiredType());
	//System.err.println("PrubaeViewValueStatement.display() getComboItem(" + itemStr + ") :  = " + item);
	cntl.inactivateSelection();
	cntl.getFunctionBox().setSelectedItem(item);
	cntl.activateSelection();
      }
      //System.err.println("PrubaeViewValueStatement.display() after setSelectedItem() : itemStr = " + itemStr + ", functionBox.selectedItem = " + (cntl.getFunctionBox() == null ? "null" : cntl.getFunctionBox().getSelectedItem()));
      /* constant values */
      displayConst(valueList);
      /* arguments */
      displayArguments(valueList);
    }
    /* ;;; 2006.09.06 */
    PrubaeController parentCntl = parent.getController();
    if (parentCntl != null && parentCntl.getPanel() != null
	&& !(parentCntl instanceof PrubaeControllerTable)
	&& cntl != null && cntl.getPanel() != null
	&& !parentCntl.getPanel().isAncestorOf(cntl.getPanel())) {
      parentCntl.getPanel().add(cntl.getPanel());
    }
    super.display();
  }

  /**
   * <code>displayConst</code> method
   * displays constant values of the model on the Panel.
   * if the value is number, set the number string
   * to the number field on the panel, and make the field visible.
   * if the value is date, set the month and day string
   * to the month and day field on the panel, and make the fields visible.
   * if the value is string, set the string value
   * to the string field on the panel, and make the field visible.
   * if the value is amount, set the currency and amount string
   * to the currency/amount field on the panel, and make the fields visible.
   * @param valueList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the valueList, varList or constList of the editor.
   */
  private void	displayConst(LList valueList) {
    PrubaeModelValueStatement	model = (PrubaeModelValueStatement)getModel();
    PrubaeControllerValueStatement
      cntl = (PrubaeControllerValueStatement)getController();
    Object	type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
    cntl.getNumberPanel().setVisible(false);
    cntl.getDatePanel().setVisible(false);
    cntl.getStringPanel().setVisible(false);
    cntl.getAmountPanel().setVisible(false);
    if (type == null) {
      return;
    }
    if (type.equals("setnumber")) {
      /* set number statement */
      String	numberStr = ((Double)model.getValues().get(0)).toString();
      cntl.getNumberField().setText(numberStr);
      cntl.getNumberPanel().setVisible(true);
    }
    else if (type.equals("setdate")) {
      /* set date statement */
      String	monthStr = ((Short)model.getValues().get(0)).toString();
      cntl.getMonthField().setText(monthStr);
      String	dayStr = ((Short)model.getValues().get(1)).toString();
      cntl.getDayField().setText(dayStr);
      cntl.getDatePanel().setVisible(true);
    }
    else if (type.equals("setstring")) {
      /* set date statement */
      cntl.getStringField().setText((String)model.getValues().get(0));
      cntl.getStringPanel().setVisible(true);
    }
    else if (type.equals("setamount")) {
      /* set amount statement */
      cntl.getCurrencyField().setText((String)model.getValues().get(0));
      String	amountStr = ((Double)model.getValues().get(1)).toString();
      cntl.getAmountField().setText(amountStr);
      cntl.getAmountPanel().setVisible(true);
    }
  }

  /**
   * <code>displayArguments</code> method
   * displays argument values of the model on the Panel.
   * for all argument models in values list,
   * creates view/controller and GUI elements by sending openUI() to them,
   * adds their panels on the panel of the controller,
   * and by sending display to their view, display their values.
   * @param valueList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the valueList, varList or constList of the editor.
   */
  private void	displayArguments(LList valueList) {
    PrubaeModelValueStatement	model = (PrubaeModelValueStatement)getModel();
    PrubaeControllerValueStatement
      cntl = (PrubaeControllerValueStatement)getController();
    //System.err.println("PrubaeViewValueStatement.displayArguments() : model = " + model + ", cntl = " + cntl);
    Object
      isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList)))));
    //System.err.println("PrubaeViewValueStatement.displayArguments() : valueList = " + valueList + ", isArgs = " + isArgs);
    if (isArgs == null) {
      cntl.getArgsCountPanel().setVisible(false);	/* add 2009.07.17 */
      return;
    }
    else if (!(isArgs instanceof IntNum)) {
      cntl.getArgsCountPanel().setVisible(false);	/* add 2009.07.17 */
      return;
    }
    int	numArgs = ((IntNum)isArgs).intValue();
    if (numArgs < 0) {
      /* ;;; add 2009.07.07 */
      if (model.getValues() == null) {
	model.setValues(new Vector());
      }
      //System.err.println("PrubaeViewValueStatement.displayArguments() : numArgs < 0, model = " + model + ", model.values = " + (model == null? "null" : model.getValues()));
      numArgs = model.getValues().size();
      cntl.setArgsCount(numArgs);
      cntl.getArgsCountField().setText((new Integer(numArgs)).toString());
      cntl.getArgsCountPanel().setVisible(true);
    }
    /* ;;; add 2009.07.17 start */
    else {
      if (model.getValues() == null && numArgs != 0) {
	model.setValues(new Vector());
      }
      cntl.getArgsCountPanel().setVisible(false);
    }
    /* ;;; add 2009.07.17 end */
    //System.err.println("PrubaeViewValueStatement.displayArguments() : numArgs = " + numArgs);
    if (numArgs <= 0) {
      return;
    }
    Object
      listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList)))));
    //System.err.println("PrubaeViewValueStatement.displayArguments() : listArgs = " + listArgs);
    Object[]	typeArgs = new Object[numArgs];
    /* ;;;
    System.err.print("PrubaeViewValueStatement.displayArguments() : ");
    for (int i = 0; i < numArgs; i++) {
      typeArgs[i] = Lisp.car(listArgs);
      System.err.print("typeArgs[" + i + "] = " + typeArgs[i] + " ");
      listArgs = Lisp.cdr(listArgs);
    }
    System.err.println("");
    */
    for (int i = 0; i < numArgs; i++) {
      if (model.getValues().size() < i + 1) {
	PrubaeModelValue	value = new PrubaeModelValue();
	value.initialize(model.getEditor(), model, model.getValues());
	model.getValues().add(value);
      }
      PrubaeModelValue
	child = (PrubaeModelValue)model.getValues().get(i);
      if (child instanceof PrubaeModelValueStatement) {
	/* ;;; 2009.07.10 modify and add start */
	if (model.getRegist() == ProrateRulebaseElement.MULTIVAL_CODE
	    && ((PrubaeModelValue)model).getRequiredType() != null) {
	  //System.err.println("PrubaeViewValueStatement.displayArguments(): model =" + model + ", requiredType = " + ((PrubaeModelValue)model).getRequiredType());
	  child.setRequiredType(((PrubaeModelValue)model).getRequiredType());
	}
	else if (model.getRegist() == ProrateRulebaseElement.MULTIVAL_CODE
	    && ((PrubaeModelValue)model).getType() != null) {
	  //System.err.println("PrubaeViewValueStatement.displayArguments(): model = " + model + ", type = " + ((PrubaeModelValue)model).getType());
	  child.setRequiredType(((PrubaeModelValue)model).getType());
	}
	/* ;;; 2009.07.10 modify and add end */
	/* ;;; 2009.07.15 modify and add start */
	else if (model.getRegist() == ProrateRulebaseElement.INTERVAL_CODE
		 && ((PrubaeModelValue)model).getRequiredType() != null) {
	  //System.err.println("PrubaeViewValueStatement.displayArguments(): model =" + model + ", requiredType = " + ((PrubaeModelValue)model).getRequiredType());
	  child.setRequiredType(((PrubaeModelValue)model).getRequiredType());
	}
	else if (model.getRegist() == ProrateRulebaseElement.INTERVAL_CODE
	    && ((PrubaeModelValue)model).getType() != null) {
	  //System.err.println("PrubaeViewValueStatement.displayArguments(): model = " + model + ", type = " + ((PrubaeModelValue)model).getType());
	  child.setRequiredType(((PrubaeModelValue)model).getType());
	}
	/* ;;; 2009.07.15 modify and add end */
	else if (i > 0 && typeArgs[i] != null && typeArgs[i].equals("first")) {
	  child
	    .setRequiredType(((PrubaeModelValue)model.getValues().get(0))
			     .getType());
	}
	else if (typeArgs[i] != null) {
	  child.setRequiredType(typeArgs[i]);
	}
	child.openUI();
	PrubaeControllerValueStatement
	  childCtl = (PrubaeControllerValueStatement)child.getController();
	if (!cntl.getPanel().isAncestorOf(childCtl.getPanel())) {
	  cntl.getPanel().add(childCtl.getPanel());
	}
	PrubaeViewValueStatement
	  childView = (PrubaeViewValueStatement)child.getView();
	childView.display();
      }
    }
  }

} /* end class PrubaeViewValueStatement */
