// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;

/**
 * class <code>PrubaeWriter</code>
 * 	is the writing interface of proration rules to the rulebase file.
 * 
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */

public abstract class PrubaeWriter {

  // Associations  
  /**
   * variable <code>editor</code> is the prubae editor top class reference.
   * 
   * @uml.property name="editor"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected Prubae editor = null;


  // Constructor  
  /**
   * Creates a new <code>PrubaeWriter</code> instance.
   *
   */
  public PrubaeWriter() {  
    super();  
  }  

  // Operations  
  /**
   * <code>write</code> method
   *
   * @param filename a <code>String</code> value
   * is the filename of the rule file.
   * @throws ProrateRulebaseException 
   */
  public abstract void write(String filename) throws ProrateRulebaseException;

  /**
   * <code>upload</code> method
   *
   * @param urlname a <code>String</code> value
   * is the url String of the rule file.
   */
  public abstract void upload(String urlname);

  // Setters and Getters  
  /**
   * <code>setEditor</code> method
   * sets the value of instance variable editor.
   * @param theEditor a <code>Prubae</code> value to set the variable.
   * 
   * @uml.property name="editor"
   */
  public void setEditor(Prubae theEditor) {
    editor = theEditor;
  }

  /**
   * <code>getEditor</code> method
   * gets the value of instance variable setvarList.
   * @return a <code>Prubae</code> value of the variable.
   * 
   * @uml.property name="editor"
   */
  public Prubae getEditor() {
    return editor;
  }



} /* end class PrubaeWriter */
