// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.rulebase;

import java.io.Reader;
import java.util.List;

/* 롼١Υ󥿡ե */

/**
 * interface <code>ProrateRulebase</code>
 *	Prorate Rulebase interface definition.
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public interface ProrateRulebase {
  /**
   * constant <code>MAX_RECURSIVE_CNT</code>
   *	Apply_SPA/APDPƵȺ
   *
   */
  static final int	MAX_RECURSIVE_CNT = 3;

  /**
   * <code>selectSPA</code> method
   *
   * @param carrier a <code>String</code> value
   * @param tkCarrier a <code>String</code> value
   * @param dateIssue a <code>String</code> value
   * @return a <code>boolean</code> value
   * @throws ProrateRulebaseException 
   */
  public boolean selectSPA(String carrier, String tkCarrier, String dateIssue)
    throws ProrateRulebaseException;
  /**
   * <code>selectAPDP</code> method
   *
   * @param carrier a <code>String</code> value
   * @param dateIssue a <code>String</code> value
   * @return a <code>boolean</code> value
   * @throws ProrateRulebaseException 
   */
  public boolean selectAPDP(String carrier, String dateIssue)
    throws ProrateRulebaseException;

  /**
   * <code>selectEXTF</code> method
   *
   * @param extfName a <code>String</code> value
   * @return a <code>boolean</code> value
   * @throws ProrateRulebaseException 
   */
  public boolean selectEXTF(String extfName) throws ProrateRulebaseException;

  /**
   * <code>selectPART</code> method
   *
   * @param Name a <code>String</code> value
   * @return a <code>boolean</code> value
   * @throws ProrateRulebaseException 
   */
  public boolean selectPART(String Name) throws ProrateRulebaseException;

  /**
   * <code>close</code> method	close proration rulebase selection
   *
   */
  void	close();

  /**
   * <code>read</code> method
   *
   * @return a <code>List</code> value
   * @throws ProrateRulebaseException 
   */
  public List	read() throws ProrateRulebaseException;

  /**
   * <code>read</code> method
   *
   * @param reader a <code>Reader</code> value
   * @return a <code>List</code> value
   * @throws ProrateRulebaseException 
   */
  public List	read(Reader reader) throws ProrateRulebaseException;

  /**
   * <code>read</code> method
   *
   * @param isSPA a <code>boolean</code> value
   * @param carrier a <code>String</code> value
   * @param tkCarrier a <code>String</code> value
   * @param issueDate a <code>String</code> value
   * @param skipToActions a <code>boolean</code> value
   * @return a <code>List</code> value
   * @exception ProrateRulebaseException
   */
  public List	read(boolean isSPA, String carrier, String tkCarrier,
		     String issueDate, boolean skipToActions)
    throws ProrateRulebaseException;

  /**
   * <code>setElementFactory</code> method
   *
   * @param theFactory a <code>ProrateRulebaseElementFactory</code> value
   */
  public void	setElementFactory(ProrateRulebaseElementFactory theFactory);
}
