// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.rulebase;

import java.util.List;

/* 롼١롼빽󥿡ե */

public interface ProrateRulebaseElementFactory {
  public ProrateRulebaseElement
    makeNopObject(short regist, String first, String second,
		  String from, String until, String type, String comment);
  public ProrateRulebaseElement makePartObject(String name, List rules,
					       String comment);
  public ProrateRulebaseElement	makeEndObject(String comment);
  public ProrateRulebaseElement
    makeTestObject(List tests, List thens, List elses, String comment);
  public ProrateRulebaseElement	makeAndObject(List clauses, String comment);
  public ProrateRulebaseElement	makeOrObject(List clauses, String comment);
  public ProrateRulebaseElement	makeJudgeObject(List clauses, String comment);
  public ProrateRulebaseElement
    makeSwitchObject(List args, List branchacts, String comment);
  public ProrateRulebaseElement
    makeBranchObject(List branches, List actions, String comment);
  public ProrateRulebaseElement
    makeCaseObject(List values, String comment);
  public ProrateRulebaseElement	makeBoolObject(boolean bool, String comment);
  public ProrateRulebaseElement	makePartcallObject(String name,
						   String comment);
  public ProrateRulebaseElement
    makeReturnObject(ProrateRulebaseElement value, String comment);
  public ProrateRulebaseElement
    makeMultivalObject(List values, String comment);
  public ProrateRulebaseElement
    makeIntervalObject(ProrateRulebaseElement lowvalue,
		       ProrateRulebaseElement highvalue, String comment);
  public ProrateRulebaseElement
    makeAmountObject(String currency, double value, String comment);
  public ProrateRulebaseElement
    makePercentObject(double percent, ProrateRulebaseElement amount,
		      String comment);
  public ProrateRulebaseElement	makeVarObject(short regist, String comment);
  public ProrateRulebaseElement
    makeExternObject(String extfName, String parentName,
		     List args, String comment);
  public ProrateRulebaseElement
    makeFuncObject(short regist, List args, String comment);
  public ProrateRulebaseElement
    makeApplyObject(boolean isSpa, String carrier, String tkCarrier,
		    String comment);
  public ProrateRulebaseElement
    makeApplyObject(boolean isSpa,
		    ProrateRulebaseElement carrier,
		    ProrateRulebaseElement tkCarrier,
		    String comment);
  public ProrateRulebaseElement
    makeNumberObject(double number, String comment);
  public ProrateRulebaseElement
    makeDateObject(short month, short day, String comment);
  public ProrateRulebaseElement	makeStringObject(String str, String comment);
  public ProrateRulebaseElement	makePathObject(List value, String comment);
  public ProrateRulebaseElement	makeVarAutoObject(short regist,
						  String varName,
						  String comment);
  public ProrateRulebaseElement
  makeTableObject(ProrateRulebaseElement prows,
		  ProrateRulebaseElement pcols,
		  List rows, List cols, List tbls, String comment);
  public ProrateRulebaseElement
  makeTableObject(ProrateRulebaseElement pcols, List cols, List tbls,
		  String comment);
  public ProrateRulebaseElement	makeErrorObject(int error_flag,
						String error_string,
						String comment);
}
