// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.rulebase.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Vector;

import javax.swing.JOptionPane;

import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelDoStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelFactory;
import jp.sourceforge.gnp.prubae.PrubaeModelFunction;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;
import jp.sourceforge.gnp.prubae.PrubaeReader;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

/**
 * class <code>PrubaeReaderXmlUrl</code>
 * handles reading proration rules from the XML rulebase file,
 * using XML Rulebase classes.
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeReaderXmlUrl extends PrubaeReaderXml {

  /**
   * variable <code>baseUrl</code>	base URL String from which read rules
   *
   */
  String	baseUrl = null;
  
  // Constructor
  /**
   * Creates a new <code>PrubaeReaderXmlUrl</code> instance.
   *
   */
  public PrubaeReaderXmlUrl() {
    super();
  }
  
  // Operations
  /**
   * <code>initialize</code> method	initialize rulebase
   *
   */
  public void	initialize() {
    try {
      System.err.println("PrubaeReaderXmlUrl.initialize(): before XmlRulebaseUrl.initialize()");
      List	skipInitializeList = new Vector();
      skipInitializeList.add(XmlRulebase.INDEX_SPA);
      skipInitializeList.add(XmlRulebase.INDEX_APDP);
      XmlRulebaseUrl.setSkipInitializeList(skipInitializeList);

      if (getEditor().getAdditionalPropertyFilename() != null) {
	String	propFile = getEditor().getAdditionalPropertyFilename();
	InputStream	propIn = null;
	if (!propFile.startsWith("http:")) {
	  try {
	    propIn = new FileInputStream(propFile);
	  }
	  catch (FileNotFoundException e) {
	    propIn = null;
	  }
	}
	else {
	  URL propUrl = null;
	  try {
	    propUrl = new URL(propFile);
	    System.out.println("propUrl = " + propUrl);
	  } catch (MalformedURLException e) {
	    propUrl = null;
	  }
	  System.err.println("URL propUrl = " + propUrl);
	  if (propUrl != null) {
	    try {
	      /* ;;; 2009/07/22
	      propIn = rcUrl.openStream();
	      */
	      URLConnection	connection = propUrl.openConnection();
	      connection.setUseCaches(false);
	      propIn = connection.getInputStream();
	    }
	    catch (IOException e) {
	      propIn = null;
	    }
	  }
	}
	System.err.println("stream propIn = " + propIn);
	XmlRulebase.setAdditionalPropertiesInputStream(propIn);
      }

      XmlRulebaseUrl.initialize(getBaseUrl());
      System.err.println("PrubaeReaderXmlUrl.initialize(): after XmlRulebaseUrl.initialize()");
    } catch (Exception e) {
      // TODO ư줿 catch ֥å
      e.printStackTrace();
    }
  }

  /**
   * <code>read</code> method
   * creates XML Rulebase instance,
   * and prubae model factory class PrubaeModelFactory instance.
   * set editor reference to the factory instance,
   * set factory reference to the rulebase instance,
   * then read all the rules from the selected rule file using rulebase.
   * if no rules are read, return null.(error return).
   * the first rule element read is the top element,
   * and constructs rule model tree structure from rule elements read,
   * and returns it.
   *
   * @param filename a <code>String</code> value
   *	is the Url of the XML rule file.
   */
  public void read(String filename) {
    if (filename == null) {
      return;
    }
    List	rules = null;
    try {
      ProrateRulebase rulebase = new XmlRulebaseUrl(filename);
      PrubaeModelFactory	factory = new PrubaeModelFactory();
      factory.setEditor(getEditor());
      rulebase.setElementFactory(factory);
      try {
        rules = rulebase.read();
      } catch (Exception e) {
        e.printStackTrace();
	JOptionPane.showMessageDialog(null, "Exception in read() :"
				      + e.getMessage());
      }
    }
    catch (NullPointerException N) {
      System.out.println("NullPointerException: " + N.getMessage());
      N.printStackTrace();
      JOptionPane.showMessageDialog(null, "NullPointerException in read("
				    + filename + ") :"
				    + N.getMessage());
      return;
    }
    if (rules == null) {
      JOptionPane.showMessageDialog(null, "read(" + filename + ") = null");
      return;
    }
    if (rules.size() <= 0) {
      JOptionPane.showMessageDialog(null, "read(" + filename + ") : size = 0");
      return;
    }
    PrubaeModel	ret = (PrubaeModel)rules.get(0);
    if ((ret.getRegist() == ProrateRulebaseElement.SPA_CODE)
	|| (ret.getRegist() == ProrateRulebaseElement.APD_P_CODE)
	|| (ret.getRegist() == ProrateRulebaseElement.EXTF_CODE)
	|| (ret.getRegist() == ProrateRulebaseElement.PART_CODE)) {
      List	vec = null;
      for (int i = 1; i < rules.size(); i++) {
	if (((PrubaeModel)rules.get(i)).getRegist()
	    == ProrateRulebaseElement.COMMON_CODE) {
	  vec = ((PrubaeModelFunction)ret).getCommon();
	}
	else if (((PrubaeModel)rules.get(i)).getRegist()
		 == ProrateRulebaseElement.ACTIONS_CODE) {
	  vec = ((PrubaeModelFunction)ret).getActions();
	}
	else if (vec != null) {
	  ((PrubaeModel)rules.get(i)).initialize(getEditor(), ret, vec);
	  vec.add(rules.get(i));
	}
	else if (ret.getRegist() == ProrateRulebaseElement.EXTF_CODE) {
	  if (((PrubaeModelFunction)ret).getArgs() == null) {
	    ((PrubaeModelFunction)ret).setArgs(new Vector());
	  }
	  PrubaeModelDoStatement pDo = (PrubaeModelDoStatement)rules.get(i);
	  PrubaeModelValueStatement
	    pValue = (PrubaeModelValueStatement)pDo.getValues().get(0);
	  String	arg = pValue.getStatement();
	  ((PrubaeModelFunction)ret).getArgs().add(arg);
	}
      }
    }
    getEditor().setModel(ret);
  }

  /**
   * <code>read</code> method
   * creates XML Rulebase instance,
   * and prubae model factory class PrubaeModelFactory instance.
   * set editor reference to the factory instance,
   * set factory reference to the rulebase instance,
   * then read all the rules from the selected reader using rulebase.
   * if no rules are read, return null.(error return).
   * the first rule element read is the top element,
   * and constructs rule model tree structure from rule elements read,
   * and returns it.
   *
   * @param reader a <code>Reader</code> value
   */
  public void read(Reader reader) {
    if (reader == null) {
      return;
    }
    List	rules = null;
    try {
      ProrateRulebase rulebase = new XmlRulebaseUrl();
      PrubaeModelFactory	factory = new PrubaeModelFactory();
      factory.setEditor(getEditor());
      rulebase.setElementFactory(factory);
      rules = rulebase.read(reader);
    }
    catch (NullPointerException N) {
      System.out.println("NullPointerException: " + N.getMessage());
      N.printStackTrace();
      JOptionPane.showMessageDialog(null, "NullPointerException in read("
				    + reader.toString() + ") :"
				    + N.getMessage());
      return;
    } catch (Exception e) {
      e.printStackTrace();
      JOptionPane.showMessageDialog(null, "Exception in read("
				    + reader.toString() + ") :"
				    + e.getMessage());
      return;
    }
    if (rules == null) {
      JOptionPane.showMessageDialog(null, "read("
				    + reader.toString() + ") = null");
      return;
    }
    if (rules.size() <= 0) {
      JOptionPane.showMessageDialog(null, "read("
				    + reader.toString() + ") : size = 0");
      return;
    }
    System.err.println("PrubaeReaderXmlUrl.read() rules = " + rules);
    PrubaeModel	ret = (PrubaeModel)rules.get(0);
    if ((ret.getRegist() == ProrateRulebaseElement.SPA_CODE)
	|| (ret.getRegist() == ProrateRulebaseElement.APD_P_CODE)
	|| (ret.getRegist() == ProrateRulebaseElement.EXTF_CODE)
	|| (ret.getRegist() == ProrateRulebaseElement.PART_CODE)) {
      List	vec = null;
      for (int i = 1; i < rules.size(); i++) {
	if (((PrubaeModel)rules.get(i)).getRegist()
	    == ProrateRulebaseElement.COMMON_CODE) {
	  vec = ((PrubaeModelFunction)ret).getCommon();
	}
	else if (((PrubaeModel)rules.get(i)).getRegist()
		 == ProrateRulebaseElement.ACTIONS_CODE) {
	  vec = ((PrubaeModelFunction)ret).getActions();
	}
	else if (vec != null) {
	  ((PrubaeModel)rules.get(i)).initialize(getEditor(), ret, vec);
	  vec.add(rules.get(i));
	}
	else if (ret.getRegist() == ProrateRulebaseElement.EXTF_CODE) {
	  if (((PrubaeModelFunction)ret).getArgs() == null) {
	    ((PrubaeModelFunction)ret).setArgs(new Vector());
	  }
	  PrubaeModelDoStatement pDo = (PrubaeModelDoStatement)rules.get(i);
	  PrubaeModelValueStatement
	    pValue = (PrubaeModelValueStatement)pDo.getValues().get(0);
	  String	arg = pValue.getStatement();
	  ((PrubaeModelFunction)ret).getArgs().add(arg);
	}
      }
    }
    getEditor().setModel(ret);
  }

  public List	getAllActionExtfs() {
    return XmlRulebaseUrl.getAllActionExtfs();
  }

  public List	getAllJudgeExtfs() {
    return XmlRulebaseUrl.getAllJudgeExtfs();
  }

  public List	getAllParts() {
    return XmlRulebaseUrl.getAllParts();
  }

  public String getBaseUrl() {
    return baseUrl;
  }

  public void setBaseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
  }

} /* end class PrubaeReaderXmlUrl */
