// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.rulebase.xml;

import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import javax.swing.JOptionPane;

import jp.sourceforge.gnp.prubae.PrubaeWriter;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

import org.apache.commons.httpclient.HttpException;
import org.apache.webdav.lib.WebdavResource;


/**
 * class <code>PrubaeWriterXml</code>
 * handles writing proration rules to the rulebase file.
 * using XML Rulebase classes.
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeWriterXml extends PrubaeWriter {

  // Constructor
  /**
   * Creates a new <code>PrubaeWriterXml</code> instance.
   *
   */
  public PrubaeWriterXml() {
    super();
  }

  // Operations
  /**
   * <code>write</code> method
   * creates XML Rulebase Writer instance,
   * writes current editing model using the rulebase.
   *
   * @param filename a <code>String</code> value
   * @throws ProrateRulebaseException 
   * @throws HeadlessException 
   */
  public void write(String filename) throws ProrateRulebaseException, HeadlessException {
    if (filename == null) {
      return;
    }
    if (getEditor() == null || getEditor().getModel() == null) {
      return;
    }
    FileOutputStream	stream = null;
    try {
      stream = new FileOutputStream(filename);
    }
    catch (IOException E) {
      /* ;;; deBug */
      System.err.println("IOException : " + E.getMessage() + " : "
			 + filename);
      JOptionPane.showMessageDialog(null,
				    "IOException in create FileOutputStream("
				    + filename + ") : "
				    + E.getMessage());
    }
    write(stream);
    File	file = new File(filename);
    if (!file.setWritable(true, false)) {
      System.err.println("Cannot set writable permission : "
			 + filename);
    }
  }

  /**
   * <code>upload</code> method
   *	not implemented yet
   *
   * @param urlname a <code>String</code> value
   */
  public void upload(String urlname) {
    URL	url = null;
    try {
      url = new URL(urlname);
    } catch (MalformedURLException e) {
      /* ;;; deBug */
      System.err.println("NullPointerException: " + e.getMessage());
      e.printStackTrace();
      JOptionPane
	.showMessageDialog(null,
			   "MalformedURLException in creating URL in upload("
			   + urlname + ") : "
			   + e.getMessage());
      return;
    }
    String	urlStr = url.toString();
    int	index = urlStr.lastIndexOf('/');
    String	path = (index >= 0 ? urlStr.substring(0, index) : urlStr);
    System.err.println("WebDAVResource() path = " + path
		       + ", before construct WebdavResource()");
    int	statusCode = -1;

    WebdavResource res = null;
    boolean	locked = false;
    try {
      try {
	res = new WebdavResource(path);
      } catch (HttpException e) {
	e.printStackTrace();
	System.err.println("WebDAVResource() failed HttpException: "
			   + e.getMessage() + "/" + e.getReason()
			   + ", caused by "
			   + (e.getCause() == null ? "null"
			      : e.getCause().getMessage()));
	JOptionPane
	  .showMessageDialog(null,
			     "HttpException in creating WebdavResource("
			     + path + ") : "
			     + e.getMessage() + "/" + e.getReason()
			     + ", caused by "
			     + (e.getCause() == null ? "null"
				: e.getCause().getMessage()));
	return;
      } catch (IOException e) {
	e.printStackTrace();
	System.err.println("WebDAVResource() failed IOException: "
			   + e.getMessage());
	JOptionPane
	  .showMessageDialog(null,
			     "IOException in creating WebdavResource("
			     + path + ") : "
			     + e.getMessage());
	return;
      } catch (Exception e) {
	e.printStackTrace();
	System.err.println("WebDAVResource() failed Exception: "
			   + e.getMessage()
			   + ", caused by "
			   + (e.getCause() == null ? "null"
			      : e.getCause().getMessage()));
	JOptionPane
	  .showMessageDialog(null,
			     "Exception in creating WebdavResource("
			     + path + ") : "
			     + e.getMessage()
			     + ", caused by "
			     + (e.getCause() == null ? "null"
				: e.getCause().getMessage()));
	return;
      }

      if (res == null) {
	System.err.println("WebDAVResource() path = " + path
			   + ", resource not created");
	return;
      }
      statusCode = res.getStatusCode();
      System.err.println("WebDAVResource() path = " + path
			 + ", status code = " + statusCode);

      /* TODO ;;; deBug lock does not work properly, unlock always fails
	 try {
	 locked = res.lockMethod(urlStr);
	 } catch (HttpException e2) {
	 e2.printStackTrace();
	 System.err.println("lockMethod() failed HttpException: "
	 + e2.getMessage() + "/" + e2.getReason()
	 + ", caused by "
	 + (e2.getCause() == null ? "null"
	 : e2.getCause().getMessage()));
	 JOptionPane
	 .showMessageDialog(null,
	 "HttpException in lockMethod("
	 + urlStr + ") : "
	 + e2.getMessage() + "/" + e2.getReason()
	 + ", caused by "
	 + (e2.getCause() == null ? "null"
	 : e2.getCause().getMessage()));
	 } catch (IOException e2) {
	 e2.printStackTrace();
	 System.err.println("lockMethod() failed IOException: "
	 + e2.getMessage());
	 JOptionPane
	 .showMessageDialog(null,
	 "IOException in lockMethod(" + path + ") : "
	 + e2.getMessage());
	 }
      */
      locked = true;

      if (locked) {

	/* TODO ;;; deBug lock does not work properly, unlock always fails
	   statusCode = res.getStatusCode();
	   System.err.println("WebDAV lockMethod() urlStr = " + urlStr
	   + " succeeded, status code = " + statusCode);
	*/
	locked = false;

	final PipedOutputStream os = new PipedOutputStream();
	PipedInputStream is = null;
	try {
	  is = new PipedInputStream(os);
	} catch (IOException e1) {
	  e1.printStackTrace();
	  JOptionPane
	    .showMessageDialog(null,
			       "IOException in creating PipedInputStream("
			       + os.toString() + ") : "
			       + e1.getMessage());
	  return;
	}
      
	(new Thread() {
	    public void run() {
	      try {
		write(os);
	      } catch (ProrateRulebaseException e) {
		// TODO ư줿 catch ֥å
		e.printStackTrace();
	      }
	      try {
		os.close();
	      } catch (IOException e) {
		// TODO ư줿 catch ֥å
		e.printStackTrace();
	      }
	    }
	  }
	 ).start();

	try {
	  res.putMethod(urlStr, is);
	} catch (HttpException e) {
	  e.printStackTrace();
	  JOptionPane
	    .showMessageDialog(null,
			       "HttpException in putMethod("
			       + urlStr + "," + is.toString() + ") : "
			       + e.getMessage() + "/" + e.getReason()
			       + ", caused by "
			       + (e.getCause() == null ? "null"
				  : e.getCause().getMessage()));
	  return;
	} catch (IOException e) {
	  e.printStackTrace();
	  JOptionPane
	    .showMessageDialog(null,
			       "IOException in putMethod("
			       + urlStr + "," + is.toString() + ") : "
			       + e.getMessage());
	  return;
	}
	statusCode = res.getStatusCode();
	System.err.println("WebDAV putMethod() urlStr = " + urlStr
			   + ", status code = " + statusCode);
	if (statusCode < 200 || statusCode >= 300) {
	  JOptionPane
	    .showMessageDialog(null,
			       "putMethod("
			       + urlStr + "," + is.toString() + ") returns "
			       + statusCode);
	}
      }
      else {
	statusCode = res.getStatusCode();
	System.err.println("WebDAV lockMethod() urlStr = " + urlStr
			   + " failed, status code = " + statusCode);
	JOptionPane
	  .showMessageDialog(null,
			     "lockMethod(" + urlStr + ") failed, returns "
			     + statusCode);
      }
      
    }
    
    finally {
      if (res != null) {
	if (locked) {
	  try {
	    boolean	unlocked = res.unlockMethod(urlStr);
	    System.err.println("WebDAV unlockMethod() urlStr = " + urlStr
			       + " , result = " + unlocked);
	  } catch (HttpException e) {
	    // TODO ư줿 catch ֥å
	    e.printStackTrace();
	  } catch (IOException e) {
	    // TODO ư줿 catch ֥å
	    e.printStackTrace();
	  }
	}
	try {
	  res.close();
	  System.err.println("WebDAV Resource.close()");
	} catch (IOException e) {
	  // TODO ư줿 catch ֥å
	  e.printStackTrace();
	}
      }
    }

  }

  /**
   * Describe <code>write</code> method here.
   *
   * @param stream an <code>OutputStream</code> value
   * @throws ProrateRulebaseException 
   */
  public void write(OutputStream stream) throws ProrateRulebaseException {
    try {
      ProrateRulebaseWriter rulebase = new XmlRulebaseWriter(stream);

      if (getEditor().getAdditionalPropertyFilename() != null) {
	String	propFile = getEditor().getAdditionalPropertyFilename();
	InputStream	propIn = null;
	if (!propFile.startsWith("http:")) {
	  try {
	    propIn = new FileInputStream(propFile);
	  }
	  catch (FileNotFoundException e) {
	    propIn = null;
	  }
	}
	else {
	  URL propUrl = null;
	  try {
	    propUrl = new URL(propFile);
	    System.out.println("propUrl = " + propUrl);
	  } catch (MalformedURLException e) {
	    propUrl = null;
	  }
	  System.err.println("URL propUrl = " + propUrl);
	  if (propUrl != null) {
	    try {
	      /* ;;; 2009/07/22
		 propIn = rcUrl.openStream();
	      */
	      URLConnection	connection = propUrl.openConnection();
	      connection.setUseCaches(false);
	      propIn = connection.getInputStream();
	    }
	    catch (IOException e) {
	      propIn = null;
	    }
	  }
	}
	System.err.println("stream propIn = " + propIn);
	((XmlRulebaseWriter)rulebase)
	  .setAdditionalPropertiesInputStream(propIn);
      }

      /* ;;; deBug */
      System.err.println("write(): start");
      System.err.println("write(): "
			 + getEditor().getModel().getSize(rulebase));
      /* ;;; deBug end */
      rulebase.write(getEditor().getModel());
    }
    catch (NullPointerException N) {
      /* ;;; deBug */
      System.err.println("NullPointerException: " + N.getMessage());
      N.printStackTrace();
    }
    finally {
      try {
	stream.close();
      } catch (IOException e) {
	// TODO Auto-generated catch block
	e.printStackTrace();
      }
    }
    /* ;;; deBug */
    System.err.println("write(): end");
  }

} /* end class PrubaeWriterXml */
