// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.rulebase.xml;

import java.io.File;
import java.util.List;
import java.util.Vector;

/**
 * class <code>XmlRulebaseLru</code>
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */

public class XmlRulebaseLru extends XmlRulebaseCache {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  static final int	CacheSize = 100;
  static final int	ByteSize = 100000;

  static List	cacheList = new Vector();

  /**
   * Creates a new <code>XmlRulebaseLru</code> instance.
   *
   * @exception Exception if an error occurs
   */
  public XmlRulebaseLru() throws Exception {
    super();
  }

  /**
   * Creates a new <code>XmlRulebaseLru</code> instance.
   *
   * @param in_filename a <code>String</code> value
   */
  public XmlRulebaseLru(String in_filename) {
    super(in_filename);
  }

  /**
   * <code>close</code> method	close proration rulebase selection
   *
   * @param rule a <code>ProrateRule</code> value
   */
  public void	close() {
    getAppliedRules().remove(getSelectedRecord());
    if (!getSelectedRecord().isCached()) {
      File	file = new File(getSelectedRecord().filename);
      long	size = file.length();
      if (size < ByteSize) {
	getSelectedRecord().setRules(null);
	System.err.println("size = " + size + " discarded: "
			   + getSelectedRecord().rule + "/"
			   + getSelectedRecord().name + "/"
			   + getSelectedRecord().type + "/"
			   + getSelectedRecord().carrier + "/"
			   + getSelectedRecord().tkCarrier + ":"
			   + getSelectedRecord().dateFrom + ":"
			   + getSelectedRecord().dateUntil);
	int	index = getAppliedRules().size()-1;
	if (index >= 0) {
	  setSelectedRecord((RuleCacheElement)getAppliedRules().get(index));
	}
	else {
	  setSelectedRecord(null);
	}
	return;
      }
    }
    System.err.println(" cached: "
		       + getSelectedRecord().rule + "/"
		       + getSelectedRecord().name + "/"
		       + getSelectedRecord().type + "/"
		       + getSelectedRecord().carrier + "/"
		       + getSelectedRecord().tkCarrier + ":"
		       + getSelectedRecord().dateFrom + ":"
		       + getSelectedRecord().dateUntil);
    synchronized(getCacheList()) {
      getCacheList().remove(getSelectedRecord());
      getCacheList().add(getSelectedRecord());
      if (getCacheList().size() > CacheSize) {
	RuleCacheElement	elem = (RuleCacheElement)getCacheList().get(0);
	elem.removeRules();
	getCacheList().remove(0);
	System.err.println("swap out: "
			   + elem.rule + "/"
			   + elem.name + "/"
			   + elem.type + "/"
			   + elem.carrier + "/"
			   + elem.tkCarrier + ":"
			   + elem.dateFrom + ":"
			   + elem.dateUntil);
      }
    }
    int	index = getAppliedRules().size() -1;
    if (index >= 0) {
      setSelectedRecord((RuleCacheElement)getAppliedRules().get(index));
    }
    else {
      setSelectedRecord(null);
    }
  }

  public static List getCacheList() {
    return cacheList;
  }

  public static void setCacheList(List cacheList) {
    XmlRulebaseLru.cacheList = cacheList;
  }

}
