// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.rulebase.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;

import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prubae.Prubae;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelAndOr;
import jp.sourceforge.gnp.prubae.PrubaeModelCase;
import jp.sourceforge.gnp.prubae.PrubaeModelDoStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelFunction;
import jp.sourceforge.gnp.prubae.PrubaeModelIf;
import jp.sourceforge.gnp.prubae.PrubaeModelJudge;
import jp.sourceforge.gnp.prubae.PrubaeModelJudgeStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelSwitch;
import jp.sourceforge.gnp.prubae.PrubaeModelTable;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriterElement;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * class <code>XmlRulebaseWriter</code>
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class XmlRulebaseWriter
  implements jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter {

  // Attributes
  /**
   * variable <code>stream</code>	output stream(file or socket)
   * @uml.property  name="stream"
   */
  private OutputStream	stream = null;

  /**
   * variable <code>current</code>
   *	XML element to create for the rulebase element.
   *
   */
  private Element	current = null;

  /**
   * variable <code>additionalPropertiesInputStream</code>
   *	input stream from which load properties additionally
   *	to merge to the properties table
   *
   */
  private InputStream	additionalPropertiesInputStream = null;

  // Constructor
  /**
   * Creates a new <code>XmlRulebaseWriter</code> instance.
   *
   */
  public XmlRulebaseWriter() {
    super();
  }

  /**
   * Creates a new <code>XmlRulebaseWriter</code> instance.
   *
   * @param stream an <code>OutputStream</code> value
   */
  public XmlRulebaseWriter(OutputStream stream) {
    super();
    setStream(stream);
  }

  // Operations
  public void write(ProrateRulebaseWriterElement model)
    throws ProrateRulebaseException {
    String	propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
    if (propertyFileName == null) {
      System.err.println("user.home = " + System.getProperty("user.home"));
      propertyFileName = System.getProperty("user.home");
      System.err.println("file.separator = "
			 + System.getProperty("file.separator"));
      propertyFileName += System.getProperty("file.separator");
      propertyFileName += ".prorate.properties";
      /* ;;; deBug for Windoze */
      String	separator = System.getProperty("file.separator");
      if (separator != null && separator.equals("\\")) {
	String	homeDir = System.getProperty("user.home");
	System.err.println("user.home = " + homeDir);
	System.err.println("file.separator = " + separator);
	propertyFileName = homeDir + separator + "prorate.properties";
	System.err.println("WIN: propertyFileName = " + propertyFileName);
      }
      /* ;;; deBug for Windoze end */
    }
    InputStream	propertyFile = null;
    try {
      propertyFile = new FileInputStream(propertyFileName);
    }
    catch (FileNotFoundException e) {
      propertyFile = null;
    }
    System.err.println("propertyFileName = " + propertyFileName
		       + ", propertyFile = " + propertyFile);
    InputStream	is = null;
    if (propertyFile == null) {
      ClassLoader	loader = Prorate.class.getClassLoader();
      is = loader.getResourceAsStream(Prorate.propertyFile);
    }
    else {
      is = propertyFile;
    }
    Properties	properties = new Properties();
    try {
      properties.load(is);
    } catch (IOException eProrateProperty) {
      throw new
	ProrateRulebaseException("IOException in write() in reading "
				 + Prorate.propertyFile + ": "
				 + eProrateProperty.getMessage(),
				 eProrateProperty);
    }
    finally {
      try {
	is.close();
      } catch (IOException e) {
      }
    }
    if (propertyFileName == null) {
      System.err.println("user.home = " + System.getProperty("user.home"));
      propertyFileName = System.getProperty("user.home");
      propertyFileName += System.getProperty("file.separator");
      propertyFileName += ".prubae.properties";
    }
    try {
      propertyFile = new FileInputStream(propertyFileName);
    }
    catch (FileNotFoundException e) {
      propertyFile = null;
    }
    System.err.println("propertyFileName = " + propertyFileName
		       + ", propertyFile = " + propertyFile);
    if (propertyFile == null) {
      ClassLoader	loader = Prubae.class.getClassLoader();
      is = loader.getResourceAsStream(Prubae.propertyFile);
    }
    else {
      is = propertyFile;
    }
    try {
      properties.load(is);
    } catch (IOException ePrubaeProperty) {
      throw new
	ProrateRulebaseException("IOException in write() in reading "
				 + Prubae.propertyFile + ": "
				 + ePrubaeProperty.getMessage(),
				 ePrubaeProperty);
    }
    finally {
      try {
	is.close();
      } catch (IOException e) {
      }
    }
    if (getAdditionalPropertiesInputStream() != null) {
      try {
	properties.load(getAdditionalPropertiesInputStream());
      } catch (IOException eAdditionalProperty) {
	throw new
	  ProrateRulebaseException("IOException in write() in reading "
				   + "additional property file"  + ": "
				   + eAdditionalProperty.getMessage(),
				   eAdditionalProperty);
      }
      finally {
	try {
	  getAdditionalPropertiesInputStream().close();
	} catch (IOException e) {
	}
      }
    }
    String	dtdFile = 
      properties.getProperty("GNP_RULE_DTD",
			     "http://127.0.0.1/xml/dtd/rulebase.dtd");
    String	encoding =
      properties.getProperty("GNP_RULE_ENCODING", "UTF-8");

    Element	root = new Element("rule");
    DocType	docType = new DocType("gnp", dtdFile);
    Document	doc = new Document(root, docType);
    /* ;;; 2006.09.07 */
    try {
      model.writeModel(this);
    }
    catch (Exception e) {
      throw new
	ProrateRulebaseException("Exception in writeModel() : "
				 + e.getMessage(),
				 e);
    }
    /* ;;; 2006.09.07 end */
    if (current != null) {
      root.addContent(current);
    }
    /* ;;; ǥե˽񤭤 */
    Format	format = Format.getPrettyFormat();
    format.setEncoding(encoding);
    format.setLineSeparator(new String(System.getProperty("line.separator")));
    XMLOutputter	outputter = new XMLOutputter(format);
    try {
      outputter.output(doc, getStream());
    }
    catch (IOException E) {
      throw new
	ProrateRulebaseException("IOException in writeModel() : "
				 + E.getMessage(),
				 E);
    }
  }

  public void writeFunction(PrubaeModelFunction model) {
    Element	elem = null;
    List	common = model.getCommon();
    List	actions = model.getActions();
    if (model.getRegist() == ProrateRulebaseElement.SPA_CODE
	|| model.getRegist() == ProrateRulebaseElement.APD_P_CODE) {
      elem =
	new Element(model.getRegist() == ProrateRulebaseElement.SPA_CODE
		    ? "spa" : "apdp");
      elem.setAttribute("carrier", model.getCarrier());
      if (model.getTkCarrier() != null) {
	elem.setAttribute("tkCarrier", model.getTkCarrier());
      }
      elem.setAttribute("validStart", Integer.toString(model.getFromDate()));
      elem.setAttribute("validEnd", Integer.toString(model.getToDate()));
    }
    else if (model.getRegist() == ProrateRulebaseElement.EXTF_CODE) {
      elem = new Element("extf");
      int	type = model.getExtfReturnType();
      elem.setAttribute("type",
			(type == PrubaeModelFunction.ExtfReturnJudgement ?
			 "judge" :
			 (type == PrubaeModelFunction.ExtfReturnAction ?
			  "action" :
			  (type == PrubaeModelFunction.ExtfReturnValue ?
			   "value" : ""))));
      elem.setAttribute("name", model.getName());
      List	args = model.getArgs();
      Element	argsElem = new Element("extf-args");
      for (int i = 0; i < args.size(); i++) {
	current = null;
	String	arg = (String)args.get(i);
	Element	argElem = new Element("extf-arg");
	argElem.setAttribute("name", arg);
	argsElem.addContent(argElem);
      }
      elem.addContent(argsElem);
    }
    else if (model.getRegist() == ProrateRulebaseElement.PART_CODE) {
      elem = new Element("part");
      elem.setAttribute("name", model.getName());
    }
    if (model.getComment() != null) {
      elem.setAttribute("comment", model.getComment());
    }
    if (common.size() > 0) {
      Element	commonElem = new Element("common");
      for (int i = 0; i < common.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)common.get(i)).writeModel(this);
	if (current != null) {
	  commonElem.addContent(current);
	}
      }
      elem.addContent(commonElem);
    }
    if (actions.size() > 0) {
      Element	actionsElem = new Element("actions");
      for (int i = 0; i < actions.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)actions.get(i)).writeModel(this);
	if (current != null) {
	  actionsElem.addContent(current);
	}
      }
      elem.addContent(actionsElem);
    }
    current = elem;
  }

  public void writeAndOr(PrubaeModelAndOr model) {
    List	statements = model.getStatements();
    if (statements == null || statements.size() == 0) {
      current = null;
      return;
    }
    Element
      elem = new Element(model.getRegist() == ProrateRulebaseElement.AND_CODE
			 ? "and" : "or");
    for (int i = 0; i < statements.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)statements.get(i)).writeModel(this);
      if (current != null) {
	elem.addContent(current);
      }
    }
    if (model.getComment() != null) {
      elem.setAttribute("comment", model.getComment());
    }
    current = elem;
  }

  public void writeIf(PrubaeModelIf model) {
    ProrateRulebaseWriterElement condition = model.getCondition();
    List thens = model.getThens();
    List elses = model.getElses();
    Element	elem = new Element("if");
    ((ProrateRulebaseWriterElement)condition).writeModel(this);
    if (current != null) {
      elem.addContent(current);
    }
    Element	thenElem = new Element("then");
    for (int i = 0; i < thens.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)thens.get(i)).writeModel(this);
      if (current != null) {
	thenElem.addContent(current);
      }
    }
    Element	elseElem = new Element("else");
    for (int i = 0; i < elses.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)elses.get(i)).writeModel(this);
      if (current != null) {
	elseElem.addContent(current);
      }
    }
    elem.addContent(thenElem);
    elem.addContent(elseElem);
    if (model.getComment() != null) {
      elem.setAttribute("comment", model.getComment());
    }
    current = elem;
  }

  public void writeSwitch(PrubaeModelSwitch model) {
    Element	elem = new Element("switch");
    List vars = model.getVars();
    List branches = model.getCases();
    Element	varsElem = new Element("case-vars");
    for (int i = 0; i < vars.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)vars.get(i)).writeModel(this);
      if (current != null) {
	varsElem.addContent(current);
      }
    }
    elem.addContent(varsElem);
    for (int i = 0; i < branches.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)branches.get(i)).writeModel(this);
      if (current != null) {
	elem.addContent(current);
      }
    }
    if (model.getComment() != null) {
      elem.setAttribute("comment", model.getComment());
    }
    current = elem;
  }

  public void writeCase(PrubaeModelCase model) {
    Element	elem = new Element("branch");
    List values = model.getValues();
    List actions = model.getActions();
    Element	condElem = new Element("branch-condition");
    for (int i = 0; i < values.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
      if (current != null) {
	condElem.addContent(current);
      }
    }
    elem.addContent(condElem);
    for (int i = 0; i < actions.size(); i++) {
      current = null;
      ((ProrateRulebaseWriterElement)actions.get(i)).writeModel(this);
      if (current != null) {
	elem.addContent(current);
      }
    }
    if (model.getComment() != null) {
      elem.setAttribute("comment", model.getComment());
    }
    current = elem;
  }

  public void writeTable(PrubaeModelTable model) {
    Element	elem = new Element("table");
    ProrateRulebaseWriterElement varRow = model.getVarRow();
    ProrateRulebaseWriterElement varCol = model.getVarCol();
    List rows = model.getRows();
    List cols = model.getCols();
    List tbls = model.getTbls();
    Element	varsElem = new Element("table-vars");
    if (varRow != null && ((PrubaeModel)varRow).getRegist() != 0
	&& rows != null && rows.size() > 0) {
      current = null;
      varRow.writeModel(this);
      if (current != null) {
	varsElem.addContent(current);
      }
    }
    if (varCol != null) {
      current = null;
      varCol.writeModel(this);
      if (current != null) {
	varsElem.addContent(current);
      }
    }
    elem.addContent(varsElem);
    Element	condElem = new Element("table-conditions");
    int	rowsCnt = 0;
    if (rows != null && rows.size() > 0) {
      Element	rowsElem = new Element("rows");
      for (int i = 0; i < rows.size(); i++) {
	current = null;
	if (((PrubaeModel)rows.get(i)).getRegist() > 0) {
	  ((ProrateRulebaseWriterElement)rows.get(i)).writeModel(this);
	  if (current != null) {
	    rowsElem.addContent(current);
	  }
	  rowsCnt++;
	}
      }
      condElem.addContent(rowsElem);
    }
    Element	colsElem = new Element("cols");
    int	colsCnt = 0;
    if (cols != null && cols.size() > 0) {
      for (int i = 0; i < cols.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)cols.get(i)).writeModel(this);
	if (((PrubaeModel)cols.get(i)).getRegist() > 0) {
	  if (current != null) {
	    colsElem.addContent(current);
	  }
	  colsCnt++;
	}
      }
      condElem.addContent(colsElem);
    }
    elem.addContent(condElem);
    Element	tblsElem = new Element("amount-table");
    if (rows != null && rows.size() > 0) {
      for (int i = 0; i < rows.size(); i++) {
	if (i < rowsCnt) {
	  for (int j = 0; j < cols.size(); j++) {
	    current = null;
	    if (j < colsCnt) {
	      int	index = cols.size() * i + j;
	      ((ProrateRulebaseWriterElement)tbls.get(index)).writeModel(this);
	      if (current != null) {
		tblsElem.addContent(current);
	      }
	    }
	  }
	}
      }
    }
    else if (cols != null && cols.size() > 0) {
      for (int i = 0; i < cols.size(); i++) {
	current = null;
	if (i < colsCnt) {
	  ((ProrateRulebaseWriterElement)tbls.get(i)).writeModel(this);
	  if (current != null) {
	    tblsElem.addContent(current);
	  }
	}
      }
    }
    elem.addContent(tblsElem);
    if (model.getComment() != null) {
      elem.setAttribute("comment", model.getComment());
    }
    current = elem;
  }

  public void writeDoStatement(PrubaeModelDoStatement model) {
    if (model.getRegist() == 0) {
      current = null;
      return;
    }
    double percent = model.getPercent();
    List values = model.getValues();
    String name = model.getName();
    if (model.getRegist() == (short)ProrateRulebaseElement.END_CODE) {
      current = new Element("action-statement");
      current.addContent(new Element("end"));
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == (short)ProrateRulebaseElement.AMOUNT_CODE) {
      Element	amountElem = new Element("amount");
      amountElem.setAttribute("currency", values.get(0).toString());
      amountElem.setAttribute("value", values.get(1).toString());
      if (model.getComment() != null) {
	amountElem.setAttribute("comment", model.getComment());
      }
      current = new Element("action-statement");
      if (percent != (double)0) {
	Element	percentElem = new Element("percent");
	percentElem.setAttribute("number", Double.toString(percent));
	percentElem.addContent(amountElem);
	current.addContent(percentElem);
      }
      else {
	current.addContent(amountElem);
      }
      return;
    }
    if (model.getRegist() == (short)ProrateRulebaseElement.RETTRUE_CODE) {
      current = new Element("action-statement");
      Element	elem = new Element("return");
      elem.addContent(new Element("true"));
      current.addContent(elem);
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == (short)ProrateRulebaseElement.RETFALSE_CODE) {
      current = new Element("action-statement");
      Element	elem = new Element("return");
      elem.addContent(new Element("false"));
      current.addContent(elem);
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == (short)ProrateRulebaseElement.PARTCALL_CODE) {
      current = new Element("action-statement");
      Element	elem = new Element("partcall");
      elem.setAttribute("name", name);
      current.addContent(elem);
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    Element	elem = null;
    if (model.getRegist() == (short)ProrateRulebaseElement.RETURN_CODE) {
      elem = new Element("return");
    }
    else if (model.getRegist() == (short)ProrateRulebaseElement.SET_CODE) {
      elem = new Element("funcall");
      elem.setAttribute("name", "Set");
    }
    else {
      elem = new Element("funcall");
      elem.setAttribute("name", name);
    }
    if (values != null) {
      for (int i = 0; i < values.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
	if (current != null) {
	  elem.addContent(current);
	}
      }
    }
    current = new Element("action-statement");
    if (percent != (double)0) {
      Element	percentElem = new Element("percent");
      percentElem.setAttribute("number", Double.toString(percent));
      percentElem.addContent(elem);
      current.addContent(percentElem);
    }
    else {
      current.addContent(elem);
    }
    if (model.getComment() != null) {
      current.setAttribute("comment", model.getComment());
    }
  }

  public void writeJudgeStatement(PrubaeModelJudgeStatement model) {
    /* ;;; deBug
       if (model.getRegist() == 0) {
       current = null;
       return;
       }
    */
    if (model.getRegist() == 0) {
      writeJudge(model);
      return;
    }
    List values = model.getValues();
    String name = model.getName();
    Element	elem = new Element("funcall");
    elem.setAttribute("name", name);
    if (values != null) {
      for (int i = 0; i < values.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
	if (current != null) {
	  elem.addContent(current);
	}
      }
    }
    current = new Element("judge-statement");
    current.addContent(elem);
    if (model.getComment() != null) {
      current.setAttribute("comment", model.getComment());
    }
  }

  public void writeJudge(PrubaeModelJudge model) {
    current = new Element("judge");
    if (model.getComment() != null) {
      current.setAttribute("comment", model.getComment());
    }
  }

  public void writeValueStatement(PrubaeModelValueStatement model) {
    if (model.getRegist() == 0) {
      current = null;
      return;
    }
    List values = model.getValues();
    String name = model.getName();
    if (model.getRegist() == (short)ProrateRulebaseElement.AMOUNT_CODE) {
      current = new Element("amount");
      current.setAttribute("currency", values.get(0).toString());
      current.setAttribute("value", values.get(1).toString());
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == ProrateRulebaseElement.NUMBER_CODE) {
      current = new Element("number");
      current.setAttribute("value", values.get(0).toString());
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == ProrateRulebaseElement.DATE_CODE) {
      current = new Element("date");
      current.setAttribute("month", values.get(0).toString());
      current.setAttribute("day", values.get(1).toString());
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == ProrateRulebaseElement.STRING_CODE) {
      current = new Element("string");
      current.setAttribute("value", values.get(0).toString());
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == ProrateRulebaseElement.PATH_CODE) {
      Element	elem = new Element("path");
      for (int i = 0; i < values.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
	if (current != null) {
	  elem.addContent(current);
	}
      }
      current = elem;
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if ((model.getRegist() & ProrateRulebaseElement.VARIABLE_SPECIFICATION)
	!= 0) {
      current = new Element("variable");
      /* ;;; deBug
      if (model.getRegist()
	  >= ProrateRulebaseElement.AUTO_VARIABLE_INITIAL_CODE) {
	current.setAttribute("name", values.get(0).toString());
      }
      else {
	current.setAttribute("name", model.getStatement());
      }
      */
      current.setAttribute("name", model.getStatement());
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    if (model.getRegist() == ProrateRulebaseElement.MULTIVAL_CODE
	|| model.getRegist() == ProrateRulebaseElement.INTERVAL_CODE) {
      Element	elem =
	new Element(model.getRegist() == ProrateRulebaseElement.MULTIVAL_CODE
		    ? "multival" : "interval");
      for (int i = 0; i < values.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
	if (current != null) {
	  elem.addContent(current);
	}
      }
      current = elem;
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    Element	elem = new Element("funcall");
    elem.setAttribute("name", name);
    if (values != null) {
      for (int i = 0; i < values.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
	if (current != null) {
	  elem.addContent(current);
	}
      }
    }
    current = elem;
    if (model.getComment() != null) {
      current.setAttribute("comment", model.getComment());
    }
  }

  public void writeValue(PrubaeModelValue model) {
    List values = model.getValues();
    if (model.getRegist() == ProrateRulebaseElement.CASE_BRANCH_BEGIN) {
      Element	elem = new Element("case");
      for (int i = 0; i < values.size(); i++) {
	current = null;
	((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
	if (current != null) {
	  elem.addContent(current);
	}
      }
      current = elem;
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    /* ;;; deBug added 2013.09.01 */
    else if ((model.getParent().getRegist()
	      == ProrateRulebaseElement.Apply_apdp_FUNCTION)
	     || (model.getParent().getRegist()
		 == ProrateRulebaseElement.Apply_spa_FUNCTION)) {
      Element	elem = new Element("string");
      elem.setAttribute("value", values.get(0).toString());
      current = elem;
      if (model.getComment() != null) {
	current.setAttribute("comment", model.getComment());
      }
      return;
    }
    /*NOTREACHED*/
    current = null;
  }

  public int getFunctionSize(PrubaeModelFunction model) {
    return 0;
  }

  public int getAndOrSize(PrubaeModelAndOr model) {
    return 0;
  }

  public int getIfSize(PrubaeModelIf model) {
    return 0;
  }

  public int getCaseSize(PrubaeModelCase model) {
    return 0;
  }

  public int getSwitchSize(PrubaeModelSwitch model) {
    return 0;
  }

  public int getTableSize(PrubaeModelTable model) {
    return 0;
  }

  public int getDoStatementSize(PrubaeModelDoStatement model) {
    return 0;
  }

  public int getJudgeStatementSize(PrubaeModelJudgeStatement model) {
    return 0;
  }

  public int getValueStatementSize(PrubaeModelValueStatement model) {
    return 0;
  }

  public int getValueSize(PrubaeModelValue model) {
    return 0;
  }

  // Setters and Getters
  /**
   * @return  stream
   * @uml.property  name="stream"
   */
  public OutputStream getStream() {
    return stream;
  }

  /**
   * @param stream  set stream
   * @uml.property  name="stream"
   */
  public void setStream(OutputStream stream) {
    this.stream = stream;
  }

  public InputStream getAdditionalPropertiesInputStream() {
    return additionalPropertiesInputStream;
  }

  public void
    setAdditionalPropertiesInputStream(InputStream propertiesInputStream) {
    this.additionalPropertiesInputStream = propertiesInputStream;
  }

} /* end class XmlRulebaseWriter */
