// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.util.database;

import java.sql.SQLException;

/**
 * @author  maruyama
 */
public abstract class Database {
  // Attributes
  private Object data = null;
  // Associations
  // Constructor
  public Database() {
    super();
  }
  // Operations
  public abstract boolean initialize();
  public abstract boolean open() throws SQLException;
  public abstract boolean close() throws SQLException;
  public abstract boolean search() throws SQLException;
  public abstract boolean commit() throws SQLException;
  public abstract boolean rollback() throws SQLException;
  public abstract boolean begin() throws SQLException;
  public abstract boolean insert() throws SQLException;
  public abstract boolean update() throws SQLException;
  public abstract boolean delete() throws SQLException;
  // Setters and Getters
  /**
   * @param data  ꤹ data
   * @uml.property  name="data"
   */
  public void setData(Object theData) {
    data = theData;
  }
  /**
   * @return  data
   * @uml.property  name="data"
   */
  public Object getData() {
    return data;
  }

} /* end class Database */
