// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.util.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @author  maruyama
 */
public class JdbcDatabase extends Database {
  // Attributes
  private String driver = "";
  private String url = "";
  private String user = "";
  private String passwd = "";
  private Connection connection = null;
  private Statement statement = null;
  // Constructor
  public JdbcDatabase() {
    super();
  }
  // Operations
  public boolean initialize() {
    try {
      Class.forName(getDriver());
    } catch (ClassNotFoundException e) {
      return false;
    } // throws ClassNotFoundException
    return true;
  }
  public boolean open() throws SQLException {
    DriverManager.setLoginTimeout(0);
    setConnection(DriverManager.getConnection(getUrl(),
					      getUser(), getPasswd()));
    return true;
  }
  public boolean close() throws SQLException {
    getConnection().close();
    return true;
  }
  public boolean commit() throws SQLException {
    getConnection().commit();
    return true;
  }
  public boolean rollback() throws SQLException {
    getConnection().rollback();
    return true;
  }
  public boolean begin() {
    return true;
  }
  // Setters and Getters
  /**
   * @param driver  ꤹ driver
   * @uml.property  name="driver"
   */
  public void setDriver(String theDriver) {
    driver = theDriver;
  }
  /**
   * @return  driver
   * @uml.property  name="driver"
   */
  public String getDriver() {
    return driver;
  }
  /**
   * @param url  ꤹ url
   * @uml.property  name="url"
   */
  public void setUrl(String theUrl) {
    url = theUrl;
  }
  /**
   * @return  url
   * @uml.property  name="url"
   */
  public String getUrl() {
    return url;
  }
  /**
   * @param user  ꤹ user
   * @uml.property  name="user"
   */
  public void setUser(String theUser) {
    user = theUser;
  }
  /**
   * @return  user
   * @uml.property  name="user"
   */
  public String getUser() {
    return user;
  }
  /**
   * @param passwd  ꤹ passwd
   * @uml.property  name="passwd"
   */
  public void setPasswd(String thePasswd) {
    passwd = thePasswd;
  }
  /**
   * @return  passwd
   * @uml.property  name="passwd"
   */
  public String getPasswd() {
    return passwd;
  }
  /**
   * @param connection  ꤹ connection
   * @uml.property  name="connection"
   */
  public void setConnection(Connection theConnection) {
    connection = theConnection;
  }
  /**
   * @return  connection
   * @uml.property  name="connection"
   */
  public Connection getConnection() {
    return connection;
  }
  /**
   * @param statement  ꤹ statement
   * @uml.property  name="statement"
   */
  public void setStatement(Statement theStatement) {
    statement = theStatement;
  }
  /**
   * @return  statement
   * @uml.property  name="statement"
   */
  public Statement getStatement() {
    return statement;
  }
  
  public boolean search() throws SQLException {
    return false;
  }

  public boolean insert() throws SQLException {
    return false;
  }

  public boolean update() throws SQLException {
    return false;
  }

  public boolean delete() throws SQLException {
    return false;
  }

} /* end class JdbcDatabase */
