#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <strings.h>

#include <CORBA.h>
#include <coss/CosNaming.h>
#include "Prorate.h"

using namespace std;
using namespace jp::sourceforge::gnp::prorate::jdl;

extern ProrateAuditJdl	*audit;
extern	FILE	*t_fp;

void	initialize_ticket_data(int no_sectors);
int	input_ticket_data(void);
void	print_ticket(void);

void	initialize_ticket_data(int no_sectors)
{
    char	string[4096];
    register int	i;
    register ProrateSectorJdl	*sp;

    memset(string, 0, 256);

    audit->invoiceMonth = (char *)malloc(16);
    memset(audit->invoiceMonth, 0, 16);

    audit->airwayNumber = (char *)malloc(8);
    memset(audit->airwayNumber, 0, 8);
    audit->airwayId = (char *)malloc(4);
    memset(audit->airwayId, 0, 4);

    audit->issueDate = (char *)malloc(16);
    memset(audit->issueDate, 0, 16);
    audit->issuePlace = (char *)malloc(16);
    memset(audit->issuePlace, 0, 16);

    /* ;;; outward is default */
    audit->isOwnAudit = '\0';
    audit->isInward = '\0';
    audit->isTicketing = '\0';
    audit->isNotRuleApply = '\0';
    audit->nonProrateRest = '\0';
    audit->inwardNumber = (char *)malloc(2);
    memset(audit->inwardNumber, 0, 2);

    audit->tourCode = (char *)malloc(2);
    memset(audit->tourCode, 0, 2);
    audit->agentCode = (char *)malloc(2);
    memset(audit->agentCode, 0, 2);

    audit->origin = (char *)malloc(2);
    memset(audit->origin, 0, 2);
    audit->destination = (char *)malloc(2);
    memset(audit->destination, 0, 2);

    audit->currency = (char *)malloc(4);
    memset(audit->currency, 0, 4);
    audit->ticketFare = (double)0;
    audit->salesCurrency = (char *)malloc(4);
    memset(audit->salesCurrency, 0, 4);
    audit->salesFare = (double)0;
    audit->totalNuc = 0;
    audit->stopOverCharge = (double)0;

    audit->commissionCurrency = (char *)malloc(4);
    memset(audit->commissionCurrency, 0, 4);
    strcpy(audit->commissionCurrency, audit->currency);
    audit->commissionRate = (double)0;
    audit->commissionAmt = (double)0;

    audit->roeRate = (double)0;
    audit->day5Rate = (double)0;
    audit->lessAmt = (double)0;
    audit->plusAdjustment = (double)0;
    audit->lessAdjustment = (double)0;

    audit->endorsement = (char *)malloc(2);
    memset(audit->endorsement, 0, 2);

    audit->fareCalculation = (char *)malloc(2);
    memset(audit->fareCalculation, 0, 2);

    audit->fixedFare = (double)0;

    /* ;;; deBug no tax */
    audit->tax.length(3);
    audit->tax[0].type = (char *)malloc(2);
    memset(audit->tax[0].type, 0, 2);
    audit->tax[0].amount = (double)0;
    audit->tax[1].type = (char *)malloc(2);
    memset(audit->tax[1].type, 0, 2);
    audit->tax[1].amount = (double)0;
    audit->tax[2].type = (char *)malloc(2);
    memset(audit->tax[2].type, 0, 2);
    audit->tax[2].amount = (double)0;
    /*
    audit->taxMisc.length(10);
    for (i = 0; i < 10; i++) {
	audit->taxMisc[i].type = (char *)malloc(2);
	memset(audit->taxMisc[i].type, 0, 2);
	audit->taxMisc[i].amount = (double)0;
    }
    */
    audit->taxMisc.length(0);

    audit->traceLevel = 0;	/* ;;; deBug traceLevel 0 */

    audit->plusFlg = '\0';
    audit->ownAirwayId = (char *)malloc(2);
    memset(audit->ownAirwayId, 0, 2);
    audit->errorFlag = 0;
    audit->errorString = (char *)malloc(2);
    memset(audit->errorString, 0, 2);

    audit->sectors.length(no_sectors);

    audit->askTable.length(0);

    for (i = 0; i < no_sectors; i++) {
	sp = &audit->sectors[i];

	sp->invoiceFlg = '\0';
	sp->flightNo = (char *)malloc(2);
	memset(sp->flightNo, 0, 2);
	sp->flightDate = (char *)malloc(2);
	memset(sp->flightDate, 0, 2);
	sp->sequenceNo = i;
	sp->stopOver = '\0';
	sp->depAirport = (char *)malloc(4);
	memset(sp->depAirport, 0, 4);
	sp->destAirport = (char *)malloc(4);
	memset(sp->destAirport, 0, 4);
	sp->depCode = (char *)malloc(4);
	memset(sp->depCode, 0, 4);
	sp->destCode = (char *)malloc(4);
	memset(sp->destCode, 0, 4);
	sp->carrier = (char *)malloc(3);
	memset(sp->carrier, 0, 3);
	sp->classOfService = (char *)malloc(16);
	memset(sp->classOfService, 0, 16);
	sp->fareBasis = (char *)malloc(16);
	memset(sp->fareBasis, 0, 16);

	sp->prorateValue = (double)0;
	sp->invoiceValue = (double)0;

	sp->componentIndex = 0;
	sp->componentKind = 0;
	sp->fareComponent = (double)0;
	sp->classDiffPlus = (double)0;
	sp->secureCharge = (double)0;
	sp->sideTripPlus = (double)0;
	sp->stopOverPlus = (double)0;
	sp->prorateFactor = (double)0;
	sp->commission = (double)0;
	sp->tax = (double)0;
	sp->amountInLocal = (double)0;
	sp->taxInLocal = (double)0;
	sp->taxIndex = 0L;
	//sp->classDifferNo = 0;
	sp->viaRouting = (char *)malloc(2);
	memset(sp->viaRouting, 0, 2);
	sp->prorationType = 0;
	sp->certainty = (double)1;
	sp->spaBaseAmtType = (char *)malloc(4);
	memset(sp->spaBaseAmtType, 0, 4);
	sp->spaBaseAmt = (double)0;
	sp->spaDay5Rate = (double)0;
	sp->spaDiscountRate = (double)0;
	sp->spaClassDiff = (double)0;
	sp->npPvalues = (double)0;
	sp->apdpBaseAmtType = (char *)malloc(4);
	memset(sp->apdpBaseAmtType, 0, 4);
	sp->apdpBaseAmt = (double)0;
	sp->apdpDay5Rate = (double)0;
	sp->apdpDiscountRate = (double)0;
	sp->apdpClassDiff = (double)0;
	sp->proratedClassDiff = (double)0;
	sp->exstPlus = (double)0;
	sp->proratedExstPlus = (double)0;
	sp->proratedSecureCharge = (double)0;
	sp->spaNuc = (double)0;
	sp->apdpNuc = (double)0;
	sp->srpNuc = (double)0;
	sp->sideTripIndex = '\0';
	sp->classDiffIndex = '\0';
	sp->secureIndex = '\0';
	sp->fixedFareCheck = (double)0;
	sp->fixedFareDiscount = (double)0;
	sp->opCarrier = (char *)malloc(3);
	memset(sp->opCarrier, 0, 3);
	sp->errorFlag = 0;
	sp->errorString = "";
	sp->errorString = (char *)malloc(2);
	memset(sp->errorString, 0, 2);
    }
}

int	cmpSector(const void *ptr1, const void *ptr2) {
    return (((struct ProrateSectorJdl *)ptr1)->sequenceNo
	    - ((struct ProrateSectorJdl *)ptr2)->sequenceNo);
}

int	input_ticket_data(void)
{
    char	string[4096];
    int	no_sectors;
    char	*ptr, *fptr;
    register int	i = 0;
    register ProrateSectorJdl	*sp;
    char	ticket_number[16];
    memset(ticket_number, 0, 16);
    int	ticket_coupon = 0, inward_number = 0;
    char	from[8], to[8];
    int	diff_p = 0, side_p = 0;

    if (!audit->invoiceMonth || !*audit->invoiceMonth) {
	audit->invoiceMonth = (char *)malloc(16);
	memset(audit->invoiceMonth, 0, 16);
    }

    /* ;;; outward is default */
    audit->isInward = '\0';
    audit->isTicketing = '\0';
    audit->isNotRuleApply = '\0';
    audit->nonProrateRest = '\0';
    if (!audit->inwardNumber || !*audit->inwardNumber) {
	audit->inwardNumber = (char *)malloc(4);
	memset(audit->inwardNumber, 0, 4);
    }
    audit->tourCode = (char *)malloc(2);
    memset(audit->tourCode, 0, 2);
    audit->agentCode = (char *)malloc(2);
    memset(audit->agentCode, 0, 2);

    /* ;;; no tax is default */
    audit->tax.length(3);
    audit->tax[0].type = (char *)malloc(2);
    memset(audit->tax[0].type, 0, 2);
    audit->tax[0].amount = (double)0;
    audit->tax[1].type = (char *)malloc(2);
    memset(audit->tax[1].type, 0, 2);
    audit->tax[1].amount = (double)0;
    audit->tax[2].type = (char *)malloc(2);
    memset(audit->tax[2].type, 0, 2);
    audit->tax[2].amount = (double)0;
    /*
    audit->taxMisc.length(10);
    for (i = 0; i < 10; i++) {
	audit->taxMisc[i].type = (char *)malloc(2);
	memset(audit->taxMisc[i].type, 0, 2);
	audit->taxMisc[i].amount = (double)0;
    }
    */
    audit->taxMisc.length(0);

    // audit->traceLevel = 0;	/* ;;; deBug traceLevel 0 */

    audit->airwayNumber = (char *)malloc(8);
    memset(audit->airwayNumber, 0, 8);
    audit->airwayId = (char *)malloc(4);
    memset(audit->airwayId, 0, 4);

    audit->issueDate = (char *)malloc(16);
    memset(audit->issueDate, 0, 16);
    audit->issuePlace = (char *)malloc(16);
    memset(audit->issuePlace, 0, 16);

    fprintf(stderr, "ticket_number etc. :\n");
    if (!fgets(string, 80, t_fp)) exit(100);
    sscanf(string, "%s %d %d", ticket_number, &ticket_coupon, &inward_number);
    ticket_number[3] = '\0';
    strcpy(audit->airwayNumber, ticket_number);
    if (inward_number) {
	audit->isInward = (char)1;
	audit->isOwnAudit = (char)1;
	if (!*audit->inwardNumber) {
	    sprintf(audit->inwardNumber, "%03d", inward_number);
	}
    }

    fprintf(stderr, "endorsement :\n");
    if (!fgets(string, 80, t_fp)) exit(100);
    if (string[strlen(string)-1] == '\n') {
	string[strlen(string)-1] = '\0';
    }
    audit->endorsement = (char *)malloc(strlen(string)+1);
    memset(audit->endorsement, 0, strlen(string)+1);
    strcpy(audit->endorsement, string);

    fprintf(stderr, "place_issue, date of issue :\n");
    char	invoice_month[8];
    memset(invoice_month, 0, 8);
    if (!fgets(string, 80, t_fp)) exit(100);
    char	issuePlace[128];
    memset(issuePlace, 0, 128);
    char	issueDate[128];
    memset(issueDate, 0, 128);
    char	agentCode[128];
    memset(agentCode, 0, 128);
    char	tourCode[128];
    memset(tourCode, 0, 128);
    sscanf(string, "%s %s %s %s %s",
	   issuePlace, issueDate, invoice_month, agentCode, tourCode);
    audit->issueDate = (char *)malloc(strlen(issueDate)+1);
    memset(audit->issueDate, 0, strlen(issueDate)+1);
    audit->issuePlace = (char *)malloc(strlen(issuePlace)+1);
    memset(audit->issuePlace, 0, strlen(issuePlace)+1);
    audit->agentCode = (char *)malloc(strlen(agentCode)+1);
    memset(audit->agentCode, 0, strlen(agentCode)+1);
    audit->tourCode = (char *)malloc(strlen(tourCode)+1);
    memset(audit->tourCode, 0, strlen(tourCode)+1);
    strcpy(audit->issuePlace, issuePlace);
    strcpy(audit->issueDate, issueDate);
    strcpy(audit->agentCode, agentCode);
    strcpy(audit->tourCode, tourCode);
    if (!*audit->invoiceMonth) {
	invoice_month[6] = '\0';
	strcpy(audit->invoiceMonth, invoice_month);
    }
    if (!*audit->invoiceMonth) {
	issueDate[6] = '\0';
	strcpy(audit->invoiceMonth, issueDate);
    }

    fprintf(stderr, "origin, destination :\n");
    if (!fgets(string, 80, t_fp)) exit(100);
    /* ;;; delete origin destination */
    char	origin[128];
    char	destination[128];
    memset(origin, 0, strlen(origin));
    memset(destination, 0, strlen(destination));
    sscanf(string, "%s - %s", origin, destination);
    audit->origin = (char *)malloc(strlen(origin)+1);
    memset(audit->origin, 0, strlen(origin)+1);
    audit->destination = (char *)malloc(strlen(destination)+1);
    memset(audit->destination, 0, strlen(destination)+1);
    strcpy(audit->origin, origin);
    strcpy(audit->destination, destination);

    audit->currency = (char *)malloc(4);
    memset(audit->currency, 0, 4);
    audit->ticketFare = (double)0;
    audit->salesCurrency = "";
    audit->salesFare = (double)0;
    audit->totalNuc = 0;
    audit->stopOverCharge = (double)0;

    fprintf(stderr, "fare, total nuc :\n");
    if (!fgets(string, 80, t_fp)) exit(100);
    char	currency[8];
    memset(currency, 0, 8);
    double	ticketFare;
    double	totalNuc;
    double	stopOverCharge;
    sscanf(string, "%s %lf %lf %lf",
	   currency, &ticketFare, &totalNuc, &stopOverCharge);
    strcpy(audit->currency, currency);
    audit->ticketFare = ticketFare;
    audit->totalNuc = totalNuc;
    audit->stopOverCharge = stopOverCharge;
    if (audit->isOwnAudit) {
        audit->salesCurrency = audit->currency;
	audit->salesFare = audit->ticketFare;
    }
    /*
    sprintf(audit->originalFare, "%s %lf",
	    audit->salesCurrency, audit->ticketFare);
	    */
    audit->commissionCurrency = audit->currency;
    audit->commissionRate = (double)9;
    audit->commissionAmt = (double)0;

    audit->roeRate = (double)0;
    audit->day5Rate = (double)0;
    audit->lessAmt = (double)0;
    audit->plusAdjustment = (double)0;
    audit->lessAdjustment = (double)0;

    memset(string, 0, 4096);
    fprintf(stderr, "tax :\n");
    if (!fgets(string, 4096, t_fp)) exit(100);
    /* tax 0 */
    fptr = string;
    audit->taxMisc.length(10);
    for (i = 0; i < 10; i++) {
	for (ptr = fptr; *ptr && (*ptr == ' ' || *ptr == '\t'); ptr++);
	if (!*ptr) {
	    break;
	}
	/* ;;; indicator is ':'
	for (fptr = ptr;
	     *fptr && *fptr!=' ' && *fptr!='\t' && (*fptr<'0' || *fptr>'9');
	     fptr ++);
	*/
	fptr = index(ptr, ':');
	if (!fptr) {
	    break;
	}
	*fptr = '\0';
	char	type[128];
	memset(type, 0, 128);
	strncpy(type, ptr, fptr-ptr);
	type[fptr-ptr] = '\0';
	audit->taxMisc[i].type = (char *)malloc(fptr - ptr + 1);
	strcpy(audit->taxMisc[i].type, type);
	fptr++;	/* ;;; indicator is ':' */
	sscanf(fptr, "%lf", &audit->taxMisc[i].amount);
	if (i < 3) {
	    audit->tax[i].amount = audit->taxMisc[i].amount;
	}
	else {
	    audit->tax[2].amount += audit->taxMisc[i].amount;
	}
	for ( ; *fptr && (*fptr=='.' || (*fptr>='0' && *fptr<='9')); fptr++);
    }
    audit->taxMisc.length(i);
    /* tax end */

    memset(string, 0, 4096);
    fprintf(stderr, "fare calculation :\n");
    if (!fgets(string, 4096, t_fp)) exit(100);
    if (string[strlen(string)-1] == '\n') {
	string[strlen(string)-1] = '\0';
    }
    audit->fareCalculation = (char *)malloc(strlen(string)+1);
    memset(audit->fareCalculation, 0, strlen(string)+1);
    strcpy(audit->fareCalculation, string);

    audit->fixedFare = (double)0;

    audit->plusFlg = '\0';
    audit->ownAirwayId = (char *)malloc(2);
    memset(audit->ownAirwayId, 0, 2);
    audit->errorFlag = 0;
    audit->errorString = (char *)malloc(2);
    memset(audit->errorString, 0, 2);

    fprintf(stderr, " number of sectors :\n");
    if (!fgets(string, 80, t_fp)) exit(100);
    sscanf(string, "%d", &no_sectors);
    audit->sectors.length(no_sectors);

    audit->askTable.length((u_int)0);

    for (i = 0; i < no_sectors; i++) {
	sp = &audit->sectors[i];

	if (i == ticket_coupon) {
	    sp->invoiceFlg = (char)1;
	}
	else {
	    sp->invoiceFlg = '\0';
	}

	fprintf(stderr, "sector info :\n");
	sp->flightNo = (char *)malloc(64);
	memset(sp->flightNo, 0, 64);
	sp->sequenceNo = i;
	sp->depCode = (char *)malloc(4);
	memset(sp->depCode, 0, 4);
	sp->destCode = (char *)malloc(4);
	memset(sp->destCode, 0, 4);
	sp->depAirport = (char *)malloc(4);
	memset(sp->depAirport, 0, 4);
	sp->destAirport = (char *)malloc(4);
	memset(sp->destAirport, 0, 4);
	sp->carrier = (char *)malloc(3);
	memset(sp->carrier, 0, 3);
	sp->classOfService = (char *)malloc(16);
	memset(sp->classOfService, 0, 16);
	sp->fareBasis = (char *)malloc(16);
	memset(sp->fareBasis, 0, 16);
	sp->flightDate = (char *)malloc(16);
	memset(sp->flightDate, 0, 16);

	if (i == 0) cerr << "";	// deBug

	sp->prorateValue = (double)0;
	sp->invoiceValue = (double)0;

	sp->componentIndex = 0;
	sp->componentKind = 0;
	sp->fareComponent = (double)0;
	sp->classDiffPlus = (double)0;
	sp->secureCharge = (double)0;
	if (!fgets(string, 80, t_fp)) exit(200);
	diff_p = side_p = 0;
	char	fareBasis[128];
	memset(fareBasis, 0, 8);
	char	carrier[8];
	memset(carrier, 0, 8);
	char	classOfService[8];
	memset(classOfService, 0, 8);
	char	flight_date[16];
	memset(flight_date, 0, 16);
	char	flightNo[8];
	memset(flightNo, 0, 8);
	sscanf(string, "%s - %s %s %s %s %lf %s %lf %lf %d %d %s",
	       from, to, fareBasis, carrier, classOfService,
	       &sp->fareComponent, flight_date, &sp->secureCharge,
	       &sp->classDiffPlus, &diff_p, &side_p, flightNo);
	strcpy(sp->fareBasis, fareBasis);
	strcpy(sp->carrier, carrier);
	strcpy(sp->classOfService, classOfService);
	strcpy(sp->flightNo, flightNo);
	if (sp->fareComponent == (double)-2) {
	    sp->fareComponent = (double)0;
	}
	else if (sp->fareComponent == (double)0) {
	    sp->fareComponent = (double)-1;
	}
	sp->secureIndex = (sp->secureCharge > (double)0 ? 'Q' : 0);
	sp->classDiffIndex = (diff_p ? 'D' : '\0');
	sp->sideTripIndex = (side_p ? 'S' : '\0');
	sp->sideTripPlus = (double)0;
	if (side_p) {
	    sp->sideTripPlus = sp->fareComponent;
	    sp->fareComponent = (double)-1;
	}
	if (!strncmp(from, "X/", 2)) {
	    sp->stopOver = 'X';
	    strcpy(sp->depCode, from+2);
	}
	else {
	    strcpy(sp->depCode, from);
	}
	if (!strncmp(to, "X/", 2)) {
	    strcpy(sp->destCode, to+2);
	}
	else {
	    strcpy(sp->destCode, to);
	}
	if (flight_date == NULL || flight_date[0] == '\0') {
	    strcpy(sp->flightDate, "");
	}
	else if (strlen(flight_date) < 6) {
	    char	flightDate[8];
	    memset(flightDate, 0, 8);
	    strncpy(flightDate, audit->issueDate, 4);
	    strncat(flightDate, flight_date, 2);
	    strncat(flightDate, flight_date+3, 2);
	    strcpy(sp->flightDate, flightDate);
	}
	else {
	    strcpy(sp->flightDate, flight_date);
	}

	sp->stopOverPlus = (double)0;
	sp->prorateFactor = (double)0;
	sp->commission = (double)0;
	sp->tax = (double)0;
	sp->amountInLocal = (double)0;
	sp->taxInLocal = (double)0;
	//sp->classDifferNo = 0;
	sp->viaRouting = (char *)malloc(4);
	memset(sp->viaRouting, 0, 4);
	sp->prorationType = 0;
	sp->certainty = (double)1;
	sp->spaBaseAmtType = (char *)malloc(4);
	memset(sp->spaBaseAmtType, 0, 4);
	sp->spaBaseAmt = (double)0;
	sp->spaDay5Rate = (double)0;
	sp->spaDiscountRate = (double)0;
	sp->spaClassDiff = (double)0;
	sp->npPvalues = (double)0;
	sp->apdpBaseAmtType = (char *)malloc(4);
	memset(sp->apdpBaseAmtType, 0, 4);
	sp->apdpBaseAmt = (double)0;
	sp->apdpDay5Rate = (double)0;
	sp->apdpDiscountRate = (double)0;
	sp->apdpClassDiff = (double)0;
	sp->proratedClassDiff = (double)0;
	sp->exstPlus = (double)0;
	sp->proratedExstPlus = (double)0;
	sp->spaNuc = (double)0;
	sp->apdpNuc = (double)0;
	sp->srpNuc = (double)0;
	sp->fixedFareCheck = (double)0;
	sp->fixedFareDiscount = (double)0;
	sp->opCarrier = (char *)malloc(3);
	memset(sp->opCarrier, 0, 3);
	sp->errorFlag = 0;
	sp->errorString = (char *)malloc(2);
	memset(sp->errorString, 0, 2);
    }
    qsort((void *)(&audit->sectors[0]),
	  no_sectors, sizeof(ProrateSectorJdl_var), cmpSector);

    print_ticket();
    return no_sectors;
}

void	print_ticket(void)
{
    register ProrateSectorJdl	*sp;
    register int	i;

    cout << "ISSUED BY " << audit->airwayNumber
	 << " " << audit->airwayId << endl;
    cout << "ENDORSE: " << audit->endorsement
	 << "	DATE OF ISSUE: " << audit->issueDate
	 << "	PLACE: " << audit->issuePlace << endl;
    /* ;;; delete origin destination
    cout << "ORIGIN/DESTINATION: " << audit->origin
	 << " " << audit->destination << endl;
    */
    cout << "FARE: " << audit->currency << " " << audit->ticketFare
	 << " SALES: " << audit->salesCurrency << " " << audit->salesFare
	 << " TOTAL-NUC: " << audit->totalNuc << endl;
    cout << "COMMISSION: "
	 << audit->commissionCurrency << ":" << audit->commissionAmt
	 << " rate " << audit->commissionRate << endl;

    cout << "TAX: " << audit->tax[0].amount << ":" << audit->tax[1].amount
	 << ":" << audit->tax[2].amount << endl;

    for (i = 0; i < (int)audit->taxMisc.length(); i++) {
	cout << audit->taxMisc[i].type <<
	    ":" << audit->taxMisc[i].amount << " ";
    }
    cout << endl;
    cout << "ERROR: " << audit->errorFlag << " " << audit->errorString << endl;

    cout <<
	"from - to car rou  fl# cl date     f-basis  secure differ sidetr fcomp"
	 << endl;
    for (i = 0 , sp = &audit->sectors[i];
	 i < (int)audit->sectors.length();
	 i++ , sp++) {
	cout << "(" << sp->sequenceNo << ")"
	     << sp->depCode << " - " << sp->destCode
	     << " " << sp->carrier
	     << " (" << sp->flightNo << ")  " << sp->classOfService
	     << " " << sp->flightDate << " " << sp->fareBasis
	     << " " << sp->secureIndex << ":" << sp->secureCharge
	     << " " << sp->classDiffIndex << ":" << sp->classDiffPlus
	     << " " << sp->sideTripIndex << ":" << sp->sideTripPlus
	     << " " << sp->fareComponent << endl;
	cout << "(" << sp->componentKind
	     << ")	SPA(" << sp->spaDiscountRate * 100
	     << "%of" << sp->spaBaseAmtType << sp->spaBaseAmt
	     << ")" << sp->spaNuc
	     << " : APDP(" << sp->apdpDiscountRate * 100
	     << "%of" << sp->apdpBaseAmtType << sp->apdpBaseAmt
	     << ")" << sp->apdpNuc
	     << "FIX" << sp->fixedFareCheck << "/" <<  sp->fixedFareDiscount
	     << "  : SRP" << sp->srpNuc << endl;
	cout << "	PRO-TYPE " << sp->prorationType
	     << "  PRO_FACTOR " << sp->prorateFactor
	     << "  PRO-VAL " << sp->prorateValue
	     << " NP " << sp->npPvalues << endl;
	cout << "	DIFF " << sp->classDiffIndex
	     << ":" << sp->proratedClassDiff
	     << " SEC " << sp->secureIndex << ":" << sp->proratedSecureCharge
	     << "/" << sp->secureCharge << endl;
	cout << "	TAX (0x" << sp->taxIndex << ") : " << sp->tax
	     << " COMM " << sp->commission << endl;
	cout << "	ERROR: " << sp->errorFlag << " " << sp->errorString
	     << endl;
    }

    /* fare calculation */
    cout << "FARE_CAL: " << audit->fareCalculation << endl;

    /* trace strings */
    if (audit->traceStrings.length() > 0) {
	cout << "TRACE: (level: " << audit->traceLevel << ")" << endl;
	for (i = 0; i < (int)audit->traceStrings.length(); i++) {
	    cout << audit->traceStrings[i] << endl;
	}
    }

    cout << endl;
}
