#include <CORBA.h>
#include <coss/CosNaming.h>
#include "Prorate.h"

using namespace std;
using namespace jp::sourceforge::gnp::prorate::jdl;

ProrateJdl	*createRef(int argc, char *argv[])
{
  // ORB initialization
  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv);

  /*
   * Acquire a reference to the Naming Service
   */

  CORBA::Object_var nsobj =
    orb->resolve_initial_references ("NameService");

  CosNaming::NamingContext_var nc = 
    CosNaming::NamingContext::_narrow (nsobj);

  if (CORBA::is_nil (nc)) {
    cerr << "oops, I cannot access the Naming Service!" << endl;
    exit (1);
  }

  /*
   * Construct Naming Service name for our ProrateJdl
   */

  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup ("Prorate");
  name[0].kind = CORBA::string_dup ("");
  
  /*
   * try to find that node in the Naming Service tree
   */

  CORBA::Object_var obj;

  cout << "Looking up Prorate ... " << flush;

#ifdef HAVE_EXCEPTIONS
  try {
    obj = nc->resolve (name);
  }
  catch (CosNaming::NamingContext::NotFound &exc) {
    cout << "NotFound exception." << endl;
    exit (1);
  }
  catch (CosNaming::NamingContext::CannotProceed &exc) {
    cout << "CannotProceed exception." << endl;
    exit (1);
  }
  catch (CosNaming::NamingContext::InvalidName &exc) {
    cout << "InvalidName exception." << endl;
    exit (1);
  }
#else
  obj = nc->resolve (name);
#endif

  cout << "done." << endl;

  /*
   * The Naming Service returns a generic reference as a CORBA::Object
   * We need to narrow this to the desired type
   */

  ProrateJdl	*prorate = ProrateJdl::_narrow (obj);

  if (CORBA::is_nil (prorate)) {
      printf ("oops: I cannot access the Prorate Service!");
      exit (1);
  }

  return prorate;
}
