/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.audit.struts.service;

import jp.sourceforge.gnp.audit.ejb.client.AuditEjbClient;
import jp.sourceforge.gnp.audit.ejb.interfaces.AuditEjb;
import jp.sourceforge.gnp.audit.struts.service.AuditService;
import jp.sourceforge.gnp.audit.struts.view.AuditView;
import jp.sourceforge.gnp.audit.struts.view.ProrateView;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;

public class AuditServiceEjb
extends AuditService {
    AuditEjb ejb = AuditEjbClient.makeInstance();

    @Override
    public AuditView persist(String ticketNumber, ProrateAudit audit) {
        try {
            this.ejb.persist(ticketNumber, audit);
        }
        catch (Exception e) {
            e.printStackTrace();
            AuditView errorView = this.createErrorView(ticketNumber, audit);
            errorView.setErrorString(e.getMessage());
            if (errorView.getErrorString() == null) {
                errorView.setErrorString(e.toString());
            }
            return errorView;
        }
        AuditView auditView = this.createView(ticketNumber, audit);
        return auditView;
    }

    @Override
    public AuditView remove(String ticketNumber, ProrateAudit audit) {
        try {
            this.ejb.remove(ticketNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            AuditView errorView = this.createErrorView(ticketNumber, audit);
            errorView.setErrorString(e.getMessage());
            if (errorView.getErrorString() == null) {
                errorView.setErrorString(e.toString());
            }
            return errorView;
        }
        AuditView auditView = this.createView(ticketNumber, audit);
        return auditView;
    }

    @Override
    public AuditView find(String ticketNumber, ProrateAudit audit) {
        ProrateAudit auditRet = null;
        try {
            auditRet = this.ejb.find(ticketNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            AuditView errorView = this.createErrorView(ticketNumber, audit);
            errorView.setErrorString(e.getMessage());
            if (errorView.getErrorString() == null) {
                errorView.setErrorString(e.toString());
            }
            return errorView;
        }
        if (auditRet == null) {
            AuditView errorView = this.createErrorView(ticketNumber, audit);
            errorView.setErrorString("ticketNumber [" + ticketNumber + "] : audit not found");
            return errorView;
        }
        auditRet.setOwnAirwayId(audit.getOwnAirwayId());
        auditRet.setOwnAudit(audit.isOwnAudit());
        auditRet.setTicketing(audit.isTicketing());
        auditRet.setInward(audit.isInward());
        auditRet.setTraceLevel(audit.getTraceLevel());
        ProrateView prorateView = this.createProrateView(ticketNumber, auditRet);
        return prorateView;
    }

    @Override
    public AuditView prorate(String ticketNumber, ProrateAudit audit) {
        ProrateAudit auditRet = null;
        try {
            auditRet = this.ejb.prorate(ticketNumber, audit);
        }
        catch (Exception e) {
            e.printStackTrace();
            AuditView errorView = this.createErrorView(ticketNumber, audit);
            errorView.setErrorString(e.getMessage());
            if (errorView.getErrorString() == null) {
                errorView.setErrorString(e.toString());
            }
            return errorView;
        }
        ProrateView prorateView = this.createProrateView(ticketNumber, auditRet);
        return prorateView;
    }
}

