/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncApplyDiscount
extends ProrateFunc {
    ProrateFuncApplyDiscount(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(1, "Apply_discount", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        double percent = 0.0;
        ProrateRuleObject pobj = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (pobj == null) {
            this.setErrorObject();
            return null;
        }
        if (pobj.isMultival()) {
            List values = ((ProrateRuleMultival)pobj).getValues();
            for (int i = 0; i < values.size(); ++i) {
                double d;
                ProrateRuleObject pobj2 = (ProrateRuleObject)values.get(i);
                values.set(i, pobj2.copy(runtime));
                ProrateRuleObject subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
                if (subobj == null) {
                    this.setErrorObject();
                    return null;
                }
                if (!subobj.isString()) {
                    this.error(2, "Apply_discount:1", runtime);
                    return null;
                }
                percent = this.parseDiscount(runtime.sector.getFareBasis(), subobj);
                if (!(d > 0.0)) {
                    continue;
                }
                break;
            }
        } else {
            if (!pobj.isString()) {
                this.error(2, "Apply_discount:1", runtime);
                return null;
            }
            percent = this.parseDiscount(runtime.sector.getFareBasis(), pobj);
        }
        percent = 100.0 - percent;
        if (runtime.isSPA) {
            runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate() * percent / 100.0);
            runtime.sector.setSpaNuc(runtime.sector.getSpaNuc() * percent / 100.0);
            if ((runtime.sector.getProrationType() & 0x200) != 0) {
                ProrateSector sector;
                for (int i = runtime.sectorIndex + 1; i < runtime.fcomp.getSectors().length && ((sector = runtime.fcomp.getSectors()[i]).getProrationType() & 0x200) != 0; ++i) {
                    runtime.sector.setSpaDiscountRate(sector.getSpaDiscountRate() * percent / 100.0);
                    runtime.sector.setSpaNuc(sector.getSpaNuc() * percent / 100.0);
                }
            }
        } else {
            runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate() * percent / 100.0);
            runtime.sector.setApdpNuc(runtime.sector.getApdpNuc() * percent / 100.0);
            runtime.sector.setFixedFareDiscount(runtime.sector.getFixedFareDiscount() * percent / 100.0);
            if ((runtime.sector.getProrationType() & 0x800) != 0) {
                ProrateSector sector;
                for (int i = runtime.sectorIndex + 1; i < runtime.fcomp.getSectors().length && ((sector = runtime.fcomp.getSectors()[i]).getProrationType() & 0x800) != 0; ++i) {
                    runtime.sector.setApdpDiscountRate(sector.getApdpDiscountRate() * percent / 100.0);
                    runtime.sector.setApdpNuc(sector.getApdpNuc() * percent / 100.0);
                }
            }
        }
        this.setEvaluatedObject(new ProrateRuleBool(true));
        return pobj;
    }

    double parseDiscount(String fareBasis, ProrateRuleObject pobj) {
        String code = ((ProrateRuleString)pobj).getValue();
        String str = null;
        if (code.substring(0, 1).equals("^")) {
            if (fareBasis.length() >= code.length() + 1 && fareBasis.substring(0, code.length() - 1).equals(code.substring(1))) {
                double ret = 0.0;
                str = fareBasis.substring(code.length() - 1);
                ret = Double.parseDouble(str);
                return ret;
            }
            return 0.0;
        }
        int i = fareBasis.indexOf(code);
        while (i >= 0) {
            if (fareBasis.length() >= code.length() + i && fareBasis.substring(i, i + code.length()).equals(code)) {
                double discount = 0.0;
                str = fareBasis.substring(code.length() + i);
                if (str.length() == 0) break;
                if (str.charAt(0) >= '0' && str.charAt(0) <= '9') {
                    discount = Double.parseDouble(str);
                    if (discount == 100.0) {
                        discount = 0.0;
                    } else if (discount == 100.0) {
                        discount = 0.0;
                    }
                    return discount;
                }
                str = code.substring(0, 2);
                for (int j = 0; j < discount_code.length; ++j) {
                    if (!str.equals(discount_code[j])) continue;
                    if (discount == 100.0) {
                        discount = 0.0;
                    } else if (discount == 100.0) {
                        discount = 0.0;
                    }
                    return discount;
                }
            }
            i = fareBasis.indexOf(code, i + 1);
        }
        return 0.0;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncApplyDiscount pobj = new ProrateFuncApplyDiscount(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Apply_discount(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Apply_discount";
    }
}

