/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

abstract class ProrateRuleAO
extends ProrateRuleObject {
    protected List statements;

    ProrateRuleAO(List statements) {
        this.statements = statements;
    }

    public ProrateRuleObject evalAO(ProrateRuntime runtime, boolean status) throws Exception {
        ProrateRuleObject ret = null;
        runtime.status = status;
        if (runtime.status == status) {
            for (int i = 0; i < this.statements.size(); ++i) {
                ProrateRuleObject pobj = (ProrateRuleObject)this.statements.get(i);
                this.statements.set(i, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.statements.get(i)).eval(runtime);
                if (!runtime.apply) {
                    this.setEvaluatedObject(new ProrateRuleBool(false));
                    return ret;
                }
                runtime.status = !ret.isFalse();
                if (runtime.status != status) break;
            }
        }
        ret = new ProrateRuleBool(ret != null ? ret.isTrue() : runtime.status);
        this.setEvaluatedObject(ret);
        return ret;
    }

    @Override
    public void dump() {
        for (int i = 0; i < this.statements.size(); ++i) {
            ((ProrateRuleObject)this.statements.get(i)).dump();
        }
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        if (!this.isEvaluated()) {
            return false;
        }
        if (!this.traceStatements()) {
            return false;
        }
        String traceStr = this.traceAO();
        if (!trace.trace(traceStr, sector.getSequenceNo(), level)) {
            return false;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            trace.trace((ProrateRuleObject)this.statements.get(i), sector, level + 1);
        }
        return true;
    }

    String traceAO() {
        StringBuffer traceStr = new StringBuffer("");
        traceStr.append(this.traceValueStr());
        if (this.traceStatements()) {
            traceStr.append("[");
            for (int i = 0; i < this.statements.size(); ++i) {
                if (i > 0) {
                    traceStr.append(" ");
                }
                traceStr.append(((ProrateRuleObject)this.statements.get(i)).traceStr());
                if (traceStr.charAt(traceStr.length() - 1) != '(') continue;
                traceStr.append(")");
            }
            traceStr.append("]");
        }
        return traceStr.toString();
    }

    boolean traceStatements() {
        return this.evaluatedObject != null;
    }

    @Override
    boolean unification() {
        for (int i = 0; i < this.statements.size(); ++i) {
            if (!((ProrateRuleObject)this.statements.get(i)).unification()) continue;
            return true;
        }
        return false;
    }
}

