/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRuleDate
extends ProrateRuleObject {
    private short month;
    private short day;

    ProrateRuleDate(short in_month, short in_day) {
        this.month = in_month;
        this.day = in_day;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        return this;
    }

    @Override
    boolean isDate() {
        return true;
    }

    short getMonth() {
        return this.month;
    }

    short getDay() {
        return this.day;
    }

    @Override
    boolean equal(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.equal(this);
        }
        if (other.isDate()) {
            return this.month == ((ProrateRuleDate)other).getMonth() && this.day == ((ProrateRuleDate)other).getDay();
        }
        return false;
    }

    @Override
    boolean gtEq(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.ltEq(this);
        }
        if (other.isDate()) {
            return this.month > ((ProrateRuleDate)other).getMonth() || this.month == ((ProrateRuleDate)other).getMonth() && this.day >= ((ProrateRuleDate)other).getDay();
        }
        return false;
    }

    @Override
    boolean ltEq(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.gtEq(this);
        }
        if (other.isDate()) {
            return this.month < ((ProrateRuleDate)other).getMonth() || this.month == ((ProrateRuleDate)other).getMonth() && this.day <= ((ProrateRuleDate)other).getDay();
        }
        return false;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleDate pobj = new ProrateRuleDate(this.month, this.day);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print(" " + this.month + "/" + this.day + " ");
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        return false;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.month);
        strbuf.append("/");
        strbuf.append(this.day);
        return strbuf.toString();
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

