/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

class ProrateRuleInterval
extends ProrateRuleObject {
    protected ProrateRuleObject low;
    protected ProrateRuleObject high;

    ProrateRuleInterval(ProrateRuleObject in_low, ProrateRuleObject in_high) {
        this.low = in_low;
        this.high = in_high;
    }

    ProrateRuleInterval(ProrateRulebaseElement in_low, ProrateRulebaseElement in_high) {
        this.low = (ProrateRuleObject)in_low;
        this.high = (ProrateRuleObject)in_high;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        this.evaluatedObject = this;
        return this;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleInterval pobj = new ProrateRuleInterval(this.low.copy(runtime), this.high.copy(runtime));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("INTER(");
        this.low.dump();
        System.out.print("-");
        this.high.dump();
        System.out.print(")");
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.low.toString());
        if (strbuf.charAt(strbuf.length() - 1) == '(') {
            strbuf.append(")");
        }
        strbuf.append("-");
        strbuf.append(this.high.toString());
        if (strbuf.charAt(strbuf.length() - 1) == '(') {
            strbuf.append(")");
        }
        return strbuf.toString();
    }

    @Override
    String traceStr() {
        return this.toString();
    }

    @Override
    boolean isInterval() {
        return true;
    }

    @Override
    boolean equal(ProrateRuleObject other) {
        if (other.isMultival()) {
            return other.equal(this);
        }
        return other.gtEq(this.low) && other.ltEq(this.high);
    }

    @Override
    boolean gtEq(ProrateRuleObject other) {
        if (other.isMultival()) {
            return other.ltEq(this);
        }
        return other.ltEq(this.high);
    }

    @Override
    boolean ltEq(ProrateRuleObject other) {
        if (other.isMultival()) {
            return other.gtEq(this);
        }
        return other.gtEq(this.low);
    }

    @Override
    boolean include(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            if (other.isIncluded(this.low)) {
                return true;
            }
            if (other.isIncluded(this.high)) {
                return true;
            }
        } else {
            if (this.low.include(other)) {
                return true;
            }
            if (this.high.include(other)) {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isIncluded(ProrateRuleObject other) {
        if (other.include(this.low)) {
            return true;
        }
        return other.include(this.high);
    }
}

