/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

class ProrateRulePercent
extends ProrateRuleObject {
    protected double percent;
    protected ProrateRuleObject amount;

    ProrateRulePercent(double in_percent, ProrateRuleObject obj) {
        this.percent = in_percent;
        this.amount = obj;
    }

    ProrateRulePercent(double in_percent, ProrateRulebaseElement obj) {
        this.percent = in_percent;
        this.amount = (ProrateRuleObject)obj;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        this.evaluatedObject = this;
        if (runtime.isSPA) {
            runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate() * this.percent / 100.0);
        } else {
            runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate() * this.percent / 100.0);
        }
        this.amount = this.amount.copy(runtime);
        return this.amount.eval(runtime);
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRulePercent pobj = new ProrateRulePercent(this.percent, this.amount.copy(runtime));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print(this.percent + "%of ");
        this.amount.dump();
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        if (!this.isEvaluated()) {
            return false;
        }
        trace.trace(this.traceStr(), sector.getSequenceNo(), level);
        trace.trace(this.amount, sector, level + 1);
        return true;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.percent);
        strbuf.append("%of ");
        strbuf.append(this.amount.toString());
        if (strbuf.charAt(strbuf.length() - 1) == '(') {
            strbuf.append(")");
        }
        return strbuf.toString();
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

