/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRulePath;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateVar;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateVarMultiPath
extends ProrateVar {
    ProrateVarMultiPath() {
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        return this;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateVarMultiPath pobj = new ProrateVarMultiPath();
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    boolean isMultiPath() {
        return true;
    }

    ProrateRuleObject makePath(ProrateRuntime runtime, ProrateRuleObject pobj) {
        int hops = 0;
        Vector<ProrateRuleString> vector = new Vector<ProrateRuleString>();
        if (pobj.isMultival()) {
            pobj = (ProrateRuleObject)((ProrateRuleMultival)pobj).getValues().get(0);
        }
        hops = !pobj.isPath() ? 2 : ((ProrateRulePath)pobj).getLength();
        runtime.hops = hops;
        ProrateRuleObject from = null;
        if (!(runtime.sector.getDepCode().equals(runtime.sector.getDepAirport()) || runtime.sector.getDepCode().equals("") || runtime.sector.getDepAirport().equals(""))) {
            Vector<ProrateRuleString> values = new Vector<ProrateRuleString>();
            ProrateRuleString city = new ProrateRuleString(runtime.sector.getDepCode());
            values.add(city);
            ProrateRuleString port = new ProrateRuleString(runtime.sector.getDepAirport());
            values.add(port);
            from = new ProrateRuleMultival(values);
        } else {
            from = new ProrateRuleString(runtime.sector.getDepCode());
        }
        ProrateRuleObject to = null;
        if (!(runtime.sector.getDestCode().equals(runtime.sector.getDestAirport()) || runtime.sector.getDestCode().equals("") || runtime.sector.getDestAirport().equals(""))) {
            Vector<ProrateRuleString> values = new Vector<ProrateRuleString>();
            ProrateRuleString city = new ProrateRuleString(runtime.sector.getDestCode());
            values.add(city);
            ProrateRuleString port = new ProrateRuleString(runtime.sector.getDestAirport());
            values.add(port);
            to = new ProrateRuleMultival(values);
        } else {
            to = new ProrateRuleString(runtime.sector.getDestCode());
        }
        vector.add((ProrateRuleString)from);
        vector.add((ProrateRuleString)to);
        if (hops == 2) {
            this.setEvaluatedObject(new ProrateRulePath(vector));
            return this.evaluatedObject;
        }
        int hopsMade = 2;
        for (int i = runtime.sectorIndex + 1; i < runtime.sectorIndex + hops && i < runtime.fcomp.getSectors().length && hopsMade < hops; ++hopsMade, ++i) {
            ProrateSector sector = runtime.fcomp.getSectors()[i];
            String lastDest = runtime.fcomp.getSectors()[i - 1].getDestCode();
            if (!runtime.sector.getCarrier().equals(sector.getCarrier()) || !runtime.sector.getFareBasis().equals(sector.getFareBasis()) || !runtime.sector.getClassOfService().equals(sector.getClassOfService()) || !lastDest.equals(sector.getDepCode())) break;
            if (!(sector.getDestCode().equals(sector.getDestAirport()) || sector.getDestCode().equals("") || sector.getDestAirport().equals(""))) {
                Vector<ProrateRuleString> values = new Vector<ProrateRuleString>();
                ProrateRuleString city = new ProrateRuleString(sector.getDestCode());
                values.add(city);
                ProrateRuleString port = new ProrateRuleString(sector.getDestAirport());
                values.add(port);
                to = new ProrateRuleMultival(values);
            } else {
                to = new ProrateRuleString(sector.getDestCode());
            }
            vector.add((ProrateRuleString)to);
        }
        if (hopsMade == hops) {
            runtime.hops = hops;
        }
        this.setEvaluatedObject(new ProrateRulePath(vector));
        return this.evaluatedObject;
    }

    @Override
    public void dump() {
        System.out.print("$MULTI-PATH");
    }

    public String toString() {
        return "$MULTI-PATH";
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

