/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.rmi;

import java.rmi.RemoteException;
import java.util.List;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.rmi.RemoteProrate;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;

public class PortableRemoteProrateServer
extends PortableRemoteObject
implements RemoteProrate {
    static ProrateImpl prorate = null;

    public static void main(String[] args) {
        try {
            PortableRemoteProrateServer server = new PortableRemoteProrateServer();
            if (!PortableRemoteProrateServer.initialize()) {
                System.exit(1);
            }
            String name = System.getProperty("proratename", "RemoteProrate");
            InitialContext initialNamingContext = new InitialContext();
            initialNamingContext.rebind(name, (Object)server);
            System.out.println(name + " is open and ready for customers.");
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Usage: java [-Dproratename=<name>] PortableRemoteProrateServer");
            System.exit(1);
        }
    }

    static boolean initialize() {
        XmlRulebaseLru rulebase = null;
        try {
            rulebase = new XmlRulebaseLru();
            XmlRulebaseLru.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("proration service rulebase initialization failed:" + e.getMessage());
            return false;
        }
        ProrateRuleObjectFactory factory = new ProrateRuleObjectFactory();
        rulebase.setElementFactory(factory);
        prorate = new ProrateImpl();
        prorate.setRulebase(rulebase);
        prorate.setFcalc(new ProrateFCalcImpl());
        prorate.setTax(new ProrateTaxImpl());
        ProrateTraceString trace = new ProrateTraceString();
        prorate.setTrace(trace);
        prorate.setDatabase(new ProrateRdb());
        if (!prorate.getDatabase().openDatabase()) {
            System.err.println("proration service database initialization failed:" + prorate.getDatabase().getErrMessage());
            return false;
        }
        return true;
    }

    @Override
    public ProrateAudit prorate(ProrateAudit audit) throws Exception {
        prorate.getTrace().setData(audit);
        ProrateAudit auditRet = prorate.prorate(audit);
        prorate.getTrace().close();
        List traceStrings = ((ProrateTraceString)prorate.getTrace()).getStrings();
        String[] traceStringsArray = new String[traceStrings.size()];
        for (int i = 0; i < traceStrings.size(); ++i) {
            traceStringsArray[i] = (String)traceStrings.get(i);
        }
        auditRet.setTraceStrings(traceStringsArray);
        return auditRet;
    }
}

