/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.sourceforge.gnp.prubae.PrubaeControllerDo;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelCase;
import jp.sourceforge.gnp.prubae.PrubaeModelSwitch;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerSwitch
extends PrubaeControllerDo {
    private JPanel argsCountPanel;
    private JLabel argsCountLabel;
    private JTextField argsCountField;
    private JButton argsCountButton;
    private int argsCount = 0;

    @Override
    protected void createButtons() {
        this.getPanel().add(new JLabel("SWITCH"));
        JButton caseButton = new JButton("add case");
        caseButton.setActionCommand("case");
        caseButton.addActionListener(this);
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new BoxLayout(opPanel, 1));
        opPanel.add(caseButton);
        this.panel.add(opPanel);
        this.setArgsCountPanel(new JPanel());
        this.setArgsCountLabel(new JLabel("COUNT"));
        this.setArgsCountField(new JTextField("", 4));
        this.setArgsCountButton(new JButton("INPUT"));
        this.getArgsCountButton().setActionCommand("set vars");
        this.getArgsCountButton().addActionListener(this);
        this.getArgsCountPanel().setLayout(new BoxLayout(this.getArgsCountPanel(), 0));
        this.getArgsCountPanel().add(this.argsCountLabel);
        this.getArgsCountPanel().add(this.getArgsCountField());
        this.getArgsCountPanel().add(this.argsCountButton);
        this.getPanel().add(this.getArgsCountPanel());
    }

    @Override
    public void initialize() {
        super.initialize();
        List caseVec = ((PrubaeModelSwitch)this.getModel()).getCases();
        if (caseVec != null) {
            for (int i = 0; i < caseVec.size(); ++i) {
                DefaultMutableTreeNode node = ((PrubaeModel)caseVec.get(i)).getController().getTreeNode();
                this.getTreeNode().add(node);
            }
        }
        this.setArgsCount(0);
    }

    @Override
    public void update() {
        ((PrubaeModelSwitch)this.getModel()).updateVars();
        super.update();
    }

    @Override
    public void destroyPanel() {
        this.setArgsCountPanel(null);
        this.setArgsCountLabel(null);
        this.setArgsCountField(null);
        this.setArgsCountButton(null);
        super.destroyPanel();
    }

    private void addCases() {
        List casesVec = ((PrubaeModelSwitch)this.getModel()).getCases();
        if (casesVec != null) {
            PrubaeModelCase last = new PrubaeModelCase();
            last.addToParent(casesVec, this.getModel());
            last.getController().addTreeNode(this.getTreeNode());
        }
    }

    private void updateArgsCount() {
        ((PrubaeModelSwitch)this.getModel()).updateVars();
        int numArgs = 0;
        try {
            numArgs = Integer.parseInt(this.getArgsCountField().getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        int oldArgsCount = this.getArgsCount();
        this.setArgsCount(numArgs);
        if (numArgs > oldArgsCount) {
            this.addArguments(oldArgsCount, numArgs);
        } else if (numArgs < oldArgsCount) {
            this.removeArguments(numArgs, oldArgsCount);
        }
    }

    private void addArguments(int minArgs, int numArgs) {
        if (((PrubaeModelSwitch)this.getModel()).getVars() == null) {
            ((PrubaeModelSwitch)this.getModel()).setVars(new Vector());
        }
        for (int i = minArgs; i < numArgs; ++i) {
            PrubaeModelValueStatement ret = new PrubaeModelValueStatement();
            ret.setComment("");
            ret.setStatement("");
            ret.initialize(this.getEditor(), (PrubaeModelSwitch)this.getModel(), ((PrubaeModelSwitch)this.getModel()).getVars());
            ((PrubaeModel)ret).openUI();
            ((PrubaeModelSwitch)this.getModel()).getVars().add(ret);
            this.getPanel().add(ret.getController().getPanel());
        }
    }

    private void removeArguments(int minArgs, int numArgs) {
        for (int i = numArgs - 1; i >= minArgs; --i) {
            PrubaeModelValue ret = (PrubaeModelValue)((PrubaeModelSwitch)this.getModel()).getVars().get(i);
            this.getPanel().remove(ret.getController().getPanel());
            ret.closeUI();
            ((PrubaeModelSwitch)this.getModel()).getVars().remove(ret);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            this.deleteAndUp();
        } else if (e.getActionCommand().equals("insert")) {
            this.insert();
        } else {
            System.err.println("action = " + e.getActionCommand());
            if (e.getActionCommand().equals("case")) {
                this.addCases();
            } else if (e.getActionCommand().equals("set vars")) {
                this.updateArgsCount();
            }
            this.getView().display();
        }
    }

    @Override
    public Object clone() {
        PrubaeControllerSwitch clone = null;
        clone = (PrubaeControllerSwitch)super.clone();
        if (this.getArgsCountPanel() != null) {
            clone.setArgsCountPanel(new JPanel());
        }
        if (this.getArgsCountField() != null) {
            clone.setArgsCountField(new JTextField());
        }
        return clone;
    }

    public void setArgsCountPanel(JPanel theArgsCountPanel) {
        this.argsCountPanel = theArgsCountPanel;
    }

    public JPanel getArgsCountPanel() {
        return this.argsCountPanel;
    }

    public void setArgsCountLabel(JLabel theArgsCountLabel) {
        this.argsCountLabel = theArgsCountLabel;
    }

    public JLabel getArgsCountLabel() {
        return this.argsCountLabel;
    }

    public void setArgsCountField(JTextField theArgsCountField) {
        this.argsCountField = theArgsCountField;
    }

    public JTextField getArgsCountField() {
        return this.argsCountField;
    }

    public void setArgsCountButton(JButton theArgsCountButton) {
        this.argsCountButton = theArgsCountButton;
    }

    public JButton getArgsCountButton() {
        return this.argsCountButton;
    }

    public void setArgsCount(int theArgsCount) {
        this.argsCount = theArgsCount;
    }

    public int getArgsCount() {
        return this.argsCount;
    }
}

