/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.Prubae;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

public class PrubaeModelValue
extends PrubaeModel {
    private String statement = null;
    private List values = null;
    private Object type = null;
    private Object requiredType = null;

    public PrubaeModelValue() {
        this.setView(null);
        this.setController(null);
        this.setStatement("");
        this.setValues(new Vector());
    }

    @Override
    public void initialize(Prubae editor, PrubaeModel parent, List parentList) {
        System.err.println("modelValue initialize() " + this);
        this.setEditor(editor);
        if (this.getView() != null) {
            this.getView().setEditor(editor);
        }
        if (this.getController() != null) {
            this.getController().setEditor(editor);
            this.getController().initialize();
        }
        this.setParent(parent);
        this.setParentList(parentList);
    }

    @Override
    public void closeUI() {
        if (this.getValues() != null) {
            for (int i = 0; i < this.getValues().size(); ++i) {
                if (!(this.getValues().get(i) instanceof PrubaeModel)) continue;
                ((PrubaeModel)this.getValues().get(i)).closeUI();
            }
        }
    }

    @Override
    public String toString() {
        if (this.getComment() != null && !this.getComment().equals("")) {
            return this.getComment();
        }
        if (this.getStatement() == null || this.getStatement().equals("")) {
            return "Value";
        }
        return this.getStatement();
    }

    public void updateStatement() {
        if (this.getValues() == null || this.getValues().size() <= 0) {
            return;
        }
        this.setStatement("");
        for (int i = 0; i < this.getValues().size(); ++i) {
            if (i > 0) {
                this.setStatement(this.getStatement() + " ");
            }
            if (this.getValues().get(i) instanceof PrubaeModelValue) {
                PrubaeController cntl;
                if (this.getValues().get(i) instanceof PrubaeModelValueStatement && (cntl = ((PrubaeModel)this.getValues().get(i)).getController()) != null) {
                    cntl.update();
                }
                ((PrubaeModelValue)this.getValues().get(i)).updateStatement();
                this.setStatement(this.getStatement() + ((PrubaeModelValue)this.getValues().get(i)).getStatement());
                continue;
            }
            this.setStatement(this.getStatement() + this.getValues().get(i).toString());
        }
    }

    @Override
    public void writeModel(ProrateRulebaseWriter rulebase) {
        rulebase.writeValue(this);
    }

    @Override
    public int getSize(ProrateRulebaseWriter rulebase) {
        return rulebase.getValueSize(this);
    }

    @Override
    public Object clone() {
        PrubaeModelValue clone = null;
        clone = (PrubaeModelValue)super.clone();
        if (this.getValues() != null) {
            clone.setValues((List)((Vector)this.getValues()).clone());
            for (int i = 0; i < this.getValues().size(); ++i) {
                Object arg = this.getValues().get(i);
                if (!(arg instanceof PrubaeModel)) continue;
                clone.getValues().set(i, ((PrubaeModel)arg).clone());
                ((PrubaeModel)clone.getValues().get(i)).initialize(this.getEditor(), clone, clone.getValues());
            }
        }
        return clone;
    }

    @Override
    public boolean check(List errors) {
        int numArgs;
        LList list = Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList());
        LList valueList = Lisp.assoc(new IntNum((int)this.getRegist()), list);
        if (valueList == null) {
            errors.add("illegal regist code " + this.getRegist());
            return false;
        }
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        if (isArgs != null && isArgs instanceof IntNum && (numArgs = ((IntNum)isArgs).intValue()) >= 0 && (this.getValues() != null || numArgs != 0) && this.getValues().size() != numArgs) {
            errors.add("illegal argument count in " + this.getName() + " function");
            return false;
        }
        for (int i = 0; i < this.getValues().size(); ++i) {
            Object value = this.getValues().get(i);
            if (!(value instanceof PrubaeModel) || ((PrubaeModel)value).check(errors)) continue;
            errors.add("in argument #" + (i + 1) + " of " + this.getName() + " function");
            return false;
        }
        return true;
    }

    @Override
    public void setStatement(String theStatement) {
        this.statement = theStatement;
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    public void setValues(List theValues) {
        this.values = theValues;
    }

    public List getValues() {
        return this.values;
    }

    public Object getType() {
        return this.type;
    }

    public void setType(Object type) {
        this.type = type;
    }

    public Object getRequiredType() {
        if (this.parent != null && this.parent.getRegist() == 528) {
            return Lisp.list("string", "airport");
        }
        return this.requiredType;
    }

    public void setRequiredType(Object requiredType) {
        this.requiredType = requiredType;
    }
}

