/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.List;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeControllerValueStatement;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeViewValueStatement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

public class PrubaeModelValueStatement
extends PrubaeModelValue
implements PrubaeModelStatement {
    private String name = null;

    @Override
    public void openUI() {
        boolean isControllActive;
        if (this.getView() == null) {
            this.setView(new PrubaeViewValueStatement());
        }
        this.getView().setModel(this);
        boolean bl = isControllActive = this.getController() != null;
        if (!isControllActive) {
            this.setController(new PrubaeControllerValueStatement());
        }
        this.getController().setModel(this);
        this.getView().setController(this.getController());
        this.getController().setView(this.getView());
        this.initialize(this.getEditor(), this.getParent(), this.getParentList());
        if (!isControllActive) {
            this.getController().createPanel();
        }
    }

    @Override
    public void closeUI() {
        super.closeUI();
        if (this.getController() != null) {
            ((PrubaeControllerValueStatement)this.getController()).update();
            ((PrubaeControllerValueStatement)this.getController()).removePanel();
        }
        this.setView(null);
        this.setController(null);
    }

    @Override
    public String toString() {
        if (this.getComment() != null && !this.getComment().equals("")) {
            return this.getComment();
        }
        if (this.getStatement() == null || this.getStatement().equals("")) {
            return "ValueStatement";
        }
        return this.getStatement();
    }

    @Override
    public void updateStatement() {
        String funcName = null;
        LList list = Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList());
        LList item = Lisp.assoc(new IntNum((int)this.getRegist()), list);
        if (item != null) {
            funcName = Lisp.car(Lisp.cdr(item)) == null || Lisp.isNil(Lisp.car(Lisp.cdr(item))) ? "" : Lisp.car(Lisp.cdr(item)).toString();
        }
        if (funcName == null) {
            funcName = "";
        }
        if (funcName != null && funcName.length() > 0) {
            this.setName(funcName);
        } else if (this.getName() != null && this.getName().length() > 0) {
            funcName = this.getName();
        }
        if (this.getValues() == null || this.getValues().size() <= 0) {
            if (funcName != null && funcName.length() > 0) {
                if ((this.getRegist() & 0x800) != 0) {
                    this.setStatement(funcName + "()");
                } else {
                    this.setStatement(funcName);
                }
            }
            return;
        }
        if (this.getRegist() == 513) {
            this.setStatement("");
            this.setStatement(this.getStatement() + (Number)this.getValues().get(0));
            return;
        }
        if (this.getRegist() == 514) {
            this.setStatement("");
            this.setStatement(this.getStatement() + (Short)this.getValues().get(0));
            this.setStatement(this.getStatement() + "/");
            this.setStatement(this.getStatement() + (Short)this.getValues().get(1));
            return;
        }
        if (this.getRegist() == 516) {
            this.setStatement("\"");
            this.setStatement(this.getStatement() + (String)this.getValues().get(0));
            this.setStatement(this.getStatement() + "\"");
            return;
        }
        if (this.getRegist() == 528 || this.getRegist() == 321 || this.getRegist() == 322) {
            String marker = this.getRegist() == 321 ? "," : "-";
            this.setStatement("");
            for (int i = 0; i < this.getValues().size(); ++i) {
                if (i > 0) {
                    this.setStatement(this.getStatement() + marker);
                }
                if (this.getValues().get(i) instanceof PrubaeModelValue) {
                    PrubaeController cntl;
                    if (this.getValues().get(i) instanceof PrubaeModelValueStatement && (cntl = ((PrubaeModel)this.getValues().get(i)).getController()) != null) {
                        cntl.update();
                    }
                    ((PrubaeModelValue)this.getValues().get(i)).updateStatement();
                    this.setStatement(this.getStatement() + ((PrubaeModelValue)this.getValues().get(i)).getStatement());
                    continue;
                }
                this.setStatement(this.getStatement() + this.getValues().get(i).toString());
            }
            return;
        }
        this.setStatement(funcName + "(");
        for (int i = 0; i < this.getValues().size(); ++i) {
            if (i > 0) {
                this.setStatement(this.getStatement() + " ");
            }
            if (this.getValues().get(i) instanceof PrubaeModelValue) {
                PrubaeController cntl;
                if (this.getValues().get(i) instanceof PrubaeModelValueStatement && (cntl = ((PrubaeModel)this.getValues().get(i)).getController()) != null) {
                    cntl.update();
                }
                ((PrubaeModelValue)this.getValues().get(i)).updateStatement();
                this.setStatement(this.getStatement() + ((PrubaeModelValue)this.getValues().get(i)).getStatement());
                continue;
            }
            this.setStatement(this.getStatement() + this.getValues().get(i).toString());
        }
        this.setStatement(this.getStatement() + ")");
        if (this.getStatement().equals("()")) {
            this.setStatement("");
        }
    }

    @Override
    public void writeModel(ProrateRulebaseWriter rulebase) {
        rulebase.writeValueStatement(this);
    }

    @Override
    public int getSize(ProrateRulebaseWriter rulebase) {
        return rulebase.getValueStatementSize(this);
    }

    @Override
    public boolean check(List errors) {
        int numArgs;
        LList list = Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList());
        LList valueList = Lisp.assoc(new IntNum((int)this.getRegist()), list);
        if (valueList == null) {
            errors.add("illegal regist code " + this.getRegist());
            return false;
        }
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        if (isArgs != null && isArgs instanceof IntNum && (numArgs = ((IntNum)isArgs).intValue()) >= 0 && (this.getValues() != null || numArgs != 0) && this.getValues().size() != numArgs) {
            errors.add("illegal argument count in " + this.getName() + " function");
            return false;
        }
        if (this.getValues() != null) {
            for (int i = 0; i < this.getValues().size(); ++i) {
                Object value = this.getValues().get(i);
                if (!(value instanceof PrubaeModel) || ((PrubaeModel)value).check(errors)) continue;
                errors.add("in argument #" + (i + 1) + " of " + this.getName() + " function");
                return false;
            }
        }
        return true;
    }

    @Override
    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

