/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;

public class SpyTextMessage
extends SpyMessage
implements Cloneable,
TextMessage,
Externalizable {
    private static final long serialVersionUID = 235726945332013953L;
    String content;
    private static final int chunkSize = 16384;

    public void setText(String string) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Cannot set the content; message is read-only");
        }
        this.content = string;
    }

    public String getText() throws JMSException {
        return this.content;
    }

    public void clearBody() throws JMSException {
        this.content = null;
        super.clearBody();
    }

    public SpyMessage myClone() throws JMSException {
        SpyTextMessage result = MessagePool.getTextMessage();
        result.copyProps(this);
        result.content = this.content;
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte type = in.readByte();
        if (type == 9) {
            this.content = null;
        } else {
            int chunksToRead = in.readInt();
            int bufferSize = 16384 * chunksToRead;
            if (chunksToRead == 1) {
                int inSize = in.available();
                if (inSize <= 0) {
                    inSize = 256;
                }
                bufferSize = Math.min(inSize, bufferSize);
            }
            StringBuffer sb = new StringBuffer(bufferSize);
            for (int i = 0; i < chunksToRead; ++i) {
                sb.append(in.readUTF());
            }
            this.content = sb.toString();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.content == null) {
            out.writeByte(9);
        } else {
            ArrayList<String> v = new ArrayList<String>();
            for (int contentLength = this.content.length(); contentLength > 0; contentLength -= 16384) {
                int beginCopy = v.size() * 16384;
                int endCopy = contentLength <= 16384 ? beginCopy + contentLength : beginCopy + 16384;
                String theChunk = this.content.substring(beginCopy, endCopy);
                v.add(theChunk);
            }
            out.writeByte(8);
            out.writeInt(v.size());
            for (int i = 0; i < v.size(); ++i) {
                out.writeUTF((String)v.get(i));
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SpyTextMessage {\n").append(this.header).append('\n');
        buffer.append("Body {\n   text            :").append(this.content).append('\n');
        buffer.append("}\n}");
        return buffer.toString();
    }
}

