/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.rmi.RMIClientILRemote;

public class RMIClientIL
extends UnicastRemoteObject
implements RMIClientILRemote {
    private static final long serialVersionUID = -2587261916187410219L;
    Connection connection;
    boolean stopped = true;

    public RMIClientIL(Connection c) throws RemoteException {
        this.connection = c;
    }

    public void close() throws Exception {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchClose();
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchDeleteTemporaryDestination(dest);
    }

    public void receive(ReceiveRequest[] messages) throws Exception {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchDeliver(messages);
    }

    public void pong(long serverTime) throws JMSException {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchPong(serverTime);
    }
}

