/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.timer;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerNotification;
import org.jboss.logging.Logger;
import org.jboss.mx.timer.JBossTimerMBean;
import org.jboss.mx.util.RunnableScheduler;
import org.jboss.mx.util.SchedulableRunnable;

public class JBossTimer
extends NotificationBroadcasterSupport
implements JBossTimerMBean,
MBeanRegistration {
    private static Logger log = Logger.getLogger(JBossTimer.class);
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private static final int SEND_NO = 0;
    private static final int SEND_START = 1;
    private static final int SEND_NORMAL = 2;
    int nextId = 0;
    long sequenceNumber = 0L;
    boolean sendPastNotifications = false;
    boolean active = false;
    ObjectName objectName;
    HashMap notifications = new HashMap();
    private RunnableScheduler scheduler = new RunnableScheduler();

    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurences) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, occurences, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate) throws IllegalArgumentException {
        int newId = 0;
        newId = ++this.nextId;
        Integer id = new Integer(newId);
        RegisteredNotification rn = new RegisteredNotification(id, type, message, userData, date, period, nbOccurences, fixedRate);
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            this.notifications.put(id, rn);
            rn.setNextRun(rn.nextDate);
            rn.setScheduler(this.scheduler);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllNotificationIDs() {
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            return new Vector(this.notifications.keySet());
        }
    }

    public Date getDate(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return new Date(rn.startDate);
    }

    public int getNbNotifications() {
        return this.notifications.size();
    }

    public Long getNbOccurences(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return new Long(rn.occurences);
    }

    public Boolean getFixedRate(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return new Boolean(rn.fixedRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNotificationIDs(String type) {
        Vector<Integer> result = new Vector<Integer>();
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            for (RegisteredNotification rn : this.notifications.values()) {
                if (!rn.type.equals(type)) continue;
                result.add(rn.id);
            }
        }
        return result;
    }

    public String getNotificationMessage(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return rn.message;
    }

    public String getNotificationType(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return rn.type;
    }

    public Object getNotificationUserData(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return rn.userData;
    }

    public Long getPeriod(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
        if (rn == null) {
            return null;
        }
        return new Long(rn.period);
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmpty() {
        return this.notifications.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotifications() {
        Object object = this.notifications;
        synchronized (object) {
            Iterator iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                RegisteredNotification rn = (RegisteredNotification)((Object)iterator.next());
                rn.setScheduler(null);
                iterator.remove();
            }
        }
        object = this;
        synchronized (object) {
            this.nextId = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(Integer id) throws InstanceNotFoundException {
        log.debug("removeNotification: " + this.objectName + ",id=" + id);
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            RegisteredNotification rn = (RegisteredNotification)((Object)this.notifications.get(id));
            if (rn == null) {
                throw new InstanceNotFoundException("No notification id : " + id.toString());
            }
            rn.setScheduler(null);
            this.notifications.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifications(String type) throws InstanceNotFoundException {
        boolean found = false;
        log.debug("removeNotifications: " + this.objectName + ",type=" + type);
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Iterator iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                RegisteredNotification rn = (RegisteredNotification)((Object)iterator.next());
                if (!rn.type.equals(type)) continue;
                rn.setScheduler(null);
                iterator.remove();
                found = true;
            }
        }
        if (!found) {
            throw new InstanceNotFoundException("Nothing registered for type: " + type);
        }
    }

    public void setSendPastNotifications(boolean value) {
        log.debug("setSendPastNotifications: " + this.objectName + ",value=" + value);
        this.sendPastNotifications = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        log.debug("start: " + this.objectName + " at " + new Date());
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            for (RegisteredNotification rn : this.notifications.values()) {
                rn.sendType = this.sendPastNotifications ? 1 : 0;
                this.sendNotifications(rn);
                rn.sendType = 2;
            }
        }
        this.scheduler.start();
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        log.debug("stop: " + this.objectName + ",now=" + new Date());
        this.active = false;
        this.scheduler.stop();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotifications(RegisteredNotification rn) {
        while (this.isActive() && rn.nextDate != 0L && rn.nextDate <= System.currentTimeMillis()) {
            if (rn.sendType != 0) {
                long seq = 0L;
                JBossTimer jBossTimer = this;
                synchronized (jBossTimer) {
                    seq = ++this.sequenceNumber;
                }
                log.debug("sendNotification: " + (Object)((Object)rn));
                TimerNotification tn = new TimerNotification(rn.type, this.objectName, seq, rn.nextDate, rn.message, rn.id);
                tn.setUserData(rn.userData);
                this.sendNotification(tn);
            }
            do {
                if (rn.calcNextDate()) continue;
                HashMap hashMap = this.notifications;
                synchronized (hashMap) {
                    log.debug("remove: " + (Object)((Object)rn));
                    this.notifications.remove(rn.id);
                }
            } while (this.isActive() && rn.sendType != 1 && rn.nextDate != 0L && rn.occurences == 0L && rn.nextDate < System.currentTimeMillis());
        }
        if (rn.nextDate != 0L) {
            rn.setNextRun(rn.nextDate);
        }
    }

    private class RegisteredNotification
    extends SchedulableRunnable {
        public Integer id;
        public String type;
        public String message;
        public Object userData;
        public long startDate;
        public long period;
        public long occurences;
        public boolean fixedRate;
        public int sendType = 2;
        public long nextDate = 0L;

        public RegisteredNotification(Integer id, String type, String message, Object userData, Date startDate, long period, long occurences, boolean fixedRate) throws IllegalArgumentException {
            if (startDate == null) {
                throw new IllegalArgumentException("Null Date");
            }
            if (period < 0L) {
                throw new IllegalArgumentException("Negative Period");
            }
            if (occurences < 0L) {
                throw new IllegalArgumentException("Negative Occurences");
            }
            this.startDate = startDate.getTime();
            if (startDate.getTime() < System.currentTimeMillis()) {
                log.debug("startDate [" + startDate + "] in the past, set to now");
                this.startDate = System.currentTimeMillis();
            }
            this.id = id;
            this.type = type;
            this.message = message;
            this.userData = userData;
            this.period = period;
            this.occurences = occurences;
            this.fixedRate = fixedRate;
            this.nextDate = this.startDate;
            String msgStr = "new " + this.toString();
            log.debug(msgStr);
        }

        boolean calcNextDate() {
            if (this.period == 0L) {
                this.nextDate = 0L;
                return false;
            }
            if (this.occurences != 0L && --this.occurences == 0L) {
                this.nextDate = 0L;
                return false;
            }
            this.nextDate = this.fixedRate ? (this.nextDate += this.period) : System.currentTimeMillis() + this.period;
            return true;
        }

        public void doRun() {
            JBossTimer.this.sendNotifications(this);
        }

        public String toString() {
            return " RegisteredNotification: [timer=" + JBossTimer.this.objectName + ",id=" + this.id + ",startDate=" + new Date(this.startDate) + ",period=" + this.period + ",occurences=" + this.occurences + ",fixedRate=" + this.fixedRate + ",nextDate=" + new Date(this.nextDate) + "]";
        }
    }
}

