/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;
import gnu.kawa.functions.AppendValues;

public class FindTailCalls
extends ExpWalker {
    boolean inTailContext = true;

    public static void findTailCalls(Expression exp, Compilation comp) {
        FindTailCalls walker = new FindTailCalls();
        walker.setContext(comp);
        walker.walk(exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkApplyExp(ApplyExp exp) {
        if (this.inTailContext) {
            exp.setTailCall(true);
        }
        exp.context = this.currentLambda;
        boolean save = this.inTailContext;
        LambdaExp lexp = null;
        try {
            this.inTailContext = false;
            boolean isAppendValues = false;
            if (exp.func instanceof ReferenceExp) {
                ReferenceExp func = (ReferenceExp)exp.func;
                Declaration binding = Declaration.followAliases(func.binding);
                if (binding != null) {
                    Expression value;
                    if (!binding.getFlag(2048)) {
                        exp.nextCall = binding.firstCall;
                        binding.firstCall = exp;
                    }
                    Compilation comp = this.getCompilation();
                    binding.setCanCall();
                    if (!comp.mustCompile) {
                        binding.setCanRead();
                    }
                    if ((value = binding.getValue()) instanceof LambdaExp) {
                        lexp = (LambdaExp)value;
                    }
                }
            } else if (exp.func instanceof LambdaExp && !(exp.func instanceof ClassExp)) {
                lexp = (LambdaExp)exp.func;
                this.walkLambdaExp(lexp, false);
                lexp.setCanCall(true);
            } else if (exp.func instanceof QuoteExp && ((QuoteExp)exp.func).getValue() == AppendValues.appendValues) {
                isAppendValues = true;
            } else {
                exp.func = exp.func.walk(this);
            }
            if (!(lexp == null || lexp.returnContinuation == exp || lexp == this.currentLambda && save)) {
                lexp.returnContinuation = lexp.returnContinuation == null ? exp : LambdaExp.unknownContinuation;
            }
            if (isAppendValues && exp.args.length > 0) {
                int last = exp.args.length - 1;
                exp.args = this.walkExps(exp.args, last);
                this.inTailContext = save;
                exp.args[last] = this.walk(exp.args[last]);
            } else {
                exp.args = this.walkExps(exp.args);
            }
            ApplyExp applyExp = exp;
            return applyExp;
        }
        finally {
            this.inTailContext = save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkBeginExp(BeginExp exp) {
        boolean save = this.inTailContext;
        try {
            int n = exp.length - 1;
            for (int i = 0; i <= n; ++i) {
                this.inTailContext = i == n && save;
                exp.exps[i] = exp.exps[i].walk(this);
            }
            BeginExp beginExp = exp;
            return beginExp;
        }
        finally {
            this.inTailContext = save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkFluidLetExp(FluidLetExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            decl.setCanRead(true);
            decl.setCanWrite(true);
            if (decl.base == null) continue;
            decl.base.setCanRead(true);
            decl.base.setCanWrite(true);
        }
        boolean save = this.inTailContext;
        this.inTailContext = false;
        try {
            Expression expression = super.walkFluidLetExp(exp);
            return expression;
        }
        finally {
            this.inTailContext = save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkLetExp(LetExp exp) {
        int n = exp.inits.length;
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Declaration decl = exp.firstDecl();
            int i = 0;
            while (i < n) {
                Expression value;
                Expression init = this.walkSetExp(decl, exp.inits[i]);
                if (init == QuoteExp.undefined_exp && ((value = decl.getValue()) instanceof LambdaExp || value != init && value instanceof QuoteExp)) {
                    init = value;
                }
                exp.inits[i] = init;
                ++i;
                decl = decl.nextDecl();
            }
        }
        finally {
            this.inTailContext = save;
        }
        exp.body = exp.body.walk(this);
        this.walkDecls(exp);
        return exp;
    }

    public void walkDecls(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            ReferenceExp rexp;
            Declaration context;
            Expression value = decl.getValue();
            if (value instanceof LambdaExp) {
                LambdaExp lexp = (LambdaExp)value;
                if (decl.getCanRead()) {
                    lexp.setCanRead(true);
                }
                if (decl.getCanCall()) {
                    lexp.setCanCall(true);
                }
            }
            if (!decl.getFlag(1024) || !(value instanceof ReferenceExp) || (context = (rexp = (ReferenceExp)value).contextDecl()) == null || !context.isPrivate()) continue;
            context.setFlag(524288);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkIfExp(IfExp exp) {
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            exp.test = exp.test.walk(this);
        }
        finally {
            this.inTailContext = save;
        }
        exp.then_clause = exp.then_clause.walk(this);
        Expression else_clause = exp.else_clause;
        if (else_clause != null) {
            exp.else_clause = else_clause.walk(this);
        }
        return exp;
    }

    @Override
    protected Expression walkLambdaExp(LambdaExp exp) {
        this.walkLambdaExp(exp, true);
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void walkLambdaExp(LambdaExp exp, boolean canRead) {
        boolean save = this.inTailContext;
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        if (canRead) {
            exp.setCanRead(true);
        }
        try {
            this.inTailContext = false;
            if (exp.defaultArgs != null) {
                exp.defaultArgs = this.walkExps(exp.defaultArgs);
            }
            boolean bl = this.inTailContext = exp.getInlineOnly() ? save : true;
            if (this.exitValue == null && exp.body != null) {
                exp.body = exp.body.walk(this);
            }
        }
        finally {
            this.inTailContext = save;
            this.currentLambda = parent;
        }
        this.walkDecls(exp);
        LambdaExp child = exp.firstChild;
        while (child != null) {
            if (child.getCanRead() || child.isClassMethod() || child.min_args != child.max_args) {
                child.flags |= 0x20;
            } else {
                ApplyExp caller = child.returnContinuation;
                if (caller != LambdaExp.unknownContinuation && !this.comp.usingCPStyle()) {
                    child.setInlineOnly(true);
                }
            }
            child = child.nextSibling;
        }
        child = exp.firstChild;
        while (child != null) {
            if ((child.flags & 0x21) != 0) {
                // empty if block
            }
            child = child.nextSibling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkClassExp(ClassExp exp) {
        boolean save = this.inTailContext;
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        exp.setCanRead(true);
        try {
            this.inTailContext = false;
            LambdaExp child = exp.firstChild;
            while (child != null && this.exitValue == null) {
                this.walkLambdaExp(child, false);
                child = child.nextSibling;
            }
        }
        finally {
            this.inTailContext = save;
            this.currentLambda = parent;
        }
        return exp;
    }

    @Override
    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration ctx;
        Declaration decl = Declaration.followAliases(exp.binding);
        if (decl != null) {
            if (decl.type == Type.void_type) {
                return QuoteExp.voidExp;
            }
            decl.setCanRead(true);
        }
        if ((ctx = exp.contextDecl()) != null) {
            ctx.setCanRead(true);
        }
        return exp;
    }

    final Expression walkSetExp(Declaration decl, Expression value) {
        if (decl != null && decl.getValue() == value && value instanceof LambdaExp && !(value instanceof ClassExp) && !decl.isPublic()) {
            LambdaExp lexp = (LambdaExp)value;
            this.walkLambdaExp(lexp, false);
            return lexp;
        }
        return value.walk(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkSetExp(SetExp exp) {
        boolean save = this.inTailContext;
        try {
            Declaration ctx;
            this.inTailContext = false;
            Declaration decl = exp.binding;
            if (decl != null && decl.isAlias()) {
                if (exp.isDefining()) {
                    exp.new_value = exp.new_value.walk(this);
                    SetExp setExp = exp;
                    return setExp;
                }
                decl = Declaration.followAliases(decl);
            }
            if (decl != null) {
                decl.setCanWrite();
            }
            if ((ctx = exp.contextDecl()) != null) {
                ctx.setCanRead(true);
            }
            Expression value = this.walkSetExp(decl, exp.new_value);
            if (decl != null && decl.context instanceof LetExp && value == decl.getValue() && (value instanceof LambdaExp || value instanceof QuoteExp)) {
                QuoteExp quoteExp = QuoteExp.voidExp;
                return quoteExp;
            }
            exp.new_value = value;
            SetExp setExp = exp;
            return setExp;
        }
        finally {
            this.inTailContext = save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkTryExp(TryExp exp) {
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Expression expression = super.walkTryExp(exp);
            return expression;
        }
        finally {
            this.inTailContext = save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkSynchronizedExp(SynchronizedExp exp) {
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Expression expression = super.walkSynchronizedExp(exp);
            return expression;
        }
        finally {
            this.inTailContext = save;
        }
    }
}

