/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.kawa.functions.AddOp;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RealNum;

public class DivideOp
extends ProcedureN
implements CanInline {
    boolean asInteger;
    public static final DivideOp $Sl = new DivideOp("/");
    public static final DivideOp idiv = new DivideOp("idiv");
    static ClassType typeRatNum;

    public DivideOp(String name) {
        super(name);
    }

    @Override
    public Object applyN(Object[] args) {
        int i;
        Numeric result = args.length == 1 ? IntNum.one() : (Numeric)args[i++];
        for (i = 0; i < args.length; ++i) {
            result = result.div(args[i]);
        }
        if (this.asInteger) {
            result = ((RealNum)result).toExactInt(3);
        }
        return result;
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression folded = exp.inlineIfConstant((Procedure)this, walker);
        if (folded != exp) {
            return folded;
        }
        if (this.asInteger) {
            return exp;
        }
        Expression[] args = exp.getArgs();
        if (args.length > 2) {
            return AddOp.pairwise(this, exp.getFunction(), args, walker);
        }
        if (args.length == 2) {
            Expression opt;
            Type type0 = args[0].getType();
            Type type1 = args[1].getType();
            int kind0 = AddOp.classify(type0);
            int kind1 = AddOp.classify(type1);
            if ((kind0 == 4 || type0.isSubtype(typeRatNum)) && (kind1 == 4 || type1.isSubtype(typeRatNum))) {
                return new ApplyExp(typeRatNum.getDeclaredMethod("divide", 2), args);
            }
            if (kind0 >= 3 && kind1 >= 3 && (opt = AddOp.primInline(108, exp)) != exp) {
                return opt;
            }
            if (kind0 >= 2 && kind1 >= 2) {
                return new ApplyExp(AddOp.typeRealNum.getDeclaredMethod("divide", 2), args);
            }
        }
        return exp;
    }

    static {
        DivideOp.idiv.asInteger = true;
        typeRatNum = ClassType.make("gnu.math.RatNum");
    }
}

