/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.reflect.Invoke;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import java.io.IOException;

public class ReaderDispatchMisc
extends ReadTableEntry {
    protected int code;
    private static ReaderDispatchMisc instance = new ReaderDispatchMisc();

    public static ReaderDispatchMisc getInstance() {
        return instance;
    }

    public ReaderDispatchMisc() {
        this.code = -1;
    }

    public ReaderDispatchMisc(int code) {
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(Lexer in, int ch, int count) throws IOException, SyntaxException {
        LispReader reader = (LispReader)in;
        char saveReadState = '\u0000';
        if (this.code >= 0) {
            ch = this.code;
        }
        switch (ch) {
            case 58: {
                int startPos = reader.tokenBufferLength;
                reader.readToken(reader.read(), 'P', ReadTable.getCurrent());
                int length = reader.tokenBufferLength - startPos;
                String name = new String(reader.tokenBuffer, startPos, length);
                reader.tokenBufferLength = startPos;
                return Keyword.make(name.intern());
            }
            case 92: {
                return LispReader.readCharacter(reader);
            }
            case 33: {
                return LispReader.readSpecial(reader);
            }
            case 84: {
                return Boolean.TRUE;
            }
            case 70: {
                ch = in.peek();
                if (Character.isDigit((char)ch)) {
                    return LispReader.readSimpleVector(reader, 'F');
                }
                return Boolean.FALSE;
            }
            case 83: 
            case 85: {
                return LispReader.readSimpleVector(reader, (char)ch);
            }
            case 82: {
                if (count > 36) {
                    in.error("the radix " + count + " is too big (max is 36)");
                    count = 36;
                }
                return LispReader.readNumberWithRadix(0, reader, count);
            }
            case 88: {
                return LispReader.readNumberWithRadix(0, reader, 16);
            }
            case 68: {
                return LispReader.readNumberWithRadix(0, reader, 10);
            }
            case 79: {
                return LispReader.readNumberWithRadix(0, reader, 8);
            }
            case 66: {
                return LispReader.readNumberWithRadix(0, reader, 2);
            }
            case 69: 
            case 73: {
                reader.tokenBufferAppend(35);
                reader.tokenBufferAppend(ch);
                return LispReader.readNumberWithRadix(2, reader, 0);
            }
            case 124: {
                LineBufferedReader port = reader.getPort();
                if (port instanceof InPort) {
                    saveReadState = ((InPort)port).readState;
                    ((InPort)port).readState = (char)124;
                }
                try {
                    reader.readNestedComment('#', '|');
                }
                finally {
                    if (port instanceof InPort) {
                        ((InPort)port).readState = saveReadState;
                    }
                }
                return Values.empty;
            }
            case 44: {
                Object list;
                int length;
                LineBufferedReader port = reader.getPort();
                if (port.peek() == 40 && (length = LList.listLength(list = reader.readObject(), false)) > 0 && ((Pair)list).car instanceof String) {
                    String name = (String)((Pair)list).car;
                    Object proc = ReadTable.getCurrent().getReaderCtor(name);
                    if (proc == null) {
                        in.error("unknown reader constructor " + name);
                    } else if (!(proc instanceof Procedure) && !(proc instanceof Type)) {
                        in.error("reader constructor must be procedure or type name");
                    } else {
                        int parg = proc instanceof Type ? 1 : 0;
                        Object[] args = new Object[parg + --length];
                        Object argList = ((Pair)list).cdr;
                        for (int i = 0; i < length; ++i) {
                            Pair pair = (Pair)argList;
                            args[parg + i] = pair.car;
                            argList = pair.cdr;
                        }
                        try {
                            if (parg > 0) {
                                args[0] = proc;
                                return Invoke.make.applyN(args);
                            }
                            return ((Procedure)proc).applyN(args);
                        }
                        catch (Throwable ex) {
                            in.error("caught " + ex + " applying reader constructor " + name);
                        }
                    }
                } else {
                    in.error("a non-empty list starting with a symbol must follow #,");
                }
                return Boolean.FALSE;
            }
        }
        in.error("An invalid #-construct was read.");
        return Values.empty;
    }
}

