/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.rulebase.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.xml.RuleElement;
import jp.sourceforge.gnp.rulebase.xml.RuleFoundException;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlRulebaseUrl
extends XmlRulebase {
    private static final long serialVersionUID = 1L;
    private String url = "";
    protected ProrateRulebaseElementFactory elementFactory;

    public static synchronized void initialize(String ruleUrl) throws Exception {
        block28: {
            System.err.println("XmlRulebaseUrl.initialize()");
            if (XmlRulebaseUrl.getRulebaseList() != null) {
                System.err.println("XmlRulebaseUrl.initialize(): rulebaseList != null");
                return;
            }
            if (ruleUrl == null) {
                System.err.println("XmlRulebaseUrl.initialize(): rulebaseList == null");
                try {
                    ruleUrl = System.getProperty("GNP_RULE_URL");
                    System.err.println("XmlRulebaseUrl.initialize(null): GNP_RULE_URL, ruleUrl = " + ruleUrl);
                    if (ruleUrl == null) {
                        String propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
                        if (propertyFileName == null) {
                            System.err.println("user.home = " + System.getProperty("user.home"));
                            propertyFileName = System.getProperty("user.home");
                            System.err.println("file.separator = " + System.getProperty("file.separator"));
                            propertyFileName = propertyFileName + System.getProperty("file.separator");
                            propertyFileName = propertyFileName + ".prorate.properties";
                            String separator = System.getProperty("file.separator");
                            if (separator != null && separator.equals("\\")) {
                                String homeDir = System.getProperty("user.home");
                                System.err.println("user.home = " + homeDir);
                                System.err.println("file.separator = " + separator);
                                propertyFileName = homeDir + separator + "prorate.properties";
                                System.err.println("WIN: propertyFileName = " + propertyFileName);
                            }
                        }
                        FileInputStream propertyFile = null;
                        try {
                            propertyFile = new FileInputStream(propertyFileName);
                        }
                        catch (FileNotFoundException e) {
                            propertyFile = null;
                        }
                        System.err.println("propertyFileName = " + propertyFileName + ", propertyFile = " + propertyFile);
                        InputStream is = null;
                        if (propertyFile == null) {
                            ClassLoader loader = Prorate.class.getClassLoader();
                            is = loader.getResourceAsStream("jp/sourceforge/gnp/prorate.properties");
                        } else {
                            is = propertyFile;
                        }
                        Properties properties = new Properties();
                        try {
                            properties.load(is);
                        }
                        catch (IOException eProperty) {
                            System.err.println("IOException in XmlRulebaseUrl.initialize(null):" + eProperty.getMessage());
                            throw new ProrateRulebaseException("IOException in XmlRulebaseUrl.initialize(null) in reading jp/sourceforge/gnp/prorate.properties: " + eProperty.getMessage(), eProperty);
                        }
                        if (XmlRulebaseUrl.getAdditionalPropertiesInputStream() != null) {
                            try {
                                properties.load(XmlRulebaseUrl.getAdditionalPropertiesInputStream());
                            }
                            catch (IOException eAdditionalProperty) {
                                throw new ProrateRulebaseException("IOException in XmlRulebaseUrl.initialize(null) in reading additional property file: " + eAdditionalProperty.getMessage(), eAdditionalProperty);
                            }
                        }
                        ruleUrl = properties.getProperty("GNP_RULE_URL", "http://localhost/gnp/rulebase");
                    }
                    System.err.println("XmlRulebaseUrl.initialize(null): ruleUrl = " + ruleUrl);
                }
                catch (AccessControlException e) {
                    System.err.println("AccessControlException e = " + e.getMessage());
                    if (XmlRulebaseUrl.getRulebaseList() != null) break block28;
                    XmlRulebaseUrl.setRulebaseList(new Vector());
                }
            }
        }
        XmlRulebaseUrl.setRulebaseList(new Vector());
        if (XmlRulebaseUrl.getSkipInitializeList().contains(0)) {
            XmlRulebaseUrl.getRulebaseList().add(null);
        } else if (!XmlRulebaseUrl.ruleInstall("spa", ruleUrl, "spa", 0, ".xml", (short)257)) {
            throw new Exception("proration service SPA rulebase initialization failed");
        }
        if (XmlRulebaseUrl.getSkipInitializeList().contains(1)) {
            XmlRulebaseUrl.getRulebaseList().add(null);
        } else if (!XmlRulebaseUrl.ruleInstall("apdp", ruleUrl, "apdp", 1, ".xml", (short)258)) {
            throw new Exception("proration service APDP rulebase initialization failed");
        }
        if (XmlRulebaseUrl.getSkipInitializeList().contains(2)) {
            XmlRulebaseUrl.getRulebaseList().add(null);
        } else if (!XmlRulebaseUrl.ruleInstall("extf", ruleUrl, "extf", 2, ".xml", (short)263)) {
            throw new Exception("proration service EXTF rulebase initialization failed");
        }
        if (XmlRulebaseUrl.getSkipInitializeList().contains(3)) {
            XmlRulebaseUrl.getRulebaseList().add(null);
        } else if (!XmlRulebaseUrl.ruleInstall("part", ruleUrl, "part", 3, ".xml", (short)264)) {
            throw new Exception("proration service PART rulebase initialization failed");
        }
    }

    static boolean ruleInstall(String rule, String root, String dir, int index, String extent, short regist) throws ProrateRulebaseException {
        String dirName = root + "/" + dir;
        System.err.println("XmlRulebaseUrl.ruleInstall(" + rule + "," + root + "," + dir + "," + index + "," + extent + "," + regist + ")");
        HttpClient client = new HttpClient();
        String dirUrl = dirName + "/";
        GetMethod method = new GetMethod(dirUrl);
        String response = null;
        try {
            client.executeMethod(method);
            response = method.getResponseBodyAsString();
        }
        catch (HttpException e) {
            System.err.println("HttpException in parse() for " + dirUrl + ":" + e.getMessage());
            throw new ProrateRulebaseException(dirUrl + " : " + "HttpException in ruleInstall() :" + e.getMessage(), e);
        }
        catch (IOException e) {
            System.err.println("IOException in parse() for " + dirUrl + ":" + e.getMessage());
            throw new ProrateRulebaseException("IOException in ruleInstall() :" + e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
        }
        String[] lines = StringUtils.split(response, "\n");
        String patternStr = ".*<[Aa] [Hh][Rr][Ee][Ff]=\\\"(" + dir.toUpperCase() + "\\(.*\\).*\\.xml)\\\">" + dir.toUpperCase() + ".*</[Aa]>.*";
        Pattern pattern = Pattern.compile(patternStr);
        Vector<String> ruleFilesList = new Vector<String>();
        for (int i = 0; i < lines.length; ++i) {
            Matcher matcher = pattern.matcher(lines[i]);
            boolean match = false;
            match = matcher.find();
            if (!match) continue;
            String ruleFile = matcher.group(1);
            ruleFilesList.add(ruleFile);
        }
        Object[] ruleFiles = new String[ruleFilesList.size()];
        if (ruleFiles == null) {
            return false;
        }
        for (int i = 0; i < ruleFilesList.size(); ++i) {
            ruleFiles[i] = (String)ruleFilesList.get(i);
        }
        Arrays.sort(ruleFiles);
        Vector<RuleElement> rules = new Vector<RuleElement>();
        for (int i = 0; i < ruleFiles.length; ++i) {
            if (!((String)ruleFiles[i]).matches("[a-zA-Z0-9(),]*.xml")) continue;
            String fileUrl = dirName + "/" + (String)ruleFiles[i];
            String name = null;
            String type = null;
            String carrier = null;
            String tkCarrier = null;
            String validStart = null;
            String validEnd = null;
            Date dateFrom = null;
            Date dateUntil = null;
            final String ruleName = rule;
            method = new GetMethod(fileUrl);
            try {
                client.executeMethod(method);
                String ruleResponse = method.getResponseBodyAsString();
                StringReader reader = new StringReader(ruleResponse);
                String venderParserClass = "org.apache.xerces.parsers.SAXParser";
                XMLReader xmlReader = XMLReaderFactory.createXMLReader(venderParserClass);
                ContentHandler handler = new ContentHandler(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                        if (localName.equals(ruleName)) {
                            RuleFoundException e = new RuleFoundException();
                            for (int i = 0; i < atts.getLength(); ++i) {
                                if (atts.getLocalName(i).equals("name")) {
                                    e.name = atts.getValue(i);
                                } else if (atts.getLocalName(i).equals("type")) {
                                    e.type = atts.getValue(i);
                                } else if (atts.getLocalName(i).equals("carrier")) {
                                    e.carrier = atts.getValue(i);
                                } else if (atts.getLocalName(i).equals("tkCarrier")) {
                                    e.tkCarrier = atts.getValue(i);
                                } else if (atts.getLocalName(i).equals("validStart")) {
                                    e.validStart = atts.getValue(i);
                                } else if (atts.getLocalName(i).equals("validEnd")) {
                                    e.validEnd = atts.getValue(i);
                                }
                                e.extfArgs = null;
                            }
                            if (!localName.equals("extf")) throw e;
                            XmlRulebase.ruleFoundException = e;
                            return;
                        } else if (localName.equals("extf-args")) {
                            XmlRulebase.extfArgs = new Vector();
                            return;
                        } else {
                            if (!localName.equals("extf-arg")) return;
                            for (int i = 0; i < atts.getLength(); ++i) {
                                if (!atts.getLocalName(i).equals("name")) continue;
                                String name = atts.getValue(i);
                                XmlRulebase.extfArgs.add(name);
                            }
                        }
                    }

                    @Override
                    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                        if (localName.equals("extf-args")) {
                            XmlRulebase.ruleFoundException.extfArgs = XmlRulebase.extfArgs;
                            throw XmlRulebase.ruleFoundException;
                        }
                    }

                    @Override
                    public void startDocument() throws SAXException {
                    }

                    @Override
                    public void endDocument() throws SAXException {
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                    }

                    @Override
                    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    }

                    @Override
                    public void endPrefixMapping(String prefix) throws SAXException {
                    }

                    @Override
                    public void skippedEntity(String name) throws SAXException {
                    }

                    @Override
                    public void setDocumentLocator(Locator locator) {
                    }

                    @Override
                    public void processingInstruction(String target, String data) throws SAXException {
                    }

                    @Override
                    public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    }
                };
                xmlReader.setContentHandler(handler);
                InputSource inputSource = new InputSource(reader);
                xmlReader.parse(inputSource);
            }
            catch (RuleFoundException e) {
                name = e.name;
                type = e.type;
                carrier = e.carrier;
                tkCarrier = e.tkCarrier;
                validStart = e.validStart;
                validEnd = e.validEnd;
                extfArgs = e.extfArgs;
            }
            catch (SAXException e) {
                System.err.println("SAXException in parse() for " + fileUrl + ":" + e.getMessage());
                throw new ProrateRulebaseException("SAXException in ruleInstall() :" + e.getMessage(), e);
            }
            catch (HttpException e) {
                System.err.println("HttpException in parse() for " + fileUrl + ":" + e.getMessage());
                throw new ProrateRulebaseException(fileUrl + " : " + "HttpException in ruleInstall() :" + e.getMessage(), e);
            }
            catch (IOException e) {
                System.err.println("IOException in parse() for " + fileUrl + ":" + e.getMessage());
                throw new ProrateRulebaseException("IOException in ruleInstall() :" + e.getMessage(), e);
            }
            finally {
                method.releaseConnection();
            }
            if (validStart != null && !validStart.equals("")) {
                try {
                    dateFrom = dtFormat.parse(validStart);
                }
                catch (ParseException e) {
                    throw new ProrateRulebaseException(dateFrom + " : " + "ParseException in ruleInstall() :" + e.getMessage(), e);
                }
            }
            if (validEnd != null && !validEnd.equals("")) {
                try {
                    dateUntil = dtFormat.parse(validEnd);
                }
                catch (ParseException e) {
                    throw new ProrateRulebaseException(dateUntil + " : " + "ParseException in ruleInstall() :" + e.getMessage(), e);
                }
            }
            RuleElement ruleElem = new RuleElement(rule, name, type, carrier, tkCarrier, dateFrom, dateUntil, fileUrl, extfArgs);
            System.err.println("XmlRulebaseUrl.ruleInstall(): new RuleElement(" + rule + "," + name + "," + type + "," + carrier + "," + tkCarrier + "," + dateFrom + "," + dateUntil + "," + fileUrl + ")");
            rules.add(ruleElem);
        }
        Object[] rulebase = rules.toArray();
        XmlRulebaseUrl.getRulebaseList().add(rulebase);
        return true;
    }

    public static List getAllExtfs(String type) {
        Vector list = new Vector();
        if (XmlRulebaseUrl.getRulebaseList().size() <= 2) {
            return list;
        }
        Object[] rulebase = (Object[])XmlRulebaseUrl.getRulebaseList().get(2);
        for (int i = 0; i < rulebase.length; ++i) {
            if (!((RuleElement)rulebase[i]).type.equals(type)) continue;
            Vector<String> extfInfo = new Vector<String>();
            extfInfo.add(((RuleElement)rulebase[i]).name);
            List args = ((RuleElement)rulebase[i]).args;
            if (args != null) {
                for (int j = 0; j < args.size(); ++j) {
                    extfInfo.add((String)args.get(j));
                }
            }
            list.add(extfInfo);
        }
        return list;
    }

    public static List getAllActionExtfs() {
        return XmlRulebaseUrl.getAllExtfs("action");
    }

    public static List getAllJudgeExtfs() {
        return XmlRulebaseUrl.getAllExtfs("judge");
    }

    public static List getAllValueExtfs() {
        return XmlRulebaseUrl.getAllExtfs("value");
    }

    public static List getAllParts() {
        Vector<String> list = new Vector<String>();
        if (XmlRulebaseUrl.getRulebaseList().size() <= 3) {
            return list;
        }
        Object[] rulebase = (Object[])XmlRulebaseUrl.getRulebaseList().get(3);
        for (int i = 0; i < rulebase.length; ++i) {
            list.add(((RuleElement)rulebase[i]).name);
        }
        return list;
    }

    public XmlRulebaseUrl() {
    }

    public XmlRulebaseUrl(String in_url) {
        this.setUrl(in_url);
    }

    @Override
    public boolean selectSPA(String carrier, String tkCarrier, String dateIssue) throws ProrateRulebaseException {
        if (dateIssue == null || dateIssue.equals("")) {
            return false;
        }
        Object[] rulebase = (Object[])XmlRulebaseUrl.getRulebaseList().get(0);
        int index = Arrays.binarySearch(rulebase, new RuleElement("spa", "", "", carrier, tkCarrier, null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleElement)o1).compareTo((RuleElement)o2);
            }
        });
        if (index < 0) {
            return false;
        }
        int i = index;
        while (i > 0 && ((RuleElement)rulebase[i]).match("spa", "", carrier, tkCarrier)) {
            index = i--;
        }
        Date date = null;
        try {
            date = dtFormat.parse(dateIssue);
        }
        catch (ParseException e) {
            throw new ProrateRulebaseException(dateIssue + " : " + "ParseException in selectSPA() :" + e.getMessage(), e);
        }
        for (int i2 = index; i2 < rulebase.length; ++i2) {
            if (!((RuleElement)rulebase[i2]).match("spa", "", carrier, tkCarrier)) {
                return false;
            }
            if (!((RuleElement)rulebase[i2]).match("spa", "", carrier, tkCarrier, date)) continue;
            this.setUrl(((RuleElement)rulebase[i2]).filename);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectAPDP(String carrier, String dateIssue) throws ProrateRulebaseException {
        if (dateIssue == null || dateIssue.equals("")) {
            return false;
        }
        Object[] rulebase = (Object[])XmlRulebaseUrl.getRulebaseList().get(1);
        int index = Arrays.binarySearch(rulebase, new RuleElement("apdp", "", "", carrier, "", null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleElement)o1).compareTo((RuleElement)o2);
            }
        });
        if (index < 0) {
            return false;
        }
        int i = index;
        while (i > 0 && ((RuleElement)rulebase[i]).match("apdp", "", carrier, "")) {
            index = i--;
        }
        Date date = null;
        try {
            date = dtFormat.parse(dateIssue);
        }
        catch (ParseException e) {
            throw new ProrateRulebaseException(dateIssue + " : " + "ParseException in selectAPDP() :" + e.getMessage(), e);
        }
        for (int i2 = index; i2 < rulebase.length; ++i2) {
            if (!((RuleElement)rulebase[i2]).match("apdp", "", carrier, "")) {
                return false;
            }
            if (!((RuleElement)rulebase[i2]).match("apdp", "", carrier, "", date)) continue;
            this.setUrl(((RuleElement)rulebase[i2]).filename);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectEXTF(String extfName) throws ProrateRulebaseException {
        Object[] rulebase = (Object[])XmlRulebaseUrl.getRulebaseList().get(2);
        int index = Arrays.binarySearch(rulebase, new RuleElement("extf", extfName, "", "", "", null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleElement)o1).compareTo((RuleElement)o2);
            }
        });
        if (index < 0) {
            return false;
        }
        int i = index;
        while (i > 0 && ((RuleElement)rulebase[i]).match("extf", extfName, "", "")) {
            index = i--;
        }
        if (!((RuleElement)rulebase[index]).match("extf", extfName, "", "")) {
            throw new ProrateRulebaseException(extfName + " : " + "EXTF not found", null);
        }
        this.setUrl(((RuleElement)rulebase[index]).filename);
        return true;
    }

    @Override
    public boolean selectPART(String name) throws ProrateRulebaseException {
        Object[] rulebase = (Object[])XmlRulebaseUrl.getRulebaseList().get(3);
        int index = Arrays.binarySearch(rulebase, new RuleElement("part", name, "", "", "", null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleElement)o1).compareTo((RuleElement)o2);
            }
        });
        if (index < 0) {
            return false;
        }
        int i = index;
        while (i > 0 && ((RuleElement)rulebase[i]).match("part", name, "", "")) {
            index = i--;
        }
        if (!((RuleElement)rulebase[index]).match("part", name, "", "")) {
            throw new ProrateRulebaseException(name + " : " + "PART not found", null);
        }
        this.setUrl(((RuleElement)rulebase[index]).filename);
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public List read() throws ProrateRulebaseException {
        List rules = null;
        try {
            rules = this.read(false);
        }
        catch (Exception e) {
            throw new ProrateRulebaseException("rulebase read error", e);
        }
        return rules;
    }

    @Override
    List read(boolean skipToActions) throws ProrateRulebaseException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(this.getUrl());
        try {
            client.executeMethod(method);
            String response = method.getResponseBodyAsString();
            StringReader reader = new StringReader(response);
            return this.read(reader, skipToActions);
        }
        catch (IOException e) {
            throw new ProrateRulebaseException("IOException in read() :" + e.getMessage(), e);
        }
    }

    @Override
    public List read(Reader reader) throws ProrateRulebaseException {
        return this.read(reader, false);
    }

    @Override
    List read(Reader reader, boolean skipToActions) throws ProrateRulebaseException {
        List ret = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(reader);
            ret = this.loadFromElement(doc.getRootElement(), skipToActions);
            if (ret == null || ret.size() == 0) {
                return ret;
            }
            ret = (List)ret.get(0);
        }
        catch (IOException e) {
            throw new ProrateRulebaseException("IOException in read(" + reader.toString() + ") :" + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new ProrateRulebaseException("JDOMException in read(" + reader.toString() + ") :" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ProrateRulebaseException("Exception in read(" + reader.toString() + ") :" + e.getMessage(), e);
        }
        return ret;
    }

    @Override
    public List read(boolean isSPA, String carrier, String tkCarrier, String issueDate, boolean skipToActions) throws ProrateRulebaseException {
        List<ProrateRulebaseElement> rules = new Vector();
        if (isSPA) {
            if (!this.selectSPA(carrier, tkCarrier, issueDate)) {
                String str = "Apply_SPA(";
                str = str + carrier;
                str = str + ",";
                str = str + tkCarrier;
                str = str + ",";
                str = str + issueDate;
                str = str + ")";
                str = str + ": undefined SPA rule";
                ProrateRulebaseElement pobj = this.elementFactory.makeErrorObject(8, str, "");
                rules.add(pobj);
                return rules;
            }
        } else if (!this.selectAPDP(carrier, issueDate)) {
            String str = "Apply_APDP(";
            str = str + carrier;
            str = str + ",";
            str = str + issueDate;
            str = str + ")";
            str = str + ": undefined APDP rule";
            ProrateRulebaseElement pobj = this.elementFactory.makeErrorObject(8, str, "");
            rules.add(pobj);
            return rules;
        }
        rules = this.read(skipToActions);
        return rules;
    }

    @Override
    List loadFromElement(Element element, boolean skipToActions) throws ProrateRulebaseException {
        Vector<List> children = new Vector<List>();
        for (Element childElement : element.getChildren()) {
            String childName;
            String name = element.getName();
            List child = null;
            if (name.equals("rule")) {
                child = this.loadFromElement(childElement, skipToActions);
                children.add(child);
                List ret = this.createElement(element, children);
                return ret;
            }
            if ((name.equals("spa") || name.equals("apdp") || name.equals("part") || name.equals("extf")) && skipToActions && !(childName = childElement.getName()).equals("actions")) continue;
            child = this.loadFromElement(childElement, false);
            children.add(child);
        }
        List ret = this.createElement(element, children);
        return ret;
    }

    @Override
    List createElement(Element element, List children) throws ProrateRulebaseException {
        String name = element.getName();
        if (name.equals("rule")) {
            return children;
        }
        if (name.equals("spa") || name.equals("apdp") || name.equals("extf") || name.equals("part")) {
            return this.createNop(name, element, children);
        }
        if (name.equals("common") || name.equals("actions")) {
            return this.createNop(name, element, children);
        }
        if (name.equals("extf-args")) {
            Vector childrenList = new Vector();
            for (int i = 0; i < children.size(); ++i) {
                List child = (List)children.get(i);
                Object obj = child.get(0);
                childrenList.add(obj);
            }
            return childrenList;
        }
        if (name.equals("extf-arg")) {
            List varsList = this.createVar(element, children);
            Vector<List> childrenList = new Vector<List>();
            childrenList.add(varsList);
            element.setAttribute("name", "Set");
            return this.createFunc(element, childrenList);
        }
        if (name.equals("if")) {
            return this.createIf(element, children);
        }
        if (name.equals("then")) {
            return children;
        }
        if (name.equals("else")) {
            return children;
        }
        if (name.equals("switch")) {
            return this.createSwitch(element, children);
        }
        if (name.equals("case-vars")) {
            return children;
        }
        if (name.equals("branch")) {
            return this.createBranch(element, children);
        }
        if (name.equals("branch-condition")) {
            return children;
        }
        if (name.equals("case")) {
            return this.createCase(element, children);
        }
        if (name.equals("table")) {
            return this.createTable(element, children);
        }
        if (name.equals("table-vars")) {
            return children;
        }
        if (name.equals("table-conditions")) {
            return children;
        }
        if (name.equals("rows")) {
            return children;
        }
        if (name.equals("cols")) {
            return children;
        }
        if (name.equals("amount-table")) {
            return children;
        }
        if (name.equals("action-statement")) {
            return this.createStatement(element, children);
        }
        if (name.equals("judge-statement")) {
            return this.createStatement(element, children);
        }
        if (name.equals("set")) {
            return this.createFunc(element, children);
        }
        if (name.equals("end")) {
            return this.createEnd(element, children);
        }
        if (name.equals("return")) {
            return this.createReturn(element, children);
        }
        if (name.equals("partcall")) {
            return this.createPartcall(element, children);
        }
        if (name.equals("percent")) {
            return this.createPercent(element, children);
        }
        if (name.equals("amount")) {
            return this.createAmount(element, children);
        }
        if (name.equals("funcall")) {
            return this.createFunc(element, children);
        }
        if (name.equals("and")) {
            return this.createAnd(element, children);
        }
        if (name.equals("or")) {
            return this.createOr(element, children);
        }
        if (name.equals("judge")) {
            return this.createJudge(element, children);
        }
        if (name.equals("multival")) {
            return this.createMultival(element, children);
        }
        if (name.equals("interval")) {
            return this.createInterval(element, children);
        }
        if (name.equals("variable")) {
            return this.createVar(element, children);
        }
        if (name.equals("true")) {
            return this.createTrue(element, children);
        }
        if (name.equals("false")) {
            return this.createFalse(element, children);
        }
        if (name.equals("number")) {
            return this.createNumber(element, children);
        }
        if (name.equals("date")) {
            return this.createDate(element, children);
        }
        if (name.equals("string")) {
            return this.createString(element, children);
        }
        if (name.equals("path")) {
            return this.createPath(element, children);
        }
        return null;
    }

    @Override
    List createNop(String name, Element element, List children) {
        ProrateRulebaseElement ret = null;
        if (name.equals("spa")) {
            ret = this.elementFactory.makeNopObject((short)257, element.getAttributeValue("carrier"), element.getAttributeValue("tkCarrier"), element.getAttributeValue("validStart"), element.getAttributeValue("validEnd"), "", element.getAttributeValue("comment"));
        } else if (name.equals("apdp")) {
            ret = this.elementFactory.makeNopObject((short)258, element.getAttributeValue("carrier"), "", element.getAttributeValue("validStart"), element.getAttributeValue("validEnd"), "", element.getAttributeValue("comment"));
        } else if (name.equals("extf")) {
            ret = this.elementFactory.makeNopObject((short)263, element.getAttributeValue("name"), "", "", "", element.getAttributeValue("type"), element.getAttributeValue("comment"));
        } else if (name.equals("part")) {
            ret = this.elementFactory.makeNopObject((short)264, element.getAttributeValue("name"), "", "", "", "", element.getAttributeValue("comment"));
        } else if (name.equals("common")) {
            ret = this.elementFactory.makeNopObject((short)260, "", "", "", "", "", "");
        } else if (name.equals("actions")) {
            ret = this.elementFactory.makeNopObject((short)261, "", "", "", "", "", "");
        }
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        if (ret != null) {
            retList.add(ret);
        }
        for (List list : children) {
            for (Object pobj : list) {
                retList.add((ProrateRulebaseElement)pobj);
            }
        }
        return retList;
    }

    @Override
    List createEnd(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeEndObject(comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createIf(Element element, List children) {
        List tests = (List)children.get(0);
        Vector thens = new Vector();
        List thensPre = (List)children.get(1);
        Iterator i = thensPre.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            thens.add(pobj);
        }
        Vector elses = new Vector();
        List elsesPre = (List)children.get(2);
        Iterator i2 = elsesPre.iterator();
        while (i2.hasNext()) {
            Object pobj = ((List)i2.next()).get(0);
            elses.add(pobj);
        }
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeTestObject(tests, thens, elses, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createAnd(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector args = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            args.add(pobj);
        }
        ProrateRulebaseElement ret = this.elementFactory.makeAndObject(args, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createOr(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector args = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            args.add(pobj);
        }
        ProrateRulebaseElement ret = this.elementFactory.makeOrObject(args, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createJudge(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector args = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            args.add(pobj);
        }
        ProrateRulebaseElement ret = this.elementFactory.makeJudgeObject(args, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createSwitch(Element element, List children) {
        Vector args = new Vector();
        List argsPre = (List)children.get(0);
        Iterator i = argsPre.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            args.add(pobj);
        }
        String comment = element.getAttributeValue("comment");
        Vector branchacts = new Vector();
        boolean first = true;
        for (List list : children) {
            if (list != null && list.size() >= 1) {
                Object pobj = list.get(0);
                if (!first) {
                    branchacts.add(pobj);
                }
            }
            first = false;
        }
        ProrateRulebaseElement ret = this.elementFactory.makeSwitchObject(args, branchacts, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createBranch(Element element, List children) {
        Vector branches = new Vector();
        List branchesPre = (List)children.get(0);
        Iterator i = branchesPre.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            branches.add(pobj);
        }
        String comment = element.getAttributeValue("comment");
        Vector actions = new Vector();
        boolean first = true;
        Iterator i2 = children.iterator();
        while (i2.hasNext()) {
            Object pobj = ((List)i2.next()).get(0);
            if (!first) {
                actions.add(pobj);
            }
            first = false;
        }
        ProrateRulebaseElement ret = this.elementFactory.makeBranchObject(branches, actions, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createCase(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector values = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            values.add(pobj);
        }
        ProrateRulebaseElement ret = this.elementFactory.makeCaseObject(values, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createTrue(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeBoolObject(true, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createFalse(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeBoolObject(false, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createReturn(Element element, List children) {
        ProrateRulebaseElement value = (ProrateRulebaseElement)((List)children.get(0)).get(0);
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeReturnObject(value, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createPartcall(Element element, List children) throws ProrateRulebaseException {
        String name = element.getAttributeValue("name");
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makePartcallObject(name, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createMultival(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector values = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            values.add(pobj);
        }
        ProrateRulebaseElement ret = this.elementFactory.makeMultivalObject(values, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createInterval(Element element, List children) {
        ProrateRulebaseElement lowvalue = (ProrateRulebaseElement)((List)children.get(0)).get(0);
        ProrateRulebaseElement highvalue = (ProrateRulebaseElement)((List)children.get(1)).get(0);
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeIntervalObject(lowvalue, highvalue, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createAmount(Element element, List children) {
        String currency = element.getAttributeValue("currency");
        String valueStr = element.getAttributeValue("value");
        double value = Double.parseDouble(valueStr);
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makeAmountObject(currency, value, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createPercent(Element element, List children) {
        ProrateRulebaseElement amount = (ProrateRulebaseElement)((List)children.get(0)).get(0);
        String percentStr = element.getAttributeValue("number");
        double percent = Double.parseDouble(percentStr);
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = this.elementFactory.makePercentObject(percent, amount, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createVar(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        String name = element.getAttributeValue("name");
        int regist = 0;
        regist = name.equals("$ENDORSE") ? 1025 : (name.equals("$RESTRICT") ? 1026 : (name.equals("$ORIGIN") ? 1027 : (name.equals("$DEST") ? 1028 : (name.equals("$ISSUE-DATE") ? 1029 : (name.equals("$ISSUE-BY") ? 1030 : (name.equals("$ISSUE-PLACE") ? 1031 : (name.equals("$MULTI-PATH") ? 1032 : (name.equals("$FC-FROM") ? 1033 : (name.equals("$FC-TO") ? 1034 : (name.equals("$FC-PATH") ? 1035 : (name.equals("$ISSUE-COUNTRY") ? 1036 : (name.equals("$ISSUE-AREA") ? 1037 : (name.equals("$ISSUE-AGENT") ? 1038 : (name.equals("$TOURCODE") ? 1039 : (name.equals("$FROM") ? 1153 : (name.equals("$TO") ? 1154 : (name.equals("$F-BASIS") ? 1155 : (name.equals("$TKDESIGN") ? 1156 : (name.equals("$F-BASIS-ALL") ? 1157 : (name.equals("$CARRIER") ? 1158 : (name.equals("$FLIGHT") ? 1159 : (name.equals("$CLASS") ? 1160 : (name.equals("$DATE") ? 1161 : (name.equals("$PATH") ? 1162 : (name.equals("$ROUTE") ? 1163 : (name.equals("$FROM-A") ? 1217 : (name.equals("$TO-A") ? 1218 : (name.equals("$F-BASIS-A") ? 1219 : (name.equals("$TKDESIGN-A") ? 1220 : (name.equals("$F-BASIS-ALL-A") ? 1221 : (name.equals("$CARRIER-A") ? 1222 : (name.equals("$FLIGHT-A") ? 1223 : (name.equals("$CLASS-A") ? 1224 : (name.equals("$DATE-A") ? 1225 : (name.equals("$PATH-A") ? 1226 : (name.equals("$ROUTE-A") ? 1227 : (name.equals("$DISCOUNT") ? 1281 : 1536)))))))))))))))))))))))))))))))))))));
        ProrateRulebaseElement ret = null;
        ret = regist == 1536 ? this.elementFactory.makeVarAutoObject((short)regist, name, comment) : this.elementFactory.makeVarObject((short)regist, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createFunc(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        String name = element.getAttributeValue("name");
        int regist = 0;
        if (name.equals("Set")) {
            regist = 291;
        } else if (name.equals("=")) {
            regist = 305;
        } else if (name.equals("!=")) {
            regist = 306;
        } else if (name.equals(">=")) {
            regist = 307;
        } else if (name.equals("Pfm")) {
            regist = 2049;
        } else if (name.equals("Pfm_max")) {
            regist = 2050;
        } else if (name.equals("Srp")) {
            regist = 2051;
        } else if (name.equals("Np")) {
            regist = 2052;
        } else if (name.equals("Apply_discount")) {
            regist = 2053;
        } else if (name.equals("Country")) {
            regist = 2054;
        } else if (name.equals("Area")) {
            regist = 2055;
        } else if (name.equals("Route")) {
            regist = 2056;
        } else if (name.equals("Via")) {
            regist = 2057;
        } else if (name.equals("Via_country")) {
            regist = 2058;
        } else if (name.equals("Gateway")) {
            regist = 2059;
        } else if (name.equals("Gateway_country")) {
            regist = 2060;
        } else if (name.equals("RoundTheWorld_p")) {
            regist = 2061;
        } else if (name.equals("Mileage_p")) {
            regist = 2062;
        } else if (name.equals("Route_p")) {
            regist = 2063;
        } else if (name.equals("Sidetrip_p")) {
            regist = 2064;
        } else if (name.equals("No_amount_p")) {
            regist = 2065;
        } else if (name.equals("Special_fare_p")) {
            regist = 2066;
        } else if (name.equals("Promotional_fare_p")) {
            regist = 2067;
        } else if (name.equals("Normal_fare_p")) {
            regist = 2068;
        } else if (name.equals("Tax_divid")) {
            regist = 2069;
        } else if (name.equals("Via_area")) {
            regist = 2070;
        } else if (name.equals("Discount")) {
            regist = 2071;
        } else if (name.equals("Bi_proviso")) {
            regist = 2072;
        } else if (name.equals("Multipath_amt")) {
            regist = 2073;
        } else if (name.equals("Uncertain")) {
            regist = 2074;
        } else if (name.equals("Number_p")) {
            regist = 2075;
        } else if (name.equals("Date_p")) {
            regist = 2076;
        } else if (name.equals("String_p")) {
            regist = 2077;
        } else if (name.equals("Amount_p")) {
            regist = 2078;
        } else if (name.equals("Path_p")) {
            regist = 2079;
        } else if (name.equals("Error")) {
            regist = 2080;
        } else if (name.equals("Within")) {
            regist = 2081;
        } else if (name.equals("Within_country")) {
            regist = 2082;
        } else if (name.equals("Within_area")) {
            regist = 2083;
        } else if (name.equals("Intl_sector_p")) {
            regist = 2084;
        } else if (name.equals("Between")) {
            regist = 2085;
        } else if (name.equals("Between_country")) {
            regist = 2086;
        } else if (name.equals("Between_area")) {
            regist = 2087;
        } else if (name.equals("Between_PC")) {
            regist = 2088;
        } else if (name.equals("Between_PA")) {
            regist = 2089;
        } else if (name.equals("Between_CA")) {
            regist = 2090;
        } else if (name.equals("Exclusive")) {
            regist = 2091;
        } else if (name.equals("Another")) {
            regist = 2092;
        } else if (name.equals("High_spa")) {
            regist = 2093;
        } else if (name.equals("Low_spa")) {
            regist = 2094;
        } else if (name.equals("High_spa_fix")) {
            regist = 2095;
        } else if (name.equals("Low_spa_fix")) {
            regist = 2096;
        } else if (name.equals("Net")) {
            regist = 2097;
        } else if (name.equals("Srp_fix")) {
            regist = 2098;
        } else if (name.equals("Sia")) {
            regist = 2099;
        } else {
            if (name.equals("Apply_spa")) {
                return this.createApply(true, element, children);
            }
            if (name.equals("Apply_apdp")) {
                return this.createApply(false, element, children);
            }
            regist = 2559;
        }
        Vector args = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            args.add(pobj);
        }
        ProrateRulebaseElement ret = null;
        if (regist == 2559) {
            Element parent = element.getParentElement();
            String parentName = parent.getName();
            ret = this.elementFactory.makeExternObject(name, parentName, args, comment);
        } else {
            ret = this.elementFactory.makeFuncObject((short)regist, args, comment);
        }
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createApply(boolean isSPA, Element element, List children) {
        String comment = element.getAttributeValue("comment");
        String carrier = element.getAttributeValue("carrier");
        String tkCarrier = element.getAttributeValue("tkCarrier");
        ProrateRulebaseElement ret = this.elementFactory.makeApplyObject(isSPA, carrier, tkCarrier, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createNumber(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        String valueStr = element.getAttributeValue("value");
        double value = Double.parseDouble(valueStr);
        ProrateRulebaseElement ret = this.elementFactory.makeNumberObject(value, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createDate(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        String monthStr = element.getAttributeValue("month");
        short month = (short)Integer.parseInt(monthStr);
        String dayStr = element.getAttributeValue("day");
        short day = (short)Integer.parseInt(dayStr);
        ProrateRulebaseElement ret = this.elementFactory.makeDateObject(month, day, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createString(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        String value = element.getAttributeValue("value");
        ProrateRulebaseElement ret = this.elementFactory.makeStringObject(value, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createPath(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector value = new Vector();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            value.add(pobj);
        }
        ProrateRulebaseElement ret = this.elementFactory.makePathObject(value, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createTable(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        Vector vars = new Vector();
        List varsPre = (List)children.get(0);
        Iterator i = varsPre.iterator();
        while (i.hasNext()) {
            Object pobj = ((List)i.next()).get(0);
            vars.add(pobj);
        }
        Vector conds = new Vector();
        List condsPre = (List)children.get(1);
        for (List list : condsPre) {
            if (list == null || list.size() < 1) continue;
            Vector objList = new Vector();
            for (int j = 0; j < list.size(); ++j) {
                Object pobj = ((List)list.get(j)).get(0);
                objList.add(pobj);
            }
            conds.add(objList);
        }
        Vector tbls = new Vector();
        List tblsPre = (List)children.get(2);
        Iterator i2 = tblsPre.iterator();
        while (i2.hasNext()) {
            Object pobj = ((List)i2.next()).get(0);
            tbls.add(pobj);
        }
        ProrateRulebaseElement prows = null;
        ProrateRulebaseElement pcols = null;
        Vector rows = null;
        Vector cols = null;
        if (vars.size() > 1) {
            prows = (ProrateRulebaseElement)vars.get(0);
            pcols = (ProrateRulebaseElement)vars.get(1);
        } else if (vars.size() == 1) {
            pcols = (ProrateRulebaseElement)vars.get(0);
        }
        if (conds.size() > 1) {
            rows = new Vector();
            cols = new Vector();
            List rowsPre = (List)conds.get(0);
            for (Object pobj : rowsPre) {
                rows.add(pobj);
            }
            List colsPre = (List)conds.get(1);
            for (Object pobj : colsPre) {
                cols.add(pobj);
            }
        } else if (conds.size() == 1) {
            cols = new Vector();
            List colsPre = (List)conds.get(0);
            for (Object pobj : colsPre) {
                cols.add(pobj);
            }
        }
        ProrateRulebaseElement ret = this.elementFactory.makeTableObject(prows, pcols, rows, cols, tbls, comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    @Override
    List createStatement(Element element, List children) {
        String comment = element.getAttributeValue("comment");
        ProrateRulebaseElement ret = (ProrateRulebaseElement)((List)children.get(0)).get(0);
        ret.setComment(comment);
        Vector<ProrateRulebaseElement> retList = new Vector<ProrateRulebaseElement>();
        retList.add(ret);
        return retList;
    }

    public void setUrl(String theUrl) {
        this.url = theUrl;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setElementFactory(ProrateRulebaseElementFactory theFactory) {
        this.elementFactory = theFactory;
    }

    @Override
    public ProrateRulebaseElementFactory getElementFactory() {
        return this.elementFactory;
    }
}

