/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.rulebase.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prubae.Prubae;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelAndOr;
import jp.sourceforge.gnp.prubae.PrubaeModelCase;
import jp.sourceforge.gnp.prubae.PrubaeModelDoStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelFunction;
import jp.sourceforge.gnp.prubae.PrubaeModelIf;
import jp.sourceforge.gnp.prubae.PrubaeModelJudge;
import jp.sourceforge.gnp.prubae.PrubaeModelJudgeStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelSwitch;
import jp.sourceforge.gnp.prubae.PrubaeModelTable;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriterElement;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XmlRulebaseWriter
implements ProrateRulebaseWriter {
    private OutputStream stream = null;
    private Element current = null;
    private InputStream additionalPropertiesInputStream = null;

    public XmlRulebaseWriter() {
    }

    public XmlRulebaseWriter(OutputStream stream) {
        this.setStream(stream);
    }

    @Override
    public void write(ProrateRulebaseWriterElement model) throws ProrateRulebaseException {
        String propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
        if (propertyFileName == null) {
            System.err.println("user.home = " + System.getProperty("user.home"));
            propertyFileName = System.getProperty("user.home");
            System.err.println("file.separator = " + System.getProperty("file.separator"));
            propertyFileName = propertyFileName + System.getProperty("file.separator");
            propertyFileName = propertyFileName + ".prorate.properties";
            String separator = System.getProperty("file.separator");
            if (separator != null && separator.equals("\\")) {
                String homeDir = System.getProperty("user.home");
                System.err.println("user.home = " + homeDir);
                System.err.println("file.separator = " + separator);
                propertyFileName = homeDir + separator + "prorate.properties";
                System.err.println("WIN: propertyFileName = " + propertyFileName);
            }
        }
        FileInputStream propertyFile = null;
        try {
            propertyFile = new FileInputStream(propertyFileName);
        }
        catch (FileNotFoundException e) {
            propertyFile = null;
        }
        System.err.println("propertyFileName = " + propertyFileName + ", propertyFile = " + propertyFile);
        InputStream is = null;
        if (propertyFile == null) {
            ClassLoader loader = Prorate.class.getClassLoader();
            is = loader.getResourceAsStream("jp/sourceforge/gnp/prorate.properties");
        } else {
            is = propertyFile;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException eProrateProperty) {
            throw new ProrateRulebaseException("IOException in write() in reading jp/sourceforge/gnp/prorate.properties: " + eProrateProperty.getMessage(), eProrateProperty);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        if (propertyFileName == null) {
            System.err.println("user.home = " + System.getProperty("user.home"));
            propertyFileName = System.getProperty("user.home");
            propertyFileName = propertyFileName + System.getProperty("file.separator");
            propertyFileName = propertyFileName + ".prubae.properties";
        }
        try {
            propertyFile = new FileInputStream(propertyFileName);
        }
        catch (FileNotFoundException e) {
            propertyFile = null;
        }
        System.err.println("propertyFileName = " + propertyFileName + ", propertyFile = " + propertyFile);
        if (propertyFile == null) {
            ClassLoader loader = Prubae.class.getClassLoader();
            is = loader.getResourceAsStream("jp/sourceforge/gnp/prubae.properties");
        } else {
            is = propertyFile;
        }
        try {
            properties.load(is);
        }
        catch (IOException ePrubaeProperty) {
            throw new ProrateRulebaseException("IOException in write() in reading jp/sourceforge/gnp/prubae.properties: " + ePrubaeProperty.getMessage(), ePrubaeProperty);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        if (this.getAdditionalPropertiesInputStream() != null) {
            try {
                properties.load(this.getAdditionalPropertiesInputStream());
            }
            catch (IOException eAdditionalProperty) {
                throw new ProrateRulebaseException("IOException in write() in reading additional property file: " + eAdditionalProperty.getMessage(), eAdditionalProperty);
            }
            finally {
                try {
                    this.getAdditionalPropertiesInputStream().close();
                }
                catch (IOException e) {}
            }
        }
        String dtdFile = properties.getProperty("GNP_RULE_DTD", "http://127.0.0.1/xml/dtd/rulebase.dtd");
        String encoding = properties.getProperty("GNP_RULE_ENCODING", "UTF-8");
        Element root = new Element("rule");
        DocType docType = new DocType("gnp", dtdFile);
        Document doc = new Document(root, docType);
        try {
            model.writeModel(this);
        }
        catch (Exception e) {
            throw new ProrateRulebaseException("Exception in writeModel() : " + e.getMessage(), e);
        }
        if (this.current != null) {
            root.addContent(this.current);
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding(encoding);
        format.setLineSeparator(new String(System.getProperty("line.separator")));
        XMLOutputter outputter = new XMLOutputter(format);
        try {
            outputter.output(doc, this.getStream());
        }
        catch (IOException E) {
            throw new ProrateRulebaseException("IOException in writeModel() : " + E.getMessage(), E);
        }
    }

    @Override
    public void writeFunction(PrubaeModelFunction model) {
        Element elem = null;
        List common = model.getCommon();
        List actions = model.getActions();
        if (model.getRegist() == 257 || model.getRegist() == 258) {
            elem = new Element(model.getRegist() == 257 ? "spa" : "apdp");
            elem.setAttribute("carrier", model.getCarrier());
            if (model.getTkCarrier() != null) {
                elem.setAttribute("tkCarrier", model.getTkCarrier());
            }
            elem.setAttribute("validStart", Integer.toString(model.getFromDate()));
            elem.setAttribute("validEnd", Integer.toString(model.getToDate()));
        } else if (model.getRegist() == 263) {
            elem = new Element("extf");
            int type = model.getExtfReturnType();
            elem.setAttribute("type", type == 1 ? "judge" : (type == 2 ? "action" : (type == 3 ? "value" : "")));
            elem.setAttribute("name", model.getName());
            List args = model.getArgs();
            Element argsElem = new Element("extf-args");
            for (int i = 0; i < args.size(); ++i) {
                this.current = null;
                String arg = (String)args.get(i);
                Element argElem = new Element("extf-arg");
                argElem.setAttribute("name", arg);
                argsElem.addContent(argElem);
            }
            elem.addContent(argsElem);
        } else if (model.getRegist() == 264) {
            elem = new Element("part");
            elem.setAttribute("name", model.getName());
        }
        if (model.getComment() != null) {
            elem.setAttribute("comment", model.getComment());
        }
        if (common.size() > 0) {
            Element commonElem = new Element("common");
            for (int i = 0; i < common.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)common.get(i)).writeModel(this);
                if (this.current == null) continue;
                commonElem.addContent(this.current);
            }
            elem.addContent(commonElem);
        }
        if (actions.size() > 0) {
            Element actionsElem = new Element("actions");
            for (int i = 0; i < actions.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)actions.get(i)).writeModel(this);
                if (this.current == null) continue;
                actionsElem.addContent(this.current);
            }
            elem.addContent(actionsElem);
        }
        this.current = elem;
    }

    @Override
    public void writeAndOr(PrubaeModelAndOr model) {
        List statements = model.getStatements();
        if (statements == null || statements.size() == 0) {
            this.current = null;
            return;
        }
        Element elem = new Element(model.getRegist() == 289 ? "and" : "or");
        for (int i = 0; i < statements.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)statements.get(i)).writeModel(this);
            if (this.current == null) continue;
            elem.addContent(this.current);
        }
        if (model.getComment() != null) {
            elem.setAttribute("comment", model.getComment());
        }
        this.current = elem;
    }

    @Override
    public void writeIf(PrubaeModelIf model) {
        PrubaeModel condition2 = model.getCondition();
        List thens = model.getThens();
        List elses = model.getElses();
        Element elem = new Element("if");
        condition2.writeModel(this);
        if (this.current != null) {
            elem.addContent(this.current);
        }
        Element thenElem = new Element("then");
        for (int i = 0; i < thens.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)thens.get(i)).writeModel(this);
            if (this.current == null) continue;
            thenElem.addContent(this.current);
        }
        Element elseElem = new Element("else");
        for (int i = 0; i < elses.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)elses.get(i)).writeModel(this);
            if (this.current == null) continue;
            elseElem.addContent(this.current);
        }
        elem.addContent(thenElem);
        elem.addContent(elseElem);
        if (model.getComment() != null) {
            elem.setAttribute("comment", model.getComment());
        }
        this.current = elem;
    }

    @Override
    public void writeSwitch(PrubaeModelSwitch model) {
        int i;
        Element elem = new Element("switch");
        List vars = model.getVars();
        List branches = model.getCases();
        Element varsElem = new Element("case-vars");
        for (i = 0; i < vars.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)vars.get(i)).writeModel(this);
            if (this.current == null) continue;
            varsElem.addContent(this.current);
        }
        elem.addContent(varsElem);
        for (i = 0; i < branches.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)branches.get(i)).writeModel(this);
            if (this.current == null) continue;
            elem.addContent(this.current);
        }
        if (model.getComment() != null) {
            elem.setAttribute("comment", model.getComment());
        }
        this.current = elem;
    }

    @Override
    public void writeCase(PrubaeModelCase model) {
        int i;
        Element elem = new Element("branch");
        List values = model.getValues();
        List actions = model.getActions();
        Element condElem = new Element("branch-condition");
        for (i = 0; i < values.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
            if (this.current == null) continue;
            condElem.addContent(this.current);
        }
        elem.addContent(condElem);
        for (i = 0; i < actions.size(); ++i) {
            this.current = null;
            ((ProrateRulebaseWriterElement)actions.get(i)).writeModel(this);
            if (this.current == null) continue;
            elem.addContent(this.current);
        }
        if (model.getComment() != null) {
            elem.setAttribute("comment", model.getComment());
        }
        this.current = elem;
    }

    @Override
    public void writeTable(PrubaeModelTable model) {
        Element elem = new Element("table");
        PrubaeModel varRow = model.getVarRow();
        PrubaeModel varCol = model.getVarCol();
        List rows = model.getRows();
        List cols = model.getCols();
        List tbls = model.getTbls();
        Element varsElem = new Element("table-vars");
        if (varRow != null && varRow.getRegist() != 0 && rows != null && rows.size() > 0) {
            this.current = null;
            varRow.writeModel(this);
            if (this.current != null) {
                varsElem.addContent(this.current);
            }
        }
        if (varCol != null) {
            this.current = null;
            varCol.writeModel(this);
            if (this.current != null) {
                varsElem.addContent(this.current);
            }
        }
        elem.addContent(varsElem);
        Element condElem = new Element("table-conditions");
        int rowsCnt = 0;
        if (rows != null && rows.size() > 0) {
            Element rowsElem = new Element("rows");
            for (int i = 0; i < rows.size(); ++i) {
                this.current = null;
                if (((PrubaeModel)rows.get(i)).getRegist() <= 0) continue;
                ((ProrateRulebaseWriterElement)rows.get(i)).writeModel(this);
                if (this.current != null) {
                    rowsElem.addContent(this.current);
                }
                ++rowsCnt;
            }
            condElem.addContent(rowsElem);
        }
        Element colsElem = new Element("cols");
        int colsCnt = 0;
        if (cols != null && cols.size() > 0) {
            for (int i = 0; i < cols.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)cols.get(i)).writeModel(this);
                if (((PrubaeModel)cols.get(i)).getRegist() <= 0) continue;
                if (this.current != null) {
                    colsElem.addContent(this.current);
                }
                ++colsCnt;
            }
            condElem.addContent(colsElem);
        }
        elem.addContent(condElem);
        Element tblsElem = new Element("amount-table");
        if (rows != null && rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                if (i >= rowsCnt) continue;
                for (int j = 0; j < cols.size(); ++j) {
                    this.current = null;
                    if (j >= colsCnt) continue;
                    int index = cols.size() * i + j;
                    ((ProrateRulebaseWriterElement)tbls.get(index)).writeModel(this);
                    if (this.current == null) continue;
                    tblsElem.addContent(this.current);
                }
            }
        } else if (cols != null && cols.size() > 0) {
            for (int i = 0; i < cols.size(); ++i) {
                this.current = null;
                if (i >= colsCnt) continue;
                ((ProrateRulebaseWriterElement)tbls.get(i)).writeModel(this);
                if (this.current == null) continue;
                tblsElem.addContent(this.current);
            }
        }
        elem.addContent(tblsElem);
        if (model.getComment() != null) {
            elem.setAttribute("comment", model.getComment());
        }
        this.current = elem;
    }

    @Override
    public void writeDoStatement(PrubaeModelDoStatement model) {
        if (model.getRegist() == 0) {
            this.current = null;
            return;
        }
        double percent = model.getPercent();
        List values = model.getValues();
        String name = model.getName();
        if (model.getRegist() == 293) {
            this.current = new Element("action-statement");
            this.current.addContent(new Element("end"));
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 520) {
            Element amountElem = new Element("amount");
            amountElem.setAttribute("currency", values.get(0).toString());
            amountElem.setAttribute("value", values.get(1).toString());
            if (model.getComment() != null) {
                amountElem.setAttribute("comment", model.getComment());
            }
            this.current = new Element("action-statement");
            if (percent != 0.0) {
                Element percentElem = new Element("percent");
                percentElem.setAttribute("number", Double.toString(percent));
                percentElem.addContent(amountElem);
                this.current.addContent(percentElem);
            } else {
                this.current.addContent(amountElem);
            }
            return;
        }
        if (model.getRegist() == 310) {
            this.current = new Element("action-statement");
            Element elem = new Element("return");
            elem.addContent(new Element("true"));
            this.current.addContent(elem);
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 311) {
            this.current = new Element("action-statement");
            Element elem = new Element("return");
            elem.addContent(new Element("false"));
            this.current.addContent(elem);
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 313) {
            this.current = new Element("action-statement");
            Element elem = new Element("partcall");
            elem.setAttribute("name", name);
            this.current.addContent(elem);
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        Element elem = null;
        if (model.getRegist() == 309) {
            elem = new Element("return");
        } else if (model.getRegist() == 291) {
            elem = new Element("funcall");
            elem.setAttribute("name", "Set");
        } else {
            elem = new Element("funcall");
            elem.setAttribute("name", name);
        }
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
                if (this.current == null) continue;
                elem.addContent(this.current);
            }
        }
        this.current = new Element("action-statement");
        if (percent != 0.0) {
            Element percentElem = new Element("percent");
            percentElem.setAttribute("number", Double.toString(percent));
            percentElem.addContent(elem);
            this.current.addContent(percentElem);
        } else {
            this.current.addContent(elem);
        }
        if (model.getComment() != null) {
            this.current.setAttribute("comment", model.getComment());
        }
    }

    @Override
    public void writeJudgeStatement(PrubaeModelJudgeStatement model) {
        if (model.getRegist() == 0) {
            this.writeJudge(model);
            return;
        }
        List values = model.getValues();
        String name = model.getName();
        Element elem = new Element("funcall");
        elem.setAttribute("name", name);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
                if (this.current == null) continue;
                elem.addContent(this.current);
            }
        }
        this.current = new Element("judge-statement");
        this.current.addContent(elem);
        if (model.getComment() != null) {
            this.current.setAttribute("comment", model.getComment());
        }
    }

    @Override
    public void writeJudge(PrubaeModelJudge model) {
        this.current = new Element("judge");
        if (model.getComment() != null) {
            this.current.setAttribute("comment", model.getComment());
        }
    }

    @Override
    public void writeValueStatement(PrubaeModelValueStatement model) {
        if (model.getRegist() == 0) {
            this.current = null;
            return;
        }
        List values = model.getValues();
        String name = model.getName();
        if (model.getRegist() == 520) {
            this.current = new Element("amount");
            this.current.setAttribute("currency", values.get(0).toString());
            this.current.setAttribute("value", values.get(1).toString());
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 513) {
            this.current = new Element("number");
            this.current.setAttribute("value", values.get(0).toString());
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 514) {
            this.current = new Element("date");
            this.current.setAttribute("month", values.get(0).toString());
            this.current.setAttribute("day", values.get(1).toString());
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 516) {
            this.current = new Element("string");
            this.current.setAttribute("value", values.get(0).toString());
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 528) {
            Element elem = new Element("path");
            for (int i = 0; i < values.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
                if (this.current == null) continue;
                elem.addContent(this.current);
            }
            this.current = elem;
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if ((model.getRegist() & 0x400) != 0) {
            this.current = new Element("variable");
            this.current.setAttribute("name", model.getStatement());
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getRegist() == 321 || model.getRegist() == 322) {
            Element elem = new Element(model.getRegist() == 321 ? "multival" : "interval");
            for (int i = 0; i < values.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
                if (this.current == null) continue;
                elem.addContent(this.current);
            }
            this.current = elem;
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        Element elem = new Element("funcall");
        elem.setAttribute("name", name);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
                if (this.current == null) continue;
                elem.addContent(this.current);
            }
        }
        this.current = elem;
        if (model.getComment() != null) {
            this.current.setAttribute("comment", model.getComment());
        }
    }

    @Override
    public void writeValue(PrubaeModelValue model) {
        List values = model.getValues();
        if (model.getRegist() == 298) {
            Element elem = new Element("case");
            for (int i = 0; i < values.size(); ++i) {
                this.current = null;
                ((ProrateRulebaseWriterElement)values.get(i)).writeModel(this);
                if (this.current == null) continue;
                elem.addContent(this.current);
            }
            this.current = elem;
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        if (model.getParent().getRegist() == 2557 || model.getParent().getRegist() == 2558) {
            Element elem = new Element("string");
            elem.setAttribute("value", values.get(0).toString());
            this.current = elem;
            if (model.getComment() != null) {
                this.current.setAttribute("comment", model.getComment());
            }
            return;
        }
        this.current = null;
    }

    @Override
    public int getFunctionSize(PrubaeModelFunction model) {
        return 0;
    }

    @Override
    public int getAndOrSize(PrubaeModelAndOr model) {
        return 0;
    }

    @Override
    public int getIfSize(PrubaeModelIf model) {
        return 0;
    }

    @Override
    public int getCaseSize(PrubaeModelCase model) {
        return 0;
    }

    @Override
    public int getSwitchSize(PrubaeModelSwitch model) {
        return 0;
    }

    @Override
    public int getTableSize(PrubaeModelTable model) {
        return 0;
    }

    @Override
    public int getDoStatementSize(PrubaeModelDoStatement model) {
        return 0;
    }

    @Override
    public int getJudgeStatementSize(PrubaeModelJudgeStatement model) {
        return 0;
    }

    @Override
    public int getValueStatementSize(PrubaeModelValueStatement model) {
        return 0;
    }

    @Override
    public int getValueSize(PrubaeModelValue model) {
        return 0;
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public void setStream(OutputStream stream) {
        this.stream = stream;
    }

    public InputStream getAdditionalPropertiesInputStream() {
        return this.additionalPropertiesInputStream;
    }

    public void setAdditionalPropertiesInputStream(InputStream propertiesInputStream) {
        this.additionalPropertiesInputStream = propertiesInputStream;
    }
}

