/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.search;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.search.CompareOperator;
import org.apache.webdav.lib.search.SearchException;
import org.apache.webdav.lib.search.SearchRequest;
import org.apache.webdav.lib.search.SearchScope;
import org.apache.webdav.lib.search.expressions.AndExpression;
import org.apache.webdav.lib.search.expressions.CompareExpression;
import org.apache.webdav.lib.search.expressions.OrExpression;

public class SearchRequestSample {
    static final PropertyName DISPLAYNAME = new PropertyName("DAV:", "displayname");
    static final PropertyName LASTMODIFIED = new PropertyName("DAV:", "getlastmodified");
    static final PropertyName ABSTRACT = new PropertyName("http://any.domain/test/", "abstract");
    static final PropertyName KEYWORDS = new PropertyName("http://any.domain/test/", "keywords");

    public static void main(String[] args) {
        try {
            SearchRequestSample.test1();
            SearchRequestSample.testWithScopes();
            SearchRequestSample.testWithVariables();
        }
        catch (SearchException e) {
            e.printStackTrace();
        }
    }

    public static void test1() throws SearchException {
        SearchRequest s = new SearchRequest();
        s.addSelection(DISPLAYNAME);
        s.addSelection(LASTMODIFIED);
        s.addScope(new SearchScope("files"));
        AndExpression expression = s.and(s.compare(CompareOperator.LIKE, DISPLAYNAME, "%.xml"), s.and(s.compare(CompareOperator.GT, LASTMODIFIED, new Date(1100000000000L)), s.compare(CompareOperator.LT, LASTMODIFIED, new Date(1121212121212L))));
        s.setWhereExpression(expression);
        System.out.println(s.asString());
    }

    public static void testWithVariables() throws SearchException {
        SearchRequest s = new SearchRequest();
        s.addSelection(DISPLAYNAME);
        s.addSelection(LASTMODIFIED);
        s.addScope(new SearchScope("files/docs1"));
        s.addScope(new SearchScope("files/docs2"));
        CompareExpression expression = s.compare(CompareOperator.PROPERTY_CONTAINS, ABSTRACT, s.variable("TEXT"));
        s.setWhereExpression(expression);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("TEXT", "aber hallo");
        System.out.println(s.asString(variables));
        variables.put("TEXT", "holla blokes");
        System.out.println(s.asString(variables));
    }

    public static void testWithScopes() throws SearchException {
        SearchRequest s = new SearchRequest();
        s.addSelection(DISPLAYNAME);
        s.addSelection(LASTMODIFIED);
        OrExpression expression = s.or(s.isDefined(ABSTRACT), s.isDefined(KEYWORDS));
        s.setWhereExpression(expression);
        System.out.println(s.asString());
        ArrayList<SearchScope> scopes = new ArrayList<SearchScope>();
        scopes.add(new SearchScope("files/docs1"));
        scopes.add(new SearchScope("files/docs2"));
        System.out.println(s.asString(scopes));
    }
}

