#!/usr/bin/perl

$request_method = $ENV{'REQUEST_METHOD'};

if ($request_method eq "GET") {
  $query_string = $ENV{'QUERY_STRING'};
}
elsif ($request_method eq "POST") {
  read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
}
else {
  
}
@key_value_pairs = split (/&/, $query_string);

foreach $key_value (@key_value_pairs) {
  ($key, $value) = split (/=/, $key_value);
  if ($key eq "rule") {
    $rule = $value;
  }
  elsif ($key eq "cwd") {
    $cwd = $value;
    $cwd =~ s/%2f/\//g;
    $cwd =~ s/%2F/\//g;
  }
  elsif ($key eq "carrier") {
    $carrier = $value;
  }
  elsif ($key eq "tkCarrier") {
    $tkCarrier = $value;
  }
  elsif ($key eq "from") {
    $from = $value;
  }
  elsif ($key eq "until") {
    $until = $value;
  }
  elsif ($key eq "name") {
    $name = $value;
  }
}

if ($rule eq "spa") {
  $file = $cwd . "/" . $rule . "/" . "SPA(" . $carrier . "," . $tkCarrier . ")" . $from . $until . ".xml";
}
elsif ($rule eq "apdp") {
  $file = $cwd . "/" . $rule . "/" . "APDP(" . $carrier . ")" . $from . $until . ".xml";
}
elsif ($rule eq "extf") {
  $file = $cwd . "/" . $rule . "/" . "EXTF(" . $name . ")" . ".xml";
}
elsif ($rule eq "part") {
  $file = $cwd . "/" . $rule . "/" . "PART(" . $name . ")" . ".xml";
}

if (-f $file) {
  print "Content-type: text/plain", "\n\n";

  print $query_string . " is the query_string.\n\n";
  print $rule . " is the rule.\n\n";
  print $file . " is already exists, is not created now.\n\n";
  #print $outfile . " is open argument.\n\n"; 
  print "Please go backward 2 pages, rule already exists.\n\n";

  exit;
}

#$outfile = "| /bin/cat > " . $file;
#open(OUT, $outfile);

open(OUT, ">$file");
$line = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
print OUT $line;
$line = "<!DOCTYPE gnp SYSTEM \"http://127.0.0.1/xml/dtd/rulebase.dtd\">\n";
print OUT $line;
$line = "\n";
print OUT $line;
$line = "<rule>\n";
print OUT $line;
if ($rule eq "spa") {
  $line = "  <spa carrier=\"". $carrier . "\" tkCarrier=\"" . $tkCarrier . "\" validStart=\"" . $from . "\" validEnd=\"" . $until . "\" comment=\"\">\n";
}
elsif ($rule eq "apdp") {
  $line = "  <apdp carrier=\"". $carrier . "\" tkCarrier=\"\" validStart=\"" . $from . "\" validEnd=\"" . $until . "\" comment=\"\">\n";
}
elsif ($rule eq "extf") {
  $line = "  <extf name=\"" . $name . "\" comment=\"\">\n";
}
elsif ($rule eq "part") {
  $line = "  <part name=\"" . $name . "\" comment=\"\">\n";
}
print OUT $line;
if ($rule eq "spa") {
  $line = "  </spa>\n";
}
elsif ($rule eq "apdp") {
  $line = "  </apdp>\n";
}
elsif ($rule eq "extf") {
  $line = "  </extf>\n";
}
elsif ($rule eq "part") {
  $line = "  </part>\n";
}
print OUT $line;
$line = "</rule>\n";
print OUT $line;
$line = "\n";
print OUT $line;

close(OUT);

chmod(0666, $file);

my($host) = $ENV{'REMOTE_ADDR'};

print("Location: http://" . $host . "/gnp/rulebase/rulebase.php?cd=" . $rule . "\n\n");

#print "Content-type: text/plain", "\n\n";

#print $query_string . " is the query_string.\n\n";
#print $rule . " is the rule.\n\n";
#print $file . " is written.\n\n";
##print $outfile . " is open argument.\n\n"; 
#print "Please go backward 2 pages and reload the page.\n\n";
