<html>
<TITLE>Rulebase Directory</TITLE>
<BODY>
<?php 
/*	**************************************************************

	refered from dir.php3

	A script to manage files on your web 

	Questions, comments, bug reports to : yannickf@yahoo.com
	SourceForge project phpFileManager:
	http://sourceforge.net/project/?group_id=1640

	**************************************************************
	History
	Version 0.1	
					first release

	Version 0.2	Feb 21 2000
					bug correction

	Version 0.3	Feb 22 2000
					change sort algo
					add icons before files
					set display for atime, ctime, utime 

	**************************************************************
*/

function cmp( $a, $b )
{
	if( $a->inode == $b->inode )
		return 0;

	return strcmp($a->name, $b->name);
}

/* ;;; not used
function getIcons( $ext ) 
{
	switch( $ext ) 
	{
		case "dir":
			$file = "dir";
			break;
		case "link":
			$file = "link";
			break;
		case "zip":
		case "tgz":
		case "gz":
		case "Z":
			$file = "compressed";
			break;
		case "gif":
		case "jpg":
			$file = "image2";
			break;
		case "dvi":
			$file = "dvi";
			break;
		case "":
		case "exe":
			$file = "binary";
			break;
		case "sh":
		case "php":
		case "php3":
		case "sql":
		case "inc":
		case "js":
			$file = "script";
			break;
		case "txt":
			$file = "text";
			break;
		case "html":
		case "shtml":
		case "phtml":
			$file = "world1";
			break;
	  default:
			$file = "generic";
			break;
	}
	
	return $IMG="<IMG SRC='icons/".$file.".gif'>";
}
*/

class MyFile {
	var $name;
	var $path;
	var $type;
	var $ext;
	var $stype;
	var $sfile;
	var $size;
	var $file;
	var $atime;
	var $ctime;
	var $mtime;
	var $group;
	var $inode;
	var $owner;
	var $perms;

	function set( $filename, $path )
	{
		GLOBAL $cd;

		$this->name  = $filename;
		$this->path  = $path    ;
		$this->file  = $this->path."/".$this->name;

		$this->type  = filetype( $this->file );
		$this->size  = filesize( $this->file );
		$this->atime = fileatime( $this->file );
		$this->ctime = filectime( $this->file );
		$this->mtime = filemtime( $this->file );
		$this->group = filegroup( $this->file );
		$this->inode = fileinode( $this->file );
		$this->owner = fileowner( $this->file );
		$this->perms = fileperms( $this->file );
		
		switch( $this->type )
		{
			case "link":
				$this->sfile = readlink( $this->file  );
				$this->stype = filetype( $this->sfile );
				$this->ext   = "link";
				break;
			case "file":
				$list = explode( ".", $this->name );
				$nb = sizeof( $list );
				if( $nb > 0 )
					$this->stype = $list[$nb-1];
				else
					$this->stype = "???";

				$this->ext   = $this->stype;

				switch( $this->stype )
				{
				  case "gif":
				  case "GIF":
				  case "jpg":
				  case "JPG":
						if( isset( $cd ) )
							$pwd = $cd."/";
						else
						  $pwd = "";

						$this->sfile = "<IMG SRC='".$this->file."'>";
						break;
				  default:
						$this->sfile = $this->stype;
						break;
				}
				break;
		  default:
				$this->stype = "";
				$this->sfile = "";
				$this->ext   = $this->type;
				break;
		}
	}

	function formatSize()
	{
		return number_format( $this->size, 0, ".", " ");
	}
}

function genUrl( $ref, $args, $key = "", $val = "" )
{
	$valist = "";

	reset( $args );

	if( $key != "" )
		$args[ "$key" ] = $val;

	if( !is_array( $args ) )
		return $ref;

	while( list( $key, $val ) = each( $args ) ) 
  {
		if( $val == "" )
			continue;

		if( $valist == "" )
			$valist .= "?";
		else
			$valist .= "&";

		$valist .= $key."=".$val;
	}
	return $ref.$valist;
}

function updir( $path )
{
	$last = strrchr( $path, "/" );
	$n1   = strlen( $last );
	$n2   = strlen( $path );
	return substr( $path, 0, $n2-$n1 );
}

$ref = "rulebase.php";

/* echo("cd=".$_GET['cd']."\n<br><br>"); */

if( isset( $_GET['cd'] ) ) 
{
	$path = $_GET['cd'];
	//$lcd = "?cd=$_GET['cd']'";
	$args[ "cd" ] = $_GET['cd'];
}
else
{
  $path = ".";
	//$lcd = "";
	$args[ "cd" ] = "";
}

if( isset( $nb ) )
{
	for( $i = 0; $i < $nb; $i++ )
	{
		$var = "id_$i";
		if( isset( $$var ) )
		{
			$file = $path."/".$$var;
			if( is_file( $file ) || is_link( $file ) )
			{
				if( unlink( $file ) )
					echo "<BR><b>$file</b> deleted\n";
				else
					echo "<BR>unable to delete <b>$file</b>\n";
			}
			elseif( is_dir( $file ) )
			{
				if( rmdir( $file ) )
					echo "<BR><b>$file</b> deleted\n";
				else
					echo "<BR>unable to delete <b>$file</b>\n";
			}
		}
	}
}

$step = 10000;

if( !isset( $sort ) )
	$sort = "name";
else
	$args[ "sort" ] = $sort;

if( !isset( $from ) )
	$from = 0;
else
	$args[ "from" ] = $from;

if( !isset( $to ) )
	$to   = $from + $step;

$d = dir($path);
/*
echo "\n";
echo "<br><a href=$ref >Home</a>\n";
*/
$updir = updir($d->path);
/*
if( $updir != "." )
	echo "<br>Up dir; <a href=$ref?cd=$updir>$updir</a>\n";
echo "<br>cd: <a href=$ref?cd=".$d->path."/..>..</a>\n";
echo "<br>Chemin: <b>".$d->path."</b>\n";
*/
echo "<br>Rule: <b>".$d->path."</b>\n";

echo("<br><br>\n");

/* ;;; new rule */
echo("<a href=newrule.php?rule=".$_GET['cd'].">\n"
	."new ".$_GET['cd']."</a><br>\n");
echo("<br><br>\n");

$n    = 0;
while( $entry=$d->read() )
{
	$entryFile = new MyFile;
	$entryFile->set( $entry, $path );
	if (strcmp($entryFile->ext, "xml") == 0) {
		$lFiles[ $n ] = $entryFile;
		$n++;
	}
}

$d->close();

@usort( $lFiles, cmp );

for( $i = 0; $i < $n; $i++ )
{
	if( ( $i < $from ) || ( $i >= $to ) )
		continue;

	$k = $i;

	echo("<a href=prubae.php?url="
		.$_GET['cd']."/".$lFiles[ $k ]->name.">\n"
		.$lFiles[ $k ]->name."</a><br>\n");

}

$from = $from - $step;
if( isset( $_GET['cd'] ) )
{
	echo "<INPUT TYPE='hidden' NAME='cd' VALUE=".$_GET['cd'].">\n";
}
echo "<INPUT TYPE='hidden' NAME='nb' VALUE='$n'>\n";

//echo "<br>from=$from;to=$to;n=$n\n";
echo "<br>\n";
if( $from >=  0 )
{
	echo "<a href='".
		genUrl( $ref, $args, "from", $from )."' >Prev</a>/\n";
}
if( $to   <= $n )
{
	echo "<a href='".
		genUrl( $ref, $args, "from", $to )."'   >Next</a> \n";
}
echo "<br>\n";

?>
</body>
</html>
