/*----------------------------*/
/* ROBOT ARM CONTROL PROGRAM  */
/*----------------------------*/
#include <stdio.h>
#include <usb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include "io_usbio.h"

extern int mainLoop(usb_dev_handle *udev, int key);

unsigned char *memoryMapUsbIo = NULL;
unsigned char  contl = 0x00;
unsigned char  port0 = 0xff;
unsigned char  port1 = 0xff;

#define DEFAULT_SHARED_FILE "/android-1.5r3/sdcard/tempIPC.tmp"

/********************************
 *
 *        MAIN   PROCEDURE
 *
 ********************************/
int main(int argc, char* argv[])
{
    int key, fd;
    struct usb_device *dev = NULL;
    usb_dev_handle    *udev;

    /** decide shared file name **/
    char *shareFile = DEFAULT_SHARED_FILE;
    if (argc > 1)
    {
        shareFile = *++argv;
    }

    fd = open(shareFile, O_RDWR);
    if (fd == -1)
    {
      fprintf(stderr, "ERR>FILE OPEN FAILURE. (%s)\n", shareFile);
        return (-4);
    }

    memoryMapUsbIo = mmap(NULL, (sizeof(unsigned char) * 3), (PROT_READ|PROT_WRITE), MAP_SHARED, fd, 0);
    if (memoryMapUsbIo == MAP_FAILED)
    {
        /**  Memory Mapping failure **/
        memoryMapUsbIo = NULL;
        fprintf(stderr, "ERR>MEMORY MAPPING FAILURE.\n");
        return (-3);
    }
    if (memoryMapUsbIo == NULL)
    {
        fprintf(stderr, "ERR>MEMORY MAPPING FAILURE.\n");
        return (-2);
    }

    /** initialize default variables **/
    contl = memoryMapUsbIo[0];
    port0 = memoryMapUsbIo[1];
    port1 = memoryMapUsbIo[2]; 

    /*-------------*/
    /* Device Open */
    /*-------------*/
    dev = find_morphy_usbio(dev);
    if (dev == NULL)
    {
        fprintf(stderr, "ERR>CANNOT FIND any Interface.\n");
        return (-1);
    }
    udev = open_morphy(dev);
    if (udev == NULL)
    {
        fprintf(stderr, "ERR>The interface was FAILED to open.\n");
        exit (2);
    }

    /*--------------------*/
    /*     MAIN  LOOP     */
    /*--------------------*/
    do 
    {
        key = memoryMapUsbIo[0];
        usleep(1000);
    } while (mainLoop(udev, key) >= 0);

    /*---------------------*/
    /*   Stop ARM Motion   */
    /*---------------------*/
    output_to_usbio(udev, 0, 0xff);
    output_to_usbio(udev, 1, 0xff);

    /*---------------------*/
    /* Device Close & Exit */
    /*---------------------*/
    close_morphy(udev);

    /** Unmap Shared Memory **/
    munmap(memoryMapUsbIo, sizeof(unsigned char) * 3);

    /** Close 'Shared File'. **/
    close(fd);

    return(0);
}
