#include <stdio.h>
#include <usb.h>
#include "io_usbio.h"

extern unsigned char *memoryMapUsbIo;
extern unsigned char  contl;
extern unsigned char  port0;
extern unsigned char  port1;

/*
 *
 */
int mainLoop(usb_dev_handle *udev, int key)
{
    unsigned char keyData;

    keyData = ((unsigned char) key & 0xff);

    /**  finish the program **/
    if (keyData == 0x78)  // 'x'
    {    
        return (-1);
    }

    /** check change **/
    if ((keyData == contl)&&(memoryMapUsbIo[1] == port0)&&(memoryMapUsbIo[2] == port1))
    {
        /** nothing to change **/
        return (0);
    }
    contl = keyData;

    // for debug message
    // printf("(0x%x, 0x%x, 0x%x)\n", memoryMapUsbIo[0], memoryMapUsbIo[1], memoryMapUsbIo[2]);

    /** ouput data to port0 **/
    if (port0 != memoryMapUsbIo[1])
    {
        port0 = memoryMapUsbIo[1];
        output_to_usbio(udev, 0, port0);
    }

    /** ouput data to port1 **/
    if (port1 != memoryMapUsbIo[2])
    {
        port1 = memoryMapUsbIo[2];
        output_to_usbio(udev, 1, port1);
    }
    return (1);
}
