/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;
import processing.core.PApplet;
import processing.core.PImage;

public class gokuraku_measure
extends PApplet {
    final int Max_measure = 32;
    final int Target_size = 5;
    final int[][] Target_color = new int[][]{{255, 80, 80}, {255, 255, 255}, new int[3]};
    final float Initial_scale = 1.0f;
    final String Export_ext = ".txt";
    currentImageClass ci;

    public void setup() {
        this.ci = new currentImageClass();
        this.surface.setResizable(true);
    }

    public void draw() {
        if (this.ci.img != null) {
            int cnt = 0;
            this.image(this.ci.img, 0.0f, 0.0f);
            cnt = 0;
            while (cnt < this.ci._counter) {
                this.ci.target.plot(this.ci.measured[cnt].px, this.ci.measured[cnt].py);
                ++cnt;
            }
        } else {
            int x = 16;
            int y = 32;
            int dx = 150;
            int dy = 40;
            this.noStroke();
            this.fill(72.0f, 72.0f, 72.0f);
            this.surface.setSize(400, 500);
            this.rect(0.0f, 0.0f, 399.0f, 499.0f);
            this.textSize(24.0f);
            this.fill(this.Target_color[this.ci.target.t_color][0], this.Target_color[this.ci.target.t_color][1], this.Target_color[this.ci.target.t_color][2]);
            this.text("(Left click)", x, y);
            this.text(": measure", x + dx, y);
            this.text("Shift+(left)", x, y += dy);
            this.text(": back", x + dx, y);
            this.text("(Right clisk)", x, y += dy);
            this.text(": end / select file", x + dx, y);
            this.text("[ESC]", x, y += dy);
            this.text(": end / exit", x + dx, y);
            this.text("[p]", x, y += dy);
            this.text(": change plot", x + dx, y);
            this.text("[c]", x, y += dy);
            this.text(": change color", x + dx, y);
            this.text("[+]", x, y += dy);
            this.text(": scale up", x + dx, y);
            this.text("[-]", x, y += dy);
            this.text(": scale down", x + dx, y);
            this.text("[0]", x, y += dy);
            this.text(": reset scale", x + dx, y);
            this.text("[s]", x, y += dy);
            this.text(": show settings", x + dx, y);
            this.text("[d]", x, y += dy);
            this.text(": show datas", x + dx, y);
            this.text("[f]", x, y += dy);
            this.text(": select folder", x + dx, y);
            int n = y + dy;
        }
    }

    public void mousePressed() {
        if (this.mouseButton == 39) {
            this.ci.flush_data();
            if (this.ci.folder_mode) {
                if (this.ci.next_image() == null) {
                    this.ci.quit_folder_mode();
                }
            } else {
                this.open_fileselector();
            }
        } else if (this.mouseButton == 37 && this.ci.img != null) {
            if (this.keyPressed && this.keyCode == 16) {
                this.ci.back();
            } else {
                this.ci.measure(this.mouseX, this.mouseY);
            }
        }
    }

    public void keyPressed() {
        switch (this.keyCode) {
            case 27: {
                if (this.ci.img == null) {
                    this.terminate();
                    break;
                }
                this.ci.flush_data();
                if (this.ci.folder_mode) {
                    this.ci.quit_folder_mode();
                }
                this.key = '\u0000';
                break;
            }
            case 80: 
            case 112: {
                this.ci.target.change_shape();
                break;
            }
            case 67: 
            case 99: {
                this.ci.target.change_color();
                break;
            }
            case 83: 
            case 115: {
                this.show_settings();
                break;
            }
            case 43: 
            case 59: 
            case 107: {
                this.ci.rescale(0.5f);
                break;
            }
            case 45: 
            case 109: {
                this.ci.rescale(-0.5f);
                break;
            }
            case 48: 
            case 96: {
                this.ci.rescale(0.0f);
                break;
            }
            case 68: 
            case 100: {
                this.show_datas();
                break;
            }
            case 70: 
            case 102: {
                this.selectFolder("Select a folder to process:", "folderSelected");
            }
        }
    }

    public void open_fileselector() {
        this.selectInput("Select a file to process:", "fileSelected");
    }

    public void fileSelected(File selection) {
        this.ci.flush_data();
        if (selection == null) {
            this.ci.img = null;
        } else {
            this.ci.load(selection.getAbsolutePath());
        }
    }

    public void folderSelected(File selection) {
        if (selection == null) {
            return;
        }
        selection.listFiles();
        this.ci.flush_data();
        gokuraku_measure.println((String)("User select folder = " + selection.getAbsolutePath()));
        this.ci.open_folder(selection.listFiles());
    }

    public void terminate() {
        if (this.ci.img != null) {
            this.ci.export_data();
        }
        gokuraku_measure.println((String)"Exit program.");
        this.exit();
    }

    public void show_settings() {
        gokuraku_measure.println((String)"[Settings]");
        gokuraku_measure.println((String)"Max_measure = 32");
        gokuraku_measure.println((String)"Target_size = 5");
        gokuraku_measure.println((String)("Target_color = " + this.Target_color[0] + ", " + this.Target_color[1] + ", " + this.Target_color[2]));
        gokuraku_measure.println((String)("Scale = " + this.ci.scale));
    }

    public void show_datas() {
        if (this.ci.img == null) {
            return;
        }
        if (this.ci._counter <= 0) {
            gokuraku_measure.println((String)"no datas");
        }
        gokuraku_measure.println((String)"[Datas]");
        int n = 0;
        while (n < this.ci._counter) {
            gokuraku_measure.println((String)(String.valueOf(n) + " : " + this.ci.measured[n].px + " , " + this.ci.measured[n].py));
            ++n;
        }
    }

    public void settings() {
        this.size(400, 500);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"gokuraku_measure"};
        if (passedArgs != null) {
            PApplet.main((String[])gokuraku_measure.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class currentImageClass {
        PImage img = null;
        String fullpathname = null;
        float scale = 1.0f;
        boolean folder_mode = false;
        File[] files = null;
        int f_no = 0;
        int _counter = 0;
        pointDataClass[] measured = new pointDataClass[32];
        targetMarkerClass target;

        currentImageClass() {
            while (this._counter < 32) {
                this.measured[this._counter] = new pointDataClass();
                ++this._counter;
            }
            this.target = new targetMarkerClass();
        }

        public PImage load(String path) {
            PImage img0;
            boolean reload = false;
            if (path == null) {
                reload = true;
            }
            if (!reload) {
                this.fullpathname = path;
            }
            if ((img0 = gokuraku_measure.this.loadImage(this.fullpathname)) == null) {
                return null;
            }
            this.img = img0;
            gokuraku_measure.println((String)("Loaded image: " + this.fullpathname));
            if (this.scale > 1.0f) {
                this.img.resize((int)((float)this.img.width * this.scale), (int)((float)this.img.height * this.scale));
            }
            gokuraku_measure.this.surface.setSize(this.img.width, this.img.height);
            if (!reload) {
                this._counter = 0;
            }
            return this.img;
        }

        public PImage reload() {
            if (this.fullpathname == null) {
                return null;
            }
            return this.load(null);
        }

        public int measure(int x, int y) {
            if (this._counter >= 32) {
                return this._counter;
            }
            this.measured[this._counter].px = x;
            this.measured[this._counter].py = y;
            this.measured[this._counter].get_color(this.img);
            if (++this._counter >= 32) {
                gokuraku_measure.this.ci.export_data();
                gokuraku_measure.this.open_fileselector();
            }
            return this._counter;
        }

        public int back() {
            if (--this._counter < 0) {
                this._counter = 0;
            }
            return this._counter;
        }

        public void export_data() {
            int cnt = 0;
            String dest_filename = String.valueOf(this.fullpathname) + ".txt";
            PrintWriter output = gokuraku_measure.this.createWriter(dest_filename);
            if (output != null) {
                output.println("Scale: " + this.scale);
                cnt = 0;
                while (cnt < gokuraku_measure.this.ci._counter) {
                    output.print(String.valueOf(cnt) + "\t" + gokuraku_measure.this.ci.measured[cnt].px + "\t" + gokuraku_measure.this.ci.measured[cnt].py);
                    output.println("\t" + (int)gokuraku_measure.this.red(gokuraku_measure.this.ci.measured[cnt].c) + "\t" + (int)gokuraku_measure.this.green(gokuraku_measure.this.ci.measured[cnt].c) + "\t" + (int)gokuraku_measure.this.blue(gokuraku_measure.this.ci.measured[cnt].c));
                    ++cnt;
                }
                output.flush();
                output.close();
                gokuraku_measure.println((String)("Completed exporting datas to " + dest_filename));
            } else {
                gokuraku_measure.println((String)("Error: Can't open file =" + dest_filename));
            }
        }

        public void flush_data() {
            if (gokuraku_measure.this.ci.img != null && gokuraku_measure.this.ci._counter > 0) {
                this.export_data();
            }
            gokuraku_measure.this.ci.img = null;
        }

        public void open_folder(File[] f) {
            this.files = f;
            this.f_no = 0;
            this.folder_mode = true;
            gokuraku_measure.println((String)"[Folder mode]:Start");
            if (this.next_image(true) == null) {
                this.quit_folder_mode();
            }
        }

        public PImage next_image() {
            return this.next_image(false);
        }

        public PImage next_image(boolean first) {
            PImage ret = null;
            if (!first) {
                ++this.f_no;
            }
            while (this.f_no < this.files.length) {
                if (!this.files[this.f_no].getPath().endsWith(".txt") && (ret = gokuraku_measure.this.loadImage(this.files[this.f_no].getAbsolutePath())) != null) break;
                ++this.f_no;
            }
            if (ret == null) {
                return null;
            }
            ret = this.load(this.files[this.f_no].getAbsolutePath());
            return ret;
        }

        public void quit_folder_mode() {
            this.folder_mode = false;
            this.img = null;
            gokuraku_measure.println((String)"[Folder mode]:Quit");
        }

        public void rescale(float diff) {
            float pre_scale = this.scale;
            if (diff == 0.0f && this.scale == 1.0f) {
                return;
            }
            if (diff == 0.0f) {
                this.scale = 1.0f;
            } else {
                this.scale += diff;
                if (this.scale < 1.0f) {
                    this.scale = 1.0f;
                }
            }
            if (this._counter > 0) {
                int n = 0;
                while (n < this._counter) {
                    this.measured[n].px = (int)((float)this.measured[n].px / pre_scale * this.scale);
                    this.measured[n].py = (int)((float)this.measured[n].py / pre_scale * this.scale);
                    ++n;
                }
            }
            gokuraku_measure.println((String)("Change scale " + pre_scale + " -> " + this.scale));
            this.reload();
        }
    }

    class pointDataClass {
        int px = -1;
        int py = -1;
        int c;

        pointDataClass() {
        }

        public void get_color(PImage img) {
            this.c = img.pixels[this.px + this.py * img.width];
        }
    }

    class targetMarkerClass {
        char mode = '\u0001';
        int size = 5;
        int t_color;

        targetMarkerClass() {
        }

        public void change_shape() {
            this.mode = (char)(this.mode + '\u0001');
            if (this.mode > '\u0003') {
                this.mode = '\u0000';
            }
        }

        public void change_color() {
            if (++this.t_color > 2) {
                this.t_color = 0;
            }
        }

        public void plot(int x, int y) {
            gokuraku_measure.this.stroke(gokuraku_measure.this.Target_color[this.t_color][0], gokuraku_measure.this.Target_color[this.t_color][1], gokuraku_measure.this.Target_color[this.t_color][2]);
            gokuraku_measure.this.noFill();
            switch (this.mode) {
                case '\u0000': {
                    break;
                }
                case '\u0001': {
                    gokuraku_measure.this.line(x - this.size, y, x + this.size, y);
                    gokuraku_measure.this.line(x, y - this.size, x, y + this.size);
                    break;
                }
                case '\u0002': {
                    gokuraku_measure.this.ellipse(x, y, this.size * 2, this.size * 2);
                    break;
                }
                case '\u0003': {
                    gokuraku_measure.this.rectMode(3);
                    gokuraku_measure.this.rect(x, y, 3.0f, 3.0f);
                    break;
                }
                default: {
                    this.mode = '\u0000';
                }
            }
        }
    }
}

