
/*    Include Header Files    */

#define SC_INCLUDE_DYNAMIC_PROCESSES
#include <systemc.h>
#include "producer.h"
#include "consumer.h"
#include "testbench.h"
//===============================================
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <sys/fcntl.h>
//===============================================


/* Abstract
  ~~~~~~~~~~
     This program uses FIFO functions. */ 

#define  LcdSizeX  200
#define  LcdSizeY  200
#define  LcdSize   LcdSizeX * LcdSizeY


int sc_main(int argc, char * argv[])
{
        sc_clock  clock;
        TESTBENCH testbench("testbench");

        testbench.m_clk(clock);
        sc_start(5000, SC_NS);
        cout << "Done" << endl;

        /*   Initialize Environment */
        FILE *fp ;
        int  fd_data, fd_id ;
        int  len ;
        int  cnt = 0 ;
        int  ttt = 0 ;
        char rbuf[256];
        char fifobuf[256];
        char bufrgb[256];
        unsigned char x, y ;
      

        if(mkfifo("/tmp/FifoTest_S", 0666) < 0 ){
                perror("mkfifo");
        }
        if(mkfifo("/tmp/FifoTest_R", 0666) < 0 ){
                perror("mkfifo");
        }

        if ((fd_data=open("/tmp/FifoTest_S", O_WRONLY)) < 0 ){
                perror("open");
                return(-1) ;
        }
        if ((fd_id=open("/tmp/FifoTest_R", O_RDONLY)) < 0 ){
                perror("open");
                return(-1) ;
        }

        if ((fp = fopen("SnapShot1.bmp", "rb")) == NULL) {
                printf("file open error!! (SnapShot1.bmp)  \n");
                return(-1);
        }

        //printf("1\n");
        fread( rbuf, sizeof(char), 54, fp);
        //printf("2\n");

        while( 1 ){
           bufrgb[0] = fgetc(fp) ;
           if (feof(fp)){
              break;
           }
           //printf("mmm  %d\n", bufrgb[0] );
           sprintf( fifobuf, "%d\0", bufrgb[0] );

           write(fd_data,fifobuf,strlen(fifobuf));

           //printf("nnn %s cnt:%d\n", fifobuf, cnt++ );

           //
           len=read(fd_id,rbuf,sizeof(rbuf)-1);
           if ( len == 0 ){
              break;
           }
           rbuf[len]='\0';
           //printf( "+++  %s\n", rbuf );

           if ( strcmp( fifobuf, rbuf ) != 0 ){
              printf("ACK error!\n");
              break;
           }
        }

//        for ( y = 0 ; y < LcdSizeY ; y++ ) {
//           for ( x = 0 ; x < LcdSizeX ; x++ ){
//              printf("3\n");
//              fread( bufrgb, sizeof(char), 1, fp);
//              printf("4\n");
//              printf("%d", bufrgb[0] );
//              sprintf(fifobuf, "%d", bufrgb[0] );
//              bufrgb[1] = 0 ;
//              write(fd_data,fifobuf,1);
//              while ( (x+(y*200)) != ttt ){
//                 len=read(fd_id, bufid, sizeof(bufid)-1);
//                 if (len==0){ break; }
//                 if (len<1){
//                    printf("len is short! : %d\n", len);
//                    break;
//                 }
//                 bufid[len] = '\0' ;
//                 ttt = atoi( bufid ) ;
//                 printf("ttt:%d len:%d \n", ttt, len);
//              }
//           }
//        }
        printf("\n");

        close(fd_data);
        close(fd_id);
        fclose(fp);

        /*    END OF PROCESS   */
        return 0;
}

