/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.deployment.webapp.DefaultWarArchive;
import org.apache.cactus.integration.ant.deployment.webapp.WebXml;
import org.apache.cactus.integration.ant.deployment.webapp.WebXmlIo;
import org.apache.cactus.integration.ant.deployment.webapp.WebXmlMerger;
import org.apache.cactus.integration.ant.deployment.webapp.WebXmlVersion;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class CactifyWarTask
extends War {
    private static final String FILTER_REDIRECTOR_CLASS = "org.apache.cactus.server.FilterTestRedirector";
    private static final String DEFAULT_FILTER_REDIRECTOR_MAPPING = "/FilterRedirector";
    private static final String DEFAULT_JSP_REDIRECTOR_MAPPING = "/JspRedirector";
    private static final String SERVLET_REDIRECTOR_CLASS = "org.apache.cactus.server.ServletTestRedirector";
    private static final String DEFAULT_SERVLET_REDIRECTOR_MAPPING = "/ServletRedirector";
    private File srcFile;
    private File mergeWebXml;
    private List redirectors = new ArrayList();
    private XMLCatalog xmlCatalog = null;
    private String version = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        WebXml webXml = null;
        if (this.srcFile != null) {
            this.log("Analyzing war: " + this.srcFile.getAbsolutePath(), 2);
            ZipFileSet currentFiles = new ZipFileSet();
            currentFiles.setSrc(this.srcFile);
            currentFiles.createExclude().setName("WEB-INF/web.xml");
            this.addZipfileset(currentFiles);
            webXml = this.getOriginalWebXml();
        } else {
            if (this.version == null) {
                throw new BuildException("You need to specify either the [srcfile] or the [version] attribute");
            }
            WebXmlVersion webXmlVersion = null;
            webXmlVersion = this.version.equals("2.2") ? WebXmlVersion.V2_2 : WebXmlVersion.V2_3;
            try {
                webXml = WebXmlIo.newWebXml(webXmlVersion);
            }
            catch (ParserConfigurationException pce) {
                throw new BuildException("Could not create deployment descriptor", (Throwable)pce);
            }
        }
        File tmpWebXml = this.cactifyWebXml(webXml);
        this.setWebxml(tmpWebXml);
        this.addCactusJars();
        try {
            super.execute();
        }
        finally {
            tmpWebXml.delete();
        }
    }

    public final void addFilterRedirector(FilterRedirector theFilterRedirector) {
        this.redirectors.add(theFilterRedirector);
    }

    public final void addJspRedirector(JspRedirector theJspRedirector) {
        this.redirectors.add(theJspRedirector);
    }

    public final void addServletRedirector(ServletRedirector theServletRedirector) {
        this.redirectors.add(theServletRedirector);
    }

    public final void addConfiguredXMLCatalog(XMLCatalog theXmlCatalog) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(theXmlCatalog);
    }

    public final void setMergeWebXml(File theMergeFile) {
        this.mergeWebXml = theMergeFile;
    }

    public final void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public final void setVersion(Version theVersion) {
        this.version = theVersion.getValue();
    }

    private void addCactusJars() {
        this.addJarWithClass("org.aspectj.lang.JoinPoint", "AspectJ Runtime");
        this.addJarWithClass("org.apache.cactus.ServletTestCase", "Cactus Framework");
        this.addJarWithClass("org.apache.commons.logging.Log", "Commons-Logging");
        this.addJarWithClass("org.apache.commons.httpclient.HttpClient", "Commons-HttpClient");
        this.addJarWithClass("junit.framework.TestCase", "JUnit");
    }

    private void addJarWithClass(String theClassName, String theDescription) {
        String resourceName = "/" + theClassName.replace('.', '/') + ".class";
        if (this.srcFile != null) {
            try {
                DefaultWarArchive srcWar = new DefaultWarArchive(this.srcFile);
                if (srcWar.containsClass(theClassName)) {
                    this.log("The " + theDescription + " JAR is already present in " + "the WAR", 3);
                    return;
                }
            }
            catch (IOException ioe) {
                this.log("Problem reading source WAR to when trying to detect already present JAR files (" + ioe + ")", 1);
            }
        }
        ZipFileSet jar = new ZipFileSet();
        File file = ResourceUtils.getResourceLocation(resourceName);
        if (file != null) {
            jar.setFile(file);
            this.addLib(jar);
        } else {
            this.log("Could not find the " + theDescription + " JAR", 1);
            this.log("You need to add the JAR to the classpath of the task", 2);
            this.log("(Searched for class " + theClassName + ")", 4);
        }
    }

    private void addJspRedirector() {
        File jspRedirectorFile = new File(new File(System.getProperty("java.io.tmpdir")), "jspRedirector.jsp");
        jspRedirectorFile.deleteOnExit();
        try {
            ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/server/jspRedirector.jsp", jspRedirectorFile);
        }
        catch (IOException e) {
            this.log("Could not copy the JSP redirector (" + e.getMessage() + ")", 1);
        }
        FileSet fileSet = new FileSet();
        fileSet.setFile(jspRedirectorFile);
        this.addFileset(fileSet);
    }

    private void addRedirectorDefinitions(WebXml theWebXml) {
        boolean filterRedirectorDefined = false;
        boolean jspRedirectorDefined = false;
        boolean servletRedirectorDefined = false;
        Iterator i = this.redirectors.iterator();
        while (i.hasNext()) {
            Redirector redirector = (Redirector)i.next();
            if (redirector instanceof FilterRedirector) {
                filterRedirectorDefined = true;
            } else if (redirector instanceof JspRedirector) {
                jspRedirectorDefined = true;
            } else if (redirector instanceof ServletRedirector) {
                servletRedirectorDefined = true;
            }
            redirector.mergeInto(theWebXml);
        }
        if (!filterRedirectorDefined) {
            new FilterRedirector().mergeInto(theWebXml);
        }
        if (!servletRedirectorDefined) {
            new ServletRedirector().mergeInto(theWebXml);
        }
        if (!jspRedirectorDefined) {
            new JspRedirector().mergeInto(theWebXml);
        }
    }

    private File cactifyWebXml(WebXml theWebXml) {
        this.addRedirectorDefinitions(theWebXml);
        this.addJspRedirector();
        if (this.mergeWebXml != null) {
            try {
                WebXml parsedMergeWebXml = WebXmlIo.parseWebXmlFromFile(this.mergeWebXml, (EntityResolver)this.xmlCatalog);
                WebXmlMerger merger = new WebXmlMerger(theWebXml);
                merger.setLog(new AntLog((Task)this));
                merger = new WebXmlMerger(theWebXml);
                merger.setLog(new AntLog((Task)this));
                merger.merge(parsedMergeWebXml);
            }
            catch (IOException e) {
                throw new BuildException("Could not merge deployment descriptors", (Throwable)e);
            }
            catch (SAXException e) {
                throw new BuildException("Parsing of merge file failed", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new BuildException("XML parser configuration error", (Throwable)e);
            }
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        File tmpWebXml = fileUtils.createTempFile("cactus", "web.xml", this.getProject().getBaseDir());
        tmpWebXml.deleteOnExit();
        try {
            WebXmlIo.writeWebXml(theWebXml, tmpWebXml, null, true);
        }
        catch (IOException ioe) {
            throw new BuildException("Could not write temporary deployment descriptor", (Throwable)ioe);
        }
        return tmpWebXml;
    }

    private WebXml getOriginalWebXml() throws BuildException {
        DefaultWarArchive war = null;
        try {
            war = new DefaultWarArchive(this.srcFile);
            WebXml webXml = war.getWebXml();
            if (webXml == null) {
                throw new BuildException("The WAR source file does not contain a WEB-INF/web.xml deployment descriptor");
            }
            return webXml;
        }
        catch (SAXException e) {
            throw new BuildException("Parsing of web.xml deployment descriptor failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Failed to open WAR", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("XML parser configuration error", (Throwable)e);
        }
    }

    public static final class Version
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"2.2", "2.3"};
        }
    }

    public static final class ServletRedirector
    extends Redirector {
        public ServletRedirector() {
            this.name = "ServletRedirector";
            this.mapping = CactifyWarTask.DEFAULT_SERVLET_REDIRECTOR_MAPPING;
        }

        public void mergeInto(WebXml theWebXml) {
            theWebXml.addServlet(this.name, CactifyWarTask.SERVLET_REDIRECTOR_CLASS);
            theWebXml.addServletMapping(this.name, this.mapping);
            if (this.roles != null) {
                this.addSecurity(theWebXml);
            }
        }
    }

    public static final class JspRedirector
    extends Redirector {
        public JspRedirector() {
            this.name = "JspRedirector";
            this.mapping = CactifyWarTask.DEFAULT_JSP_REDIRECTOR_MAPPING;
        }

        public void mergeInto(WebXml theWebXml) {
            theWebXml.addJspFile(this.name, "/jspRedirector.jsp");
            theWebXml.addServletMapping(this.name, this.mapping);
            if (this.roles != null) {
                this.addSecurity(theWebXml);
            }
        }
    }

    public static final class FilterRedirector
    extends Redirector {
        public FilterRedirector() {
            this.name = "FilterRedirector";
            this.mapping = CactifyWarTask.DEFAULT_FILTER_REDIRECTOR_MAPPING;
        }

        public void mergeInto(WebXml theWebXml) {
            if (WebXmlVersion.V2_3.compareTo(theWebXml.getVersion()) <= 0) {
                theWebXml.addFilter(this.name, CactifyWarTask.FILTER_REDIRECTOR_CLASS);
                theWebXml.addFilterMapping(this.name, this.mapping);
                if (this.roles != null) {
                    this.addSecurity(theWebXml);
                }
            }
        }
    }

    public static abstract class Redirector {
        protected String name;
        protected String mapping;
        protected String roles;

        public abstract void mergeInto(WebXml var1);

        public final void setName(String theName) {
            this.name = theName;
        }

        public final void setMapping(String theMapping) {
            this.mapping = theMapping;
        }

        public final void setRoles(String theRoles) {
            this.roles = theRoles;
        }

        protected final void addSecurity(WebXml theWebXml) {
            StringTokenizer tokenizer = new StringTokenizer(this.roles, ",");
            ArrayList<String> roles = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String role = tokenizer.nextToken().trim();
                if (!theWebXml.hasSecurityRole(role)) {
                    theWebXml.addSecurityRole(role);
                }
                roles.add(role);
            }
            if (!roles.isEmpty()) {
                if (!theWebXml.hasLoginConfig()) {
                    theWebXml.setLoginConfig("BASIC", "myrealm");
                }
                if (!theWebXml.hasSecurityConstraint(this.mapping)) {
                    theWebXml.addSecurityConstraint("Cactus Test Redirector", this.mapping, roles);
                }
            }
        }
    }
}

