/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.servlet;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jp.haw.grain.framework.xml.BinaryXMLOutputter;
import jp.haw.grain.framework.xml.ParseException;
import org.apache.log4j.Logger;

public class BinaryXMLFilter
implements Filter {
    private static final Logger log = Logger.getLogger((Class)BinaryXMLFilter.class);
    public static final Pattern XML_CONTENT_TYPE_PATTERN = Pattern.compile("^\\w*/xml");
    public static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("^(.*?)(; ?charset=(.*))?$");
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String GBXML_CONTENT_TYPE = "application/gbxml";
    private String textEncoding = "UTF-8";
    private boolean ignoreRequestContentType = false;

    public void init(FilterConfig config) throws ServletException {
        String ignoreRequestContentType;
        String textEncoding = config.getInitParameter("TextEncoding");
        if (textEncoding != null) {
            this.textEncoding = textEncoding;
        }
        if ("true".equals(ignoreRequestContentType = config.getInitParameter("IgnoreRequestContentType"))) {
            this.ignoreRequestContentType = true;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contentType = ((HttpServletRequest)request).getContentType();
        log.debug((Object)("Request Content-Type: " + contentType));
        if (GBXML_CONTENT_TYPE.equals(contentType) || this.ignoreRequestContentType) {
            try {
                BinaryXMLEncodedServletResponse xmlResponse = new BinaryXMLEncodedServletResponse((HttpServletResponse)response);
                chain.doFilter(request, (ServletResponse)xmlResponse);
                xmlResponse.commit();
            }
            catch (ParseException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    class BinaryXMLEncodedServletResponse
    extends HttpServletResponseWrapper {
        private ResponseBuffer buffer;
        private String contentType;
        private String characterEncoding;
        private int contentLength;
        private boolean commited;

        public BinaryXMLEncodedServletResponse(HttpServletResponse response) {
            super(response);
            this.contentLength = -1;
        }

        public String getCharacterEncoding() {
            if (this.characterEncoding == null) {
                return BinaryXMLFilter.DEFAULT_CHARSET;
            }
            return this.characterEncoding;
        }

        public boolean isCommitted() {
            return this.commited;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public void setContentType(String contentType) {
            log.debug((Object)("request Content-Type to: " + contentType));
            if (this.buffer != null && this.isCommitted()) {
                return;
            }
            log.debug((Object)("setting Content-Type to: " + contentType));
            Matcher m = CONTENT_TYPE_PATTERN.matcher(contentType);
            if (!m.matches()) {
                return;
            }
            this.contentType = m.group(1);
            if (!this.usingWriter()) {
                this.characterEncoding = m.group(3);
            }
            log.debug((Object)("buffer: " + (this.buffer != null)));
        }

        public ServletOutputStream getOutputStream() throws IOException {
            log.debug((Object)"getOutputStream");
            if (this.buffer == null) {
                this.buffer = new BufferedServletOutputStream();
            }
            if (this.usingWriter()) {
                throw new IllegalStateException("method getWriter() was already called.");
            }
            return (ServletOutputStream)this.buffer;
        }

        public PrintWriter getWriter() throws IOException {
            log.debug((Object)"getWriter");
            if (this.buffer == null) {
                this.buffer = new BufferedPrintWriter();
            }
            if (this.usingOutputStream()) {
                throw new IllegalStateException("method getOutputStream() was already called.");
            }
            return (PrintWriter)((Object)this.buffer);
        }

        public void commit() throws IOException, ParseException {
            log.debug((Object)("commited content-type: " + this.contentType));
            if (this.isXML()) {
                log.debug((Object)"commit xml content-type: application/gbxml");
                super.setContentType(BinaryXMLFilter.GBXML_CONTENT_TYPE);
            } else {
                log.debug((Object)("commit non-xml content-type: " + this.contentType));
                if (this.characterEncoding == null || this.characterEncoding.length() == 0) {
                    super.setContentType(this.contentType);
                } else {
                    super.setContentType(this.contentType + ";charset=" + this.characterEncoding);
                }
                if (this.contentLength > -1) {
                    super.setContentLength(this.contentLength);
                }
            }
            if (this.buffer != null) {
                this.buffer.commit();
            }
        }

        private boolean isXML() {
            if (this.contentType == null) {
                return false;
            }
            return XML_CONTENT_TYPE_PATTERN.matcher(this.contentType).lookingAt();
        }

        private boolean usingWriter() {
            if (this.buffer == null) {
                return false;
            }
            return this.buffer instanceof PrintWriter;
        }

        private boolean usingOutputStream() {
            if (this.buffer == null) {
                return false;
            }
            return this.buffer instanceof ServletOutputStream;
        }

        class BufferedPrintWriter
        extends PrintWriter
        implements ResponseBuffer {
            public BufferedPrintWriter() {
                super(new CharArrayWriter());
            }

            public void commit() throws IOException, ParseException {
                CharArrayWriter buf = (CharArrayWriter)this.out;
                if (BinaryXMLEncodedServletResponse.this.isXML()) {
                    ServletOutputStream os = BinaryXMLEncodedServletResponse.this.getResponse().getOutputStream();
                    log.debug((Object)"encoded commit");
                    BinaryXMLOutputter bxo = new BinaryXMLOutputter(buf.toCharArray());
                    bxo.writeTo((OutputStream)os);
                } else {
                    log.debug((Object)"non encoded commit");
                    PrintWriter writer = BinaryXMLEncodedServletResponse.this.getResponse().getWriter();
                    writer.print(buf.toCharArray());
                }
            }

            public boolean isCharStream() {
                return true;
            }
        }

        class BufferedServletOutputStream
        extends ServletOutputStream
        implements ResponseBuffer {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            BufferedServletOutputStream() {
            }

            public void commit() throws IOException, ParseException {
                ServletOutputStream os = BinaryXMLEncodedServletResponse.this.getResponse().getOutputStream();
                if (BinaryXMLEncodedServletResponse.this.isXML()) {
                    BinaryXMLOutputter bxo = new BinaryXMLOutputter(this.buffer.toByteArray());
                    bxo.setTextEncoding(BinaryXMLFilter.this.textEncoding);
                    bxo.writeTo((OutputStream)os);
                } else {
                    log.debug((Object)"non encoded commit");
                    os.write(this.buffer.toByteArray());
                }
            }

            public void write(int data) throws IOException {
                this.buffer.write(data);
            }

            public void close() throws IOException {
                this.buffer.close();
            }

            public boolean isCharStream() {
                return false;
            }
        }
    }

    static interface ResponseBuffer {
        public void close() throws IOException;

        public void commit() throws IOException, ParseException;

        public boolean isCharStream();
    }
}

