/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import javax.servlet.ServletInputStream;
import jp.haw.grain.framework.xml.XMLOutputter;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class BinaryXMLInputStream
extends ServletInputStream {
    private static final Logger log = Logger.getLogger((Class)BinaryXMLInputStream.class);
    private XMLOutputter out;
    private boolean versionread = false;
    private ByteBuffer buffer;
    private CharsetEncoder encoder;

    public BinaryXMLInputStream(XMLOutputter out) {
        this.out = out;
        this.encoder = Charset.forName(out.getEncoding()).newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public int read() throws IOException {
        if (this.buffer == null || this.buffer.remaining() == 0) {
            this.allocateBuffer();
        }
        return this.buffer != null ? (int)this.buffer.get() : -1;
    }

    private void allocateBuffer() throws IOException {
        try {
            do {
                if (this.out.isEndOfDocument()) {
                    this.buffer = null;
                    return;
                }
                StringWriter writer = new StringWriter();
                this.out.writeNextTagTo(writer);
                this.buffer = this.encoder.encode(CharBuffer.wrap(writer.getBuffer()));
            } while (this.buffer.limit() == 0);
        }
        catch (XmlPullParserException e) {
            log.warn((Object)"parse error while filling buffer", (Throwable)e);
            try {
                throw new IOException("binary xml parse error").initCause(e);
            }
            catch (Throwable throwable) {
            }
        }
        catch (IOException e) {
            log.warn((Object)"io error while parsing", (Throwable)e);
            throw e;
        }
    }
}

