/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class XMLUtils {
    XMLUtils() {
    }

    static String getChildNodeValue(Element root, String childNodeName) throws SAXException {
        return XMLUtils.getChildNodeValue(root, childNodeName, null);
    }

    static String getChildNodeValue(Element root, String childNodeName, String defaultValue) throws SAXException {
        NodeList nl = root.getElementsByTagName(childNodeName);
        if (nl.getLength() == 1) {
            return XMLUtils.getTextValue(nl.item(0)).trim();
        }
        if (defaultValue == null) {
            throw new SAXException("Node <" + root.getNodeName() + "> has no child named <" + childNodeName + ">");
        }
        return defaultValue;
    }

    static String getTextValue(Node node) throws SAXException {
        Node textNode = node.getFirstChild();
        if (textNode == null) {
            return "";
        }
        if (textNode.getNodeType() != 3) {
            throw new SAXException("No text value found for <" + node.getNodeName() + "> node");
        }
        return textNode.getNodeValue();
    }

    static boolean hasChildNode(Element root, String childNodeName) {
        NodeList nl = root.getElementsByTagName(childNodeName);
        return nl.getLength() > 0;
    }
}

